/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.RaportIntrariEntry;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;

public class IntrariReport
extends AbstractReportPanel
implements CleanupRequired {
    private ContaLogic logic;
    private JComboBox furnizoriCombo;
    private JComboBox societati;
    private JComboBox tipComanda;
    private JComboBox taguri;
    private JComboBox magaziiCombo;
    private XComboBox stockCombo;
    private FilterableComboBoxModel xStocksComboModel;
    private double totalAchizitie;
    private double totalVanzare;
    private double cantTotala;
    private JLabel totalAczLabel;
    private JLabel totalVzLabel;
    private JLabel cantitateTotala;
    public static final String[] columns = new String[]{LangRoAll.denumire, "Furnizor", LangRoAll.factura, "Nr Nir", LangRoAll.data, Utils.getTranslation(LangRoAll.magazie, new String[0]), LangRoAll.cantitate, "P. achitizie", "V. achizitie", "Tva achizitie", "P. vanzare", "V. vanzare", "Tva vanzare", "Adaos"};
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static Comparator dataSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportIntrariEntry ri1 = (RaportIntrariEntry)o1;
            RaportIntrariEntry ri2 = (RaportIntrariEntry)o2;
            return ri1.getData().compareToIgnoreCase(ri2.getData());
        }
    };
    private static Comparator denumireSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportIntrariEntry ri1 = (RaportIntrariEntry)o1;
            RaportIntrariEntry ri2 = (RaportIntrariEntry)o2;
            return ri1.getStock().compareToIgnoreCase(ri2.getStock());
        }
    };
    private static Comparator furnizorSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportIntrariEntry ri1 = (RaportIntrariEntry)o1;
            RaportIntrariEntry ri2 = (RaportIntrariEntry)o2;
            return ri1.getFurnizor().compareToIgnoreCase(ri2.getFurnizor());
        }
    };
    private static Comparator facturaSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportIntrariEntry ri1 = (RaportIntrariEntry)o1;
            RaportIntrariEntry ri2 = (RaportIntrariEntry)o2;
            return ri1.getFactura().compareToIgnoreCase(ri2.getFactura());
        }
    };
    private static Comparator nrNirSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportIntrariEntry ri1 = (RaportIntrariEntry)o1;
            RaportIntrariEntry ri2 = (RaportIntrariEntry)o2;
            return ri1.getNrNir().compareToIgnoreCase(ri2.getNrNir());
        }
    };
    private static Comparator magazieSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            RaportIntrariEntry ri1 = (RaportIntrariEntry)o1;
            RaportIntrariEntry ri2 = (RaportIntrariEntry)o2;
            return ri1.getMagazie().compareToIgnoreCase(ri2.getMagazie());
        }
    };

    public IntrariReport() {
        this.logic = ContaLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object o = this.stockCombo.getSelectedItem();
        if (o == null || o instanceof String) {
            result.put("id_stock_key", -1);
        } else {
            Stock s = (Stock)o;
            result.put("id_stock_key", s.getId());
        }
        if (ComboUtils.anythingButAllSelected(this.furnizoriCombo)) {
            Client f = (Client)this.furnizoriCombo.getSelectedItem();
            result.put("facturi_furnizor_key", f.getId());
        } else {
            result.put("facturi_furnizor_key", -1);
        }
        this.printCriteria.remove("Societate");
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled() && ComboUtils.anythingButAllSelected(this.societati)) {
            ClientPersJuridica societate = (ClientPersJuridica)this.societati.getSelectedItem();
            result.put("Societate", societate);
            this.printCriteria.put("Societate", societate.getCompanyName());
        }
        if (ComboUtils.anythingButAllSelected(this.tipComanda)) {
            StockLogic.COMANDA_TYPE c = (StockLogic.COMANDA_TYPE)((Object)this.tipComanda.getSelectedItem());
            result.put("Comanda Type", (Object)c);
        }
        if (ComboUtils.anythingButAllSelected(this.taguri)) {
            Tag tag = (Tag)this.taguri.getSelectedItem();
            result.put("", tag);
        }
        if (ComboUtils.anythingButAllSelected(this.magaziiCombo)) {
            Magazie m = (Magazie)this.magaziiCombo.getSelectedItem();
            result.put("id_magazie", m.getId());
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        this.societati = new JComboBox();
        c.gridy = 0;
        c.gridx = 0;
        if (FacturiLogic.getInstance().isMultipleSocietatiEnabled()) {
            c.weightx = 0.0;
            result.add((Component)new JLabel("Societatea"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.societati, c);
            ++c.gridy;
            c.gridx = 0;
        }
        c.weightx = 0.0;
        result.add((Component)new JLabel("Ingredient"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.stockCombo = new XComboBox(this.xStocksComboModel);
        this.stockCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        result.add((Component)this.stockCombo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Furnizor"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.furnizoriCombo = new JComboBox();
        result.add((Component)this.furnizoriCombo, c);
        this.tipComanda = new JComboBox();
        if (VpConfig.getInstance().futureStocksEnabled) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            result.add((Component)new JLabel("Tip Comanda"), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.tipComanda, c);
        }
        this.taguri = new JComboBox();
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tag"), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.taguri, c);
        this.magaziiCombo = new JComboBox();
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.magaziiCombo, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportIntrariEntry fe = (RaportIntrariEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getStock();
                    }
                    case 1: {
                        return fe.getFurnizor();
                    }
                    case 2: {
                        return fe.getFactura();
                    }
                    case 3: {
                        return fe.getNrNir();
                    }
                    case 4: {
                        return fe.getData();
                    }
                    case 5: {
                        return fe.getMagazie();
                    }
                    case 6: {
                        return Utils.getString3Decimals(fe.getCantitate());
                    }
                    case 7: {
                        return Utils.getString2Decimals(fe.getPretCumparare());
                    }
                    case 8: {
                        return Utils.getString2Decimals(fe.getValoareCumparare());
                    }
                    case 9: {
                        return Utils.getString2Decimals(fe.getTvaCumparare());
                    }
                    case 10: {
                        return Utils.getString2Decimals(fe.getPretVanzare());
                    }
                    case 11: {
                        return Utils.getString2Decimals(fe.getValoareVanzare());
                    }
                    case 12: {
                        return Utils.getString2Decimals(fe.getTvaVanzare());
                    }
                    case 13: {
                        return Utils.getString2Decimals(fe.getAdaos());
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total achizitie"), c);
        ++c.gridx;
        this.totalAczLabel = new JLabel("");
        result.add((Component)this.totalAczLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total vanzare"), c);
        ++c.gridx;
        this.totalVzLabel = new JLabel("");
        result.add((Component)this.totalVzLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Cantitate totala"), c);
        ++c.gridx;
        this.cantitateTotala = new JLabel("");
        result.add((Component)this.cantitateTotala, c);
        return result;
    }

    @Override
    public String getName() {
        return "Raport intrari";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getRaportIntrari(criteria, this.whatToPrint);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.data);
        this.totalAczLabel.setText(Utils.getString2Decimals(this.totalAchizitie));
        this.totalVzLabel.setText(Utils.getString2Decimals(this.totalVanzare));
        this.cantitateTotala.setText(Utils.getString2Decimals(this.cantTotala));
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    RaportIntrariEntry entry = (RaportIntrariEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getStock());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getFurnizor());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getFactura());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getNrNir());
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, entry.getData());
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, entry.getMagazie());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(6, row, entry.getCantitate()));
                        sheet.addCell((WritableCell)new Number(7, row, entry.getPretCumparare()));
                        sheet.addCell((WritableCell)new Number(8, row, entry.getValoareCumparare()));
                        sheet.addCell((WritableCell)new Number(9, row, entry.getTvaCumparare()));
                        sheet.addCell((WritableCell)new Number(10, row, entry.getPretVanzare()));
                        sheet.addCell((WritableCell)new Number(11, row, entry.getValoareVanzare()));
                        sheet.addCell((WritableCell)new Number(12, row, entry.getTvaVanzare()));
                        sheet.addCell((WritableCell)new Number(13, row, entry.getAdaos()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return IntrariReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.furnizoriCombo, ContaLogic.getInstance().getFurnizori(-1), true);
        ComboUtils.replaceItemsForCombo(this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
        ComboUtils.replaceItemsForCombo(this.tipComanda, StockLogic.getComandaTypeCollection(), true);
        ComboUtils.replaceItemsForCombo(this.taguri, TagsLogic.getInstance().getAllTags(), true);
        ComboUtils.replaceItemsForCombo(this.magaziiCombo, StockLogic.getInstance().getMagazii(), true);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(IntrariReport.this.furnizoriCombo, IntrariReport.this.logic.getFurnizori(-1), true);
                ComboUtils.replaceItemsForCombo(IntrariReport.this.societati, ClientLogic.getInstance().getSocietatiPropriiSorted());
            }

            @Override
            public String getName() {
                return "IntrariReport_persJuridica";
            }
        }, 42);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                IntrariReport.this.xStocksComboModel.refresh(StockLogic.getInstance().getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "IntrariReport_stocks";
            }
        }, 26);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(IntrariReport.this.taguri, TagsLogic.getInstance().getAllTags(), true);
            }

            @Override
            public String getName() {
                return "IntrariReport_tags";
            }
        }, Constants.TAGS_CHANGED);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(IntrariReport.this.magaziiCombo, StockLogic.getInstance().getMagazii(), true);
            }

            @Override
            public String getName() {
                return "IntrariReport_magazii";
            }
        }, 27);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 7: {
                        return IntrariReport.this.totalAczLabel.getText();
                    }
                    case 9: {
                        return IntrariReport.this.totalVzLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return IntrariReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return IntrariReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                RaportIntrariEntry fe = (RaportIntrariEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getStock();
                    }
                    case 1: {
                        return fe.getFurnizor();
                    }
                    case 2: {
                        return fe.getFactura();
                    }
                    case 3: {
                        return fe.getNrNir();
                    }
                    case 4: {
                        return fe.getData();
                    }
                    case 5: {
                        return fe.getMagazie();
                    }
                    case 6: {
                        return Utils.getString3Decimals(fe.getCantitate());
                    }
                    case 7: {
                        return Utils.getString2Decimals(fe.getPretCumparare());
                    }
                    case 8: {
                        return Utils.getString2Decimals(fe.getValoareCumparare());
                    }
                    case 9: {
                        return Utils.getString2Decimals(fe.getTvaCumparare());
                    }
                    case 10: {
                        return Utils.getString2Decimals(fe.getPretVanzare());
                    }
                    case 11: {
                        return Utils.getString2Decimals(fe.getValoareVanzare());
                    }
                    case 12: {
                        return Utils.getString2Decimals(fe.getTvaVanzare());
                    }
                    case 13: {
                        return Utils.getString2Decimals(fe.getAdaos());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return denumireSorter;
            }
            case 1: {
                return furnizorSorter;
            }
            case 2: {
                return facturaSorter;
            }
            case 3: {
                return nrNirSorter;
            }
            case 4: {
                return dataSorter;
            }
            case 5: {
                return magazieSorter;
            }
        }
        return null;
    }

    private void computeTotals(Vector items) {
        this.totalAchizitie = 0.0;
        this.totalVanzare = 0.0;
        this.cantTotala = 0.0;
        for (int i = 0; i < items.size(); ++i) {
            RaportIntrariEntry o = (RaportIntrariEntry)items.elementAt(i);
            this.totalAchizitie += o.getValoareCumparare();
            this.totalVanzare += o.getValoareVanzare();
            this.cantTotala += o.getCantitate();
        }
    }

    @Override
    public void cleanup() {
        this.furnizoriCombo.removeAllItems();
    }
}

