/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.gui.InvoicedCollectedEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class InvoicedCollectedReport
extends AbstractReportPanel {
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JLabel totalInvoicedLabel;
    private JLabel totalCollectedLabel;
    private JLabel totalRatioLabel;
    public static final String[] columns = new String[]{"Luna", "Facturat", LangRoAll.incasat, "Rata"};
    private JComboBox clientiCombo;
    private JComboBox aniCombo;
    private JComboBox tipCombo;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Object client = this.clientiCombo.getSelectedItem();
        if (ComboUtils.anythingButAllSelected(this.clientiCombo)) {
            Client c = (Client)client;
            result.put(Constants.CLIENT_KEY, c.getId());
            this.printCriteria.put(Constants.CLIENT_KEY, c.toString());
        } else {
            result.put(Constants.CLIENT_KEY, -1);
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        String tip = (String)this.tipCombo.getSelectedItem();
        result.put("Colectat", tip);
        this.printCriteria.put("Colectat", tip);
        String an = (String)this.aniCombo.getSelectedItem();
        result.put("An", an);
        this.printCriteria.put("An", an);
        this.printCriteria.put(LangRoAll.dataRaportarii, Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ContaLogic.getInstance().getInvoicedCollected(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    InvoicedCollectedEntry fe = (InvoicedCollectedEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, fe.getPeriod());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getInvoiced()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getCollected()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getRatio()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return InvoicedCollectedReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Facturat/Colectat";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(4), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                InvoicedCollectedEntry fe = (InvoicedCollectedEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getPeriod();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.getInvoiced());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getCollected());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getRatio());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total Facturat"), c);
        ++c.gridx;
        this.totalInvoicedLabel = new JLabel("");
        result.add((Component)this.totalInvoicedLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total Incasat"), c);
        ++c.gridx;
        this.totalCollectedLabel = new JLabel("");
        result.add((Component)this.totalCollectedLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Total Ratio"), c);
        ++c.gridx;
        this.totalRatioLabel = new JLabel("");
        result.add((Component)this.totalRatioLabel, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clientiCombo = new JComboBox();
        result.add((Component)this.clientiCombo, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Anul"), c);
        ++c.gridx;
        this.aniCombo = new JComboBox();
        result.add((Component)this.aniCombo, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Colectat"), c);
        ++c.gridx;
        this.tipCombo = new JComboBox();
        result.add((Component)this.tipCombo, c);
        return result;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public void refreshTotalPanel() {
        double totalFacturi = 0.0;
        double totalPlatit = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            InvoicedCollectedEntry o = (InvoicedCollectedEntry)this.data.elementAt(i);
            totalFacturi += o.getInvoiced();
            totalPlatit += o.getCollected();
        }
        this.totalInvoicedLabel.setText(Utils.getString2Decimals(totalFacturi));
        this.totalCollectedLabel.setText(Utils.getString2Decimals(totalPlatit));
        double ratio = totalPlatit * 100.0 / totalFacturi;
        this.totalRatioLabel.setText(Utils.getString2Decimals(ratio));
    }

    @Override
    public void doStuff() {
        int year;
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return InvoicedCollectedReport.this.totalInvoicedLabel.getText();
                    }
                    case 2: {
                        return InvoicedCollectedReport.this.totalCollectedLabel.getText();
                    }
                    case 3: {
                        return InvoicedCollectedReport.this.totalRatioLabel.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return InvoicedCollectedReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return InvoicedCollectedReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                InvoicedCollectedEntry fe = (InvoicedCollectedEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getPeriod();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.getInvoiced());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getCollected());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getRatio());
                    }
                }
                return null;
            }
        };
        ComboUtils.replaceItemsForCombo(this.clientiCombo, (Collection)ContaLogic.getInstance().getClienti(-1), true);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(InvoicedCollectedReport.this.clientiCombo, (Collection)ContaLogic.getInstance().getClienti(-1), true);
            }

            @Override
            public String getName() {
                return "FacturiClientiReport_clienti";
            }
        }, 42);
        for (int i = year = DateUtils.getYear(new Date()); i >= 2005; --i) {
            this.aniCombo.addItem("" + i);
        }
        this.tipCombo.addItem("in luna respectiva");
        this.tipCombo.addItem("aferent lunii respective");
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

