/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.gui.ProfitFacturiReportEntryDetalii;
import ro.atreides.contabilitate.gui.ProfitReportPanelEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ProfitFacturiReportPanel
extends AbstractReportPanel {
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;
    private JLabel totalCuTvaLabel;
    private JLabel totalFaraTvaLabel;
    private JLabel totalIesiriLabel;
    private JLabel totalAdaosLabel;
    private FilterableComboBoxModel clientsComboModel;
    private JTextField nrFacturaField;
    private JComboBox agenti;
    private XComboBox clienti;

    private String[] buildColumns() {
        Vector<String> columns = new Vector<String>();
        columns.add(LangRoAll.client);
        columns.add(LangRoAll.data);
        columns.add("Nr factura");
        columns.add("Vz cu TVA");
        columns.add("Vz f. TVA");
        columns.add("Total iesiri");
        columns.add("Total adaos");
        if (VpConfig.getInstance().profitabilitateFacturiDetalii) {
            Vector<Magazie> magazii = StockLogic.getInstance().getMagazii();
            for (int i = 0; i < magazii.size(); ++i) {
                Magazie o = magazii.elementAt(i);
                columns.add("Vz " + o.getLabel());
                columns.add("Iesire " + o.getLabel());
                columns.add("Adaos " + o.getLabel());
            }
        }
        return Utils.getStringArray(columns);
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        String nrFactura = this.nrFacturaField.getText();
        if (Validators.correctString(nrFactura)) {
            result.put("Numar factura", nrFactura);
            this.printCriteria.put("Numar factura", nrFactura);
        } else {
            this.printCriteria.remove("Numar factura");
        }
        if (ComboUtils.anythingButAllSelected(this.clienti)) {
            Client c = (Client)this.clienti.getSelectedItem();
            result.put(Constants.CLIENT_KEY, c.getId());
            this.printCriteria.put(Constants.CLIENT_KEY, c.toString());
        } else {
            result.put(Constants.CLIENT_KEY, -1);
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.agenti)) {
            User u = (User)this.agenti.getSelectedItem();
            result.put("Agent", u.getId());
            this.printCriteria.put("Agent", u.toString());
        } else {
            this.printCriteria.remove("Agent");
            result.put("Agent", -1);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ContaLogic.getInstance().getProfitabilitateFacturi(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ProfitReportPanelEntry pe = (ProfitReportPanelEntry)o;
                    try {
                        Label label = new Label(0, row, pe.getClient());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, pe.getData());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, pe.getNrFactura());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(3, row, pe.getVzTva()));
                        sheet.addCell((WritableCell)new Number(4, row, pe.getVzFrTva()));
                        sheet.addCell((WritableCell)new Number(5, row, ProfitFacturiReportPanel.this.returnTotalIesiri(pe)));
                        sheet.addCell((WritableCell)new Number(6, row, ProfitFacturiReportPanel.this.returnTotalAdaos(pe)));
                        if (VpConfig.getInstance().profitabilitateFacturiDetalii) {
                            Vector detalii = pe.getDetaliiMagazii();
                            for (int i = 0; i < detalii.size(); ++i) {
                                ProfitFacturiReportEntryDetalii det = (ProfitFacturiReportEntryDetalii)detalii.elementAt(i);
                                sheet.addCell((WritableCell)new Number(i * 3 + 7, row, det.getValVz()));
                                sheet.addCell((WritableCell)new Number(i * 3 + 8, row, det.getValIesire()));
                                sheet.addCell((WritableCell)new Number(i * 3 + 9, row, det.getAdaos()));
                            }
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return ProfitFacturiReportPanel.this.buildColumns();
                }

                @Override
                public String getSheetName() {
                    return ProfitFacturiReportPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Profitabilitate facturi";
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(this.buildColumns(), Utils.getStringClass(this.buildColumns().length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ProfitReportPanelEntry pe = (ProfitReportPanelEntry)data.elementAt(rowIndex);
                return ProfitFacturiReportPanel.this.getCellContent(pe, columnIndex);
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        this.totalCuTvaLabel = new JLabel();
        this.totalFaraTvaLabel = new JLabel();
        this.totalIesiriLabel = new JLabel();
        this.totalAdaosLabel = new JLabel();
        result.add(new JLabel("Total "));
        result.add((Component)this.totalCuTvaLabel, "");
        result.add(new JLabel("Total fara TVA "));
        result.add((Component)this.totalFaraTvaLabel, "");
        result.add(new JLabel("Total iesiri "));
        result.add((Component)this.totalIesiriLabel, "");
        result.add(new JLabel("Total adaos"));
        result.add(this.totalAdaosLabel);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Numar factura"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrFacturaField = new JTextField(20);
        result.add((Component)this.nrFacturaField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        result.add((Component)this.clienti, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Agent"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.agenti = new JComboBox();
        result.add((Component)this.agenti, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        Vector data = this.tm.getData();
        double total = 0.0;
        double totalFaraTva = 0.0;
        double totalIesiri = 0.0;
        double totalAdaos = 0.0;
        for (Object o : data) {
            if (!(o instanceof ProfitReportPanelEntry)) continue;
            ProfitReportPanelEntry prpe = (ProfitReportPanelEntry)o;
            total += prpe.getVzTva();
            totalFaraTva += prpe.getVzFrTva();
            totalIesiri += this.returnTotalIesiri(prpe);
            totalAdaos += this.returnTotalAdaos(prpe);
        }
        this.totalCuTvaLabel.setText(Utils.getString2Decimals(total));
        this.totalFaraTvaLabel.setText(Utils.getString2Decimals(totalFaraTva));
        this.totalIesiriLabel.setText(Utils.getString2Decimals(totalIesiri));
        this.totalAdaosLabel.setText(Utils.getString2Decimals(totalAdaos));
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return ProfitFacturiReportPanel.this.buildColumns().length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return ProfitFacturiReportPanel.this.buildColumns()[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return ProfitFacturiReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ProfitFacturiReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                return this.getCellContent((ProfitReportPanelEntry)row, column);
            }
        };
        ComboUtils.replaceItemsForCombo(this.agenti, UsersLogic.getInstance().getUsersInGroup("group_agenti"));
    }

    private String getCellContent(ProfitReportPanelEntry pe, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return pe.getClient();
            }
            case 1: {
                return pe.getData();
            }
            case 2: {
                return pe.getNrFactura();
            }
            case 3: {
                return Utils.getString2Decimals(pe.getVzTva());
            }
            case 4: {
                return Utils.getString2Decimals(pe.getVzFrTva());
            }
            case 5: {
                return Utils.getString2Decimals(this.returnTotalIesiri(pe));
            }
            case 6: {
                return Utils.getString2Decimals(this.returnTotalAdaos(pe));
            }
        }
        if (VpConfig.getInstance().profitabilitateFacturiDetalii) {
            Vector detalii = pe.getDetaliiMagazii();
            int offset = columnIndex - 7;
            int magazieIndex = offset / 3;
            int fieldIndex = offset - magazieIndex * 3;
            ProfitFacturiReportEntryDetalii det = (ProfitFacturiReportEntryDetalii)detalii.elementAt(magazieIndex);
            switch (fieldIndex) {
                case 0: {
                    return Utils.getString2Decimals(det.getValVz());
                }
                case 1: {
                    return Utils.getString2Decimals(det.getValIesire());
                }
                case 2: {
                    return Utils.getString2Decimals(det.getAdaos());
                }
            }
            return null;
        }
        return null;
    }

    private double returnTotalIesiri(ProfitReportPanelEntry pe) {
        double result = 0.0;
        Vector detalii = pe.getDetaliiMagazii();
        for (Object o : detalii) {
            ProfitFacturiReportEntryDetalii det = (ProfitFacturiReportEntryDetalii)o;
            result += det.getValIesire();
        }
        return result;
    }

    private double returnTotalAdaos(ProfitReportPanelEntry pe) {
        double result = pe.getVzFrTva() - this.returnTotalIesiri(pe);
        return result;
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

