/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.gui.ResumeEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.MonthYearDateSelector;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ResumePanel
extends AbstractReportPanel {
    public static final String[] columns = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " "};
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put("Inregistrari pana la ", Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        this.printCriteria.put(LangRoAll.dataRaportarii, Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ResumeEntry re = (ResumeEntry)data.get(rowIndex);
                return re.getCellContentAt(columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public String getName() {
        return "Resume Financiar";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ContaLogic.getInstance().getFinanciarResumeReport(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ResumeEntry re = (ResumeEntry)o;
                    try {
                        for (int i = 0; i < columns.length; ++i) {
                            Label label = new Label(i, row, re.getCellContentAt(i));
                            sheet.addCell((WritableCell)label);
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return ResumePanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return ResumePanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ResumePanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ResumeEntry re = (ResumeEntry)row;
                return re.getCellContentAt(column);
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return new MonthYearDateSelector();
    }
}

