/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.PartenerGroup;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.gui.SituatieParteneriEntry;
import ro.atreides.print.PrintLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class SituatieParteneriReport
extends AbstractReportPanel {
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JLabel totalFacturiEmise;
    private JLabel totalFacturiPrimite;
    private JLabel balataFacturi;
    private JLabel deIncasat;
    private JLabel dePlata;
    private JLabel balantaPlati;
    public static final String[] columns = new String[]{LangRoAll.partener, LangRoAll.facturiEmise, LangRoAll.facturiPrimite, LangRoAll.balantaObligatii, LangRoAll.deIncasat, LangRoAll.dePlata, LangRoAll.balantaMonetar};
    private MultiboxList grupuriCombo;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String groupIds = "";
        String groupNames = "";
        Vector items = this.grupuriCombo.getSelectedItems();
        for (int i = 0; i < items.size(); ++i) {
            PartenerGroup pg = (PartenerGroup)items.elementAt(i);
            groupIds = groupIds + pg.getId();
            groupNames = groupNames + pg.getLabel();
            if (i >= items.size() - 1) continue;
            groupIds = groupIds + ",";
            groupNames = groupNames + ",";
        }
        result.put("Grupuri", groupIds);
        this.printCriteria.put("Grupuri", groupNames);
        this.printCriteria.put(LangRoAll.dataRaportarii, Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return ContaLogic.getInstance().getSituatieParteneri(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    SituatieParteneriEntry fe = (SituatieParteneriEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, fe.getPartener());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getFacturiEmise()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getFacturiPrimite()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getBalantaFacturi()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getDeincasat()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getDeplata()));
                        sheet.addCell((WritableCell)new Number(++column, row, fe.getBalantaPlati()));
                        ++column;
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return SituatieParteneriReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return LangRoAll.situatieParteneri;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                SituatieParteneriEntry fe = (SituatieParteneriEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getPartener();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.getFacturiEmise());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getFacturiPrimite());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getBalantaFacturi());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getDeincasat());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.getDeplata());
                    }
                    case 6: {
                        return Utils.getString2Decimals(fe.getBalantaPlati());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(LangRoAll.facturiEmise), c);
        ++c.gridx;
        this.totalFacturiEmise = new JLabel("");
        result.add((Component)this.totalFacturiEmise, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.facturiPrimite), c);
        ++c.gridx;
        this.totalFacturiPrimite = new JLabel("");
        result.add((Component)this.totalFacturiPrimite, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.balantaObligatii), c);
        ++c.gridx;
        this.balataFacturi = new JLabel("");
        result.add((Component)this.balataFacturi, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.deIncasat), c);
        ++c.gridx;
        this.deIncasat = new JLabel("");
        result.add((Component)this.deIncasat, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.dePlata), c);
        ++c.gridx;
        this.dePlata = new JLabel("");
        result.add((Component)this.dePlata, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.balantaMonetar), c);
        ++c.gridx;
        this.balantaPlati = new JLabel("");
        result.add((Component)this.balantaPlati, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        Vector<PartenerGroup> allItems = ClientLogic.getInstance().getParteneriGroups();
        this.grupuriCombo = new MultiboxList(allItems, 10);
        this.grupuriCombo.setSelectedItems(allItems, false);
        result.add((Component)this.grupuriCombo, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        double f5 = 0.0;
        double f6 = 0.0;
        for (int i = 0; i < this.data.size(); ++i) {
            SituatieParteneriEntry se = (SituatieParteneriEntry)this.data.elementAt(i);
            f1 += se.getFacturiEmise();
            f2 += se.getFacturiPrimite();
            f3 += se.getDeincasat();
            f4 += se.getDeplata();
        }
        f5 = f1 - f2;
        f6 = f3 - f4;
        this.totalFacturiEmise.setText(Utils.getString2Decimals(f1));
        this.totalFacturiPrimite.setText(Utils.getString2Decimals(f2));
        this.deIncasat.setText(Utils.getString2Decimals(f3));
        this.dePlata.setText(Utils.getString2Decimals(f4));
        this.balataFacturi.setText(Utils.getString2Decimals(f5));
        this.balantaPlati.setText(Utils.getString2Decimals(f6));
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return SituatieParteneriReport.this.totalFacturiEmise.getText();
                    }
                    case 2: {
                        return SituatieParteneriReport.this.totalFacturiPrimite.getText();
                    }
                    case 3: {
                        return SituatieParteneriReport.this.balataFacturi.getText();
                    }
                    case 4: {
                        return SituatieParteneriReport.this.deIncasat.getText();
                    }
                    case 5: {
                        return SituatieParteneriReport.this.dePlata.getText();
                    }
                    case 6: {
                        return SituatieParteneriReport.this.balantaPlati.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return SituatieParteneriReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return SituatieParteneriReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                SituatieParteneriEntry fe = (SituatieParteneriEntry)row;
                switch (column) {
                    case 0: {
                        return fe.getPartener();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.getFacturiEmise());
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getFacturiPrimite());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getBalantaFacturi());
                    }
                    case 4: {
                        return Utils.getString2Decimals(fe.getDeincasat());
                    }
                    case 5: {
                        return Utils.getString2Decimals(fe.getDeplata());
                    }
                    case 6: {
                        return Utils.getString2Decimals(fe.getBalantaPlati());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }
}

