/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports;

import ro.atreides.contabilitate.imports.GenericFacturaXlsImporterInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.gui.Validators;

public class GenericFacturaXlsImporter
implements ExcelImportInterface {
    private boolean completed;
    private boolean tableHeader;
    private String magazia;
    private String numeProdus;
    private String um;
    private String codBare;
    private String categoria;
    private double cantitate;
    private double pretAchizitie;
    private double pretVanzare;
    private int line = 0;
    private GenericFacturaXlsImporterInterface inter;

    public GenericFacturaXlsImporter(GenericFacturaXlsImporterInterface inter) {
        this.inter = inter;
    }

    @Override
    public void lineEnd() {
        ++this.line;
        if (this.line == 5319) {
            System.out.println("last line");
        }
        if (this.line >= 5320) {
            System.out.println("depasire");
        }
        if (!this.tableHeader && this.completed) {
            this.inter.importLine(this.magazia, this.categoria, this.numeProdus, this.um, this.codBare, this.cantitate, this.pretAchizitie, this.pretVanzare, this.line);
        }
    }

    @Override
    public void lineStart() {
        this.completed = false;
    }

    @Override
    public void sheetStart(String sheetName) {
    }

    @Override
    public void sheetEnd(String sheetName) {
        this.inter.importLine("", "", "", "", "", 0.0, 0.0, 0.0, this.line);
    }

    @Override
    public void valueRead(int row, int column, String value) {
        if (column == 0) {
            this.completed = true;
            this.pretVanzare = 0.0;
            this.tableHeader = false;
        }
        if (row == 0) {
            this.completed = false;
            this.tableHeader = true;
            return;
        }
        if (!this.completed) {
            return;
        }
        switch (column) {
            case 0: {
                if (Validators.correctString(value)) {
                    this.magazia = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 1: {
                if (Validators.correctString(value)) {
                    this.categoria = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 2: {
                if (Validators.correctString(value)) {
                    this.numeProdus = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 3: {
                if (Validators.correctString(value)) {
                    this.um = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 4: {
                if (Validators.correctString(value)) {
                    this.codBare = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 5: {
                if (Validators.correctDouble(value)) {
                    this.cantitate = Utils.parseDouble(value);
                    break;
                }
                this.completed = false;
                break;
            }
            case 6: {
                if (Validators.correctDouble(value)) {
                    this.pretAchizitie = Utils.parseDouble(value);
                    break;
                }
                this.completed = false;
                break;
            }
            case 7: {
                if (Validators.correctDouble(value)) {
                    this.pretVanzare = Utils.parseDouble(value);
                    break;
                }
                this.completed = false;
                break;
            }
        }
    }
}

