/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports.ciel;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class CielFacturiVanzareImporter {
    private ConnectionPool pool = ConnectionPool.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFacturiVanzare(String borderouInputFile, String tranzatiiInputFile, int idSocietateaNoastra) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(borderouInputFile));
            String line = reader.readLine();
            int lineNumber = 1;
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String status = (String)fields.get(2);
                if (status.equalsIgnoreCase("Validat")) {
                    String nrDocument = (String)fields.get(0);
                    int nrDoc = Utils.getNumberFromMixedString(nrDocument);
                    String dataS = (String)fields.get(1);
                    String scadentaS = (String)fields.get(7);
                    try {
                        Date d = Formatters.CIEL_NIR_IMPORT_FORMAT.parse(dataS);
                        Date scandenta = Formatters.CIEL_NIR_IMPORT_FORMAT.parse(scadentaS);
                        Timestamp dataT = new Timestamp(d.getTime());
                        Timestamp scadentaT = new Timestamp(scandenta.getTime());
                        String clientS = (String)fields.get(4);
                        Vector ff = Utils.splitString(clientS, ':');
                        String clientName = (String)ff.get(1);
                        clientName = clientName.trim();
                        Client client = ClientLogic.getInstance().getClientByNameNoCommit(clientName);
                        if (client != null) {
                            String magazieS = (String)fields.get(5);
                            Magazie m = StockLogic.getInstance().getMagazieByLabel(magazieS);
                            if (m != null) {
                                String agentS = (String)fields.get(6);
                                if (Validators.correctString(agentS)) {
                                    User agent = UsersLogic.getInstance().getUserByLogin(agentS);
                                    if (agent != null) {
                                        String valoareFaraTvaS = (String)fields.get(11);
                                        String valoareTvaS = (String)fields.get(12);
                                        String valoareTotalaS = (String)fields.get(13);
                                        valoareFaraTvaS = valoareFaraTvaS.replaceAll(",", "");
                                        valoareTvaS = valoareTvaS.replaceAll(",", "");
                                        valoareTotalaS = valoareTotalaS.replaceAll(",", "");
                                        double val1 = Utils.parseDouble(valoareFaraTvaS);
                                        double val2 = Utils.parseDouble(valoareTvaS);
                                        double val3 = Utils.parseDouble(valoareTotalaS);
                                        double cotaTva = val3 / val1 - 1.0;
                                        cotaTva = FloatUtils.roundFloat(cotaTva, 2);
                                        Tva tva = TvaLogic.getInstance().getTvaByCota(cotaTva);
                                        if (tva != null) {
                                            Vector items = this.importItemsForFactura(tranzatiiInputFile, nrDocument, m, cotaTva, clientName);
                                            FacturiLogic.getInstance().addFactura(client.getId(), val1, val2, val3, "", nrDoc, dataT, items, agent.getId(), scadentaT, 2, new Vector(), nrDoc + "", "", false, 2, idSocietateaNoastra, StockLogic.COMANDA_TYPE.EFECTUAT);
                                        } else {
                                            Logger.logWarning(this, "Linia: " + lineNumber + " TVA " + cotaTva + " nu a fost gasit . Linie ignorata");
                                        }
                                    } else {
                                        Logger.logWarning(this, "Linia: " + lineNumber + " Agentul " + agentS + " nu a fost gasit. Linie ignorata");
                                    }
                                } else {
                                    Logger.logWarning(this, "Linia: " + lineNumber + " Agentul nespecificat. Linie ignorata");
                                }
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + " Magazia " + magazieS + " nu a fost gasita . Linie ignorata");
                            }
                        } else {
                            Logger.logWarning(this, "Linia: " + lineNumber + " Clientul " + clientName + " nu a fost gasit . Linie ignorata");
                        }
                    }
                    catch (ParseException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
                line = reader.readLine();
                ++lineNumber;
            }
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector importItemsForFactura(String inputFile, String nrDocument, Magazie m, double cotaTva, String requestedClient) throws IOException, SQLException {
        Vector<FacturaItemView> result = new Vector<FacturaItemView>();
        LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
        String line = reader.readLine();
        int lineNumber = 1;
        while (line != null) {
            if (line.startsWith(nrDocument)) {
                System.out.println("line: " + line);
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String client = (String)fields.get(1);
                if (client.startsWith(requestedClient)) {
                    String codS = (String)fields.get(2);
                    String quantityS = (String)fields.get(4);
                    String valoareS = (String)fields.get(8);
                    String valoareCuTvaS = (String)fields.get(9);
                    Product p = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(codS);
                    if (p != null) {
                        int idStock = StockLogic.getInstance().getStockInterface().getIdStockForProductNoCommit(p.getId());
                        if (idStock != -1) {
                            Stock stock = StockLogic.getInstance().getStockById(idStock);
                            int idUnit = stock.getIdUnit();
                            Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(idUnit);
                            if (u != null) {
                                String productName = stock.getLabel();
                                String unitName = u.getLabel();
                                double q = Utils.parseDouble(quantityS);
                                double valoareFaraTva = Utils.parseDouble(valoareS);
                                double pretUnitarFaraTva = valoareFaraTva / q;
                                double valoareCuTva = Utils.parseDouble(valoareCuTvaS);
                                double pretUnitarCuTva = valoareCuTva / q;
                                double tva = valoareCuTva - valoareFaraTva;
                                FacturaItemView toAdd = new FacturaItemView(-1, q, m.getId(), p.getId(), m.getLabel(), pretUnitarFaraTva, productName, unitName, valoareFaraTva, tva, pretUnitarCuTva, valoareCuTva, cotaTva, -1.0, -1.0, -1.0, -1.0, -1.0, "");
                                result.add(toAdd);
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + "Unitatea de masura asociata produsului : " + p.getName() + " nu exista in baza de date . Linie ignorata");
                            }
                        } else {
                            Logger.logWarning(this, "Linia: " + lineNumber + "Stocul asociat produsului : " + p.getName() + " nu exista in baza de date . Linie ignorata");
                        }
                    } else {
                        Logger.logWarning(this, "Linia: " + lineNumber + " Codul " + codS + " nu exista in baza de date . Linie ignorata");
                    }
                } else {
                    Logger.logWarning(this, "Linia: " + lineNumber + " Caut clientul " + requestedClient + " dar am gasit " + client + " . Linie ignorata");
                }
            }
            line = reader.readLine();
            ++lineNumber;
        }
        return result;
    }
}

