/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.contabilitate.imports.ciel;

import java.awt.Component;
import ro.atreides.contabilitate.gui.EditNirAddEntryInterface;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.units.UnitsLogic;

public class CielInvertarLaZiImporterFromExcel
implements ExcelImportInterface {
    private boolean completed;
    private String codBare;
    private double cantitate;
    private double pretAchizitie;
    private String unitName;
    private int line = 0;
    private Component parent;
    private Magazie magazie;
    private StockLogic stockLogic;
    private EditNirAddEntryInterface inter;

    public CielInvertarLaZiImporterFromExcel(Component parent, StockLogic logic, Magazie m, EditNirAddEntryInterface inter) {
        this.parent = parent;
        this.stockLogic = logic;
        this.magazie = m;
        this.inter = inter;
    }

    @Override
    public void sheetEnd(String sheetName) {
    }

    @Override
    public void lineEnd() {
        ++this.line;
        if (!this.completed) {
            DialogUtils.errorDialog(this.parent, "Linia " + this.line + " este definita incorect si va fi ignorata.", "Linie ignorata");
            return;
        }
        Unit unit = UnitsLogic.getInstance().getUnitByName(this.unitName);
        if (unit == null) {
            DialogUtils.errorDialog(this.parent, "Unitatea de masura " + this.unitName + " nu exista.", "Linie ignorata");
            return;
        }
        Product product = NomeclaturaLogic.getInstance().getProductByCodBare(this.codBare);
        if (product != null) {
            int idStock = this.stockLogic.getStockInterface().getIdStock(product.getId());
            if (idStock > 0) {
                this.inter.addEntry(idStock, product.getName(), unit.getLabel(), this.cantitate, this.pretAchizitie, -1.0, unit.getId(), this.magazie.getId(), this.magazie.getLabel(), 1);
            } else {
                DialogUtils.errorDialog(this.parent, "Cod bare \"" + this.codBare + "\" neasociat cu un produs finit.", "Linie ignorata");
            }
        } else {
            DialogUtils.errorDialog(this.parent, "Cod bare \"" + this.codBare + "\" inexistent.", "Linie ignorata");
            return;
        }
    }

    @Override
    public void lineStart() {
        this.completed = true;
    }

    @Override
    public void sheetStart(String sheetName) {
    }

    @Override
    public void valueRead(int row, int column, String value) {
        if (row == 0) {
            this.completed = false;
            return;
        }
        if (!this.completed) {
            return;
        }
        switch (column) {
            case 4: {
                if (Validators.correctString(value)) {
                    this.codBare = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 5: {
                if (Validators.correctString(value)) {
                    this.unitName = value;
                    break;
                }
                this.completed = false;
                break;
            }
            case 7: {
                if (Validators.correctDouble(value)) {
                    this.cantitate = Utils.parseDouble(value);
                    break;
                }
                this.completed = false;
                break;
            }
            case 11: {
                if (Validators.correctDouble(value)) {
                    this.pretAchizitie = Utils.parseDouble(value);
                    break;
                }
                this.completed = false;
                break;
            }
        }
    }
}

