/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.utils.Logger;
import ro.atreides.utils.web.WebServerInterface;

public class EcrFactory {
    public static Hashtable<String, Properties> launcherProperties = new Hashtable();
    private static String[] availableModels = new String[]{"datecs.Generic", "aclas.Generic", "incotex.Generic", "webxml.Generic", "datecs.NativeDP50", "datecs.Fprint", "client.Generic", "sapel.Generic", "total.Generic", "activa.Generic", "elcom.Generic", "elcom2.Generic", "orgtech.Generic", "elka.Generic", "partner.Generic", "optimus.Generic", "optimus.TangoDrv", "eltrade.Generic", "euro.Generic", "carat.Prima", "mercury.Generic", "chd.Generic", "rompos.Generic", "cashprn.Generic", "xkube.Generic", "optima.Generic", "optima.Optikey", "datecsgen3.Generic", "carat.Generic", "datecs.NewMP55"};

    public static AbstractCashRegister buildEcr(String ecrType, boolean licenceRequired, WebServerInterface webServerInterface) throws RuntimeException {
        Properties properties;
        if (ecrType == null) {
            return null;
        }
        String realType = null;
        String allTypesString = "";
        for (int i = 0; i < availableModels.length; ++i) {
            String type = availableModels[i];
            if (type.equalsIgnoreCase(ecrType)) {
                realType = type;
            }
            allTypesString = allTypesString + type + ",";
        }
        if (realType == null) {
            RuntimeException ex = new RuntimeException("Modelul cerut nu este disponibil. Va rugam incercati unul dintre : " + allTypesString);
            Logger.logException("EcrFactory", (Exception)ex);
        }
        if ((properties = launcherProperties.get(ecrType)) == null) {
            String configFile = "conf" + File.separator + "ecr" + File.separator + ecrType + ".properties";
            try {
                Properties conf = new Properties();
                conf.load(new FileInputStream(configFile));
                properties = conf;
            }
            catch (IOException e) {
                RuntimeException ex = new RuntimeException("Fisierul " + configFile + " este necesar. Contactati suportul tehnic");
                Logger.logException("EcrFactory", (Exception)ex);
            }
        }
        String packageName = "ro.atreides.ecr";
        AbstractCashRegister result = null;
        try {
            result = (AbstractCashRegister)Class.forName(packageName + "." + realType).newInstance();
            result.buildConfiguration(properties);
            result.setLicenseRequired(licenceRequired);
            result.setWebserver(webServerInterface);
            result.finishInitialize();
        }
        catch (ClassNotFoundException e) {
            Logger.logException("EcrFactory", (Exception)e);
        }
        catch (InstantiationException e) {
            Logger.logException("EcrFactory", (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException("EcrFactory", (Exception)e);
        }
        catch (RuntimeException e) {
            Logger.logException("EcrFactory", (Exception)e);
        }
        return result;
    }
}

