/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.MultiboxList;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.licensing.ExportEnums;
import ro.deversoft.licensing.ExportLicense;
import ro.deversoft.licensing.LicenseBean;
import ro.deversoft.licensing.LicenseBeanInterface;

public class EcrLicensePanel
extends JPanel {
    private JTextField bdID;
    private JTextField clientName;
    private JTextField brand;
    private JTextField societate;
    private JTextField cui;
    private JTextField hddId;
    private JTextField sequence;
    private JTextField dataExpirare;
    private JTextField mainVersion;
    private JTextField emailAddress;
    private JTextField mobileNumber;
    private JComboBox<String> chosenApp;
    private MultiboxList modulesMultichoiceCombo;
    private JDialog dialog;
    private LicenseBean resultLicense;
    public static final String defaultMainVersion = "2016";
    public static final int maxLicenseDays = 380;

    public EcrLicensePanel(LicenseBean existingData, String APPS_URL, String MODULES_URL) {
        this.setLayout((LayoutManager)new MigLayout());
        Map<String, List<Map<String, String>>> attributes = existingData.getAttributes();
        List<Map<String, String>> list = attributes.get(ExportEnums.LicenseMicrosheet.Licenta_App.name());
        Map<String, String> licentaAppMap = list.get(0);
        Map<String, String> commonAttr = existingData.getCommonAttr();
        this.emailAddress = new JTextField(30);
        this.emailAddress.setEditable(true);
        this.add(new JLabel("Adresa email - aici veti primi licenta (*)"));
        this.add((Component)this.emailAddress, "wrap");
        this.mobileNumber = new JTextField(20);
        this.mobileNumber.setEditable(true);
        this.add(new JLabel("Telefon mobil - daca avem neclaritati (*)"));
        this.add((Component)this.mobileNumber, "wrap");
        List<Map<String, String>> contactsList = attributes.get(ExportEnums.LicenseMicrosheet.DateContact.name());
        for (Map<String, String> contactMap : contactsList) {
            String tipS = contactMap.get(ExportEnums.DateContact.tip.name());
            String valoare = contactMap.get(ExportEnums.DateContact.valoare.name());
            ExportEnums.DateContact_Tip tip = ExportEnums.DateContact_Tip.valueOf(tipS);
            switch (tip) {
                case Email: {
                    this.emailAddress.setText(valoare);
                    break;
                }
                case Tel: {
                    this.mobileNumber.setText(valoare);
                }
            }
        }
        final String mobil = this.mobileNumber.getText();
        final String email = this.emailAddress.getText();
        this.clientName = new JTextField(20);
        this.clientName.setEditable(true);
        this.add(new JLabel("Client / Grup (*)"));
        this.add((Component)this.clientName, "wrap");
        final String clientName1 = existingData.getClientName();
        this.clientName.setText(clientName1);
        this.bdID = new JTextField(20);
        this.bdID.setEditable(true);
        this.add(new JLabel("Locatie / Punct de lucru (*)"));
        this.add((Component)this.bdID, "wrap");
        final String bdID1 = existingData.getBdID();
        this.bdID.setText(bdID1);
        this.brand = new JTextField(20);
        this.brand.setEditable(true);
        this.add(new JLabel("Brand (*)"));
        this.add((Component)this.brand, "wrap");
        final String brandS = commonAttr.get(ExportEnums.Licenta_Attr_Comune.brand.name());
        this.brand.setText(brandS);
        this.societate = new JTextField(20);
        this.societate.setEditable(true);
        this.add(new JLabel("Societate (*)"));
        this.add((Component)this.societate, "wrap");
        final String societateS = commonAttr.get(ExportEnums.Licenta_Attr_Comune.societate.name());
        this.societate.setText(societateS);
        this.cui = new JTextField(20);
        this.cui.setEditable(true);
        this.add(new JLabel("CUI (*)"));
        this.add((Component)this.cui, "wrap");
        final String cuiS = commonAttr.get(ExportEnums.Licenta_Attr_Comune.cui.name());
        this.cui.setText(cuiS);
        this.add(new JLabel("Tip licenta (*)"));
        ExportLicense.getInstance();
        Vector<String> apps = ExportLicense.parseFileFromUrl(APPS_URL);
        this.chosenApp = new JComboBox<String>(apps);
        String licenta = licentaAppMap.get(ExportEnums.Licenta_App.tip_aplicatie.name());
        this.chosenApp.setSelectedItem(licenta);
        this.add(this.chosenApp, "wrap");
        ExportLicense.getInstance();
        Vector<String> modules = ExportLicense.parseFileFromUrl(MODULES_URL);
        this.modulesMultichoiceCombo = new MultiboxList(modules, 10);
        if (modules.size() > 0) {
            this.modulesMultichoiceCombo.setSelectedItems(modules, false);
            this.add(new JLabel("Module suplimentare (*)"));
            this.add((Component)this.modulesMultichoiceCombo, "wrap");
        }
        this.hddId = new JTextField(20);
        this.hddId.setEditable(true);
        this.add(new JLabel("Identificator hardware (*)"));
        this.add((Component)this.hddId, "wrap");
        final String hdd = licentaAppMap.get(ExportEnums.Licenta_App.hdd_id.name());
        this.hddId.setText(hdd);
        this.sequence = new JTextField(5);
        this.sequence.setEditable(true);
        this.add(new JLabel("Secventa curenta (*)"));
        String seqS = licentaAppMap.get(ExportEnums.Licenta_App.sequence.name());
        final int currentSeq = Integer.parseInt(seqS);
        this.sequence.setText(seqS);
        this.sequence.setEditable(false);
        this.add((Component)this.sequence, "wrap");
        this.dataExpirare = new JTextField(10);
        this.dataExpirare.setEditable(true);
        this.add(new JLabel("Noua licenta va fi valabila pana la (*)"));
        this.add((Component)this.dataExpirare, "wrap");
        String expirareS = licentaAppMap.get(ExportEnums.Licenta_App.data_expirare.name());
        Date newExpireDate = DateUtils.addDaysToDate(new Date(), 380);
        this.dataExpirare.setText(Formatters.DATE_FORMAT.format(newExpireDate));
        this.mainVersion = new JTextField(10);
        this.mainVersion.setEditable(false);
        this.add(new JLabel("Versiune majora (*)"));
        this.add((Component)this.mainVersion, "wrap");
        String mainVersionS = licentaAppMap.get(ExportEnums.Licenta_App.main_version.name());
        this.mainVersion.setText(mainVersionS);
        final EcrLicensePanel panel = this;
        JButton save = new JButton("Trimite cererea");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date newExpireDate;
                block14: {
                    if (!Validators.correctString(EcrLicensePanel.this.emailAddress.getText())) {
                        DialogUtils.errorDialog(panel, "Adresa email incorecta", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.emailAddress.setText(email);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.mobileNumber.getText())) {
                        DialogUtils.errorDialog(panel, "Numar mobil incorect", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.mobileNumber.setText(mobil);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.clientName.getText())) {
                        DialogUtils.errorDialog(panel, "Client incorect", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.clientName.setText(clientName1);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.bdID.getText())) {
                        DialogUtils.errorDialog(panel, "Identificator baza incorect", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.bdID.setText(bdID1);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.brand.getText())) {
                        DialogUtils.errorDialog(panel, "Brand incorect", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.brand.setText(brandS);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.societate.getText())) {
                        DialogUtils.errorDialog(panel, "Societate incorecta", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.societate.setText(societateS);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.cui.getText())) {
                        DialogUtils.errorDialog(panel, "CUI incorect", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.cui.setText(cuiS);
                        return;
                    }
                    if (!Validators.correctString(EcrLicensePanel.this.mainVersion.getText())) {
                        DialogUtils.errorDialog(panel, "Identificator hardware incorect", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.hddId.setText(hdd);
                        return;
                    }
                    if (!Validators.correctInteger(EcrLicensePanel.this.sequence.getText())) {
                        DialogUtils.errorDialog(panel, "Secventa incorecta", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.sequence.setText(currentSeq + "");
                        return;
                    }
                    int userLastSeq = Integer.parseInt(EcrLicensePanel.this.sequence.getText());
                    if (userLastSeq < currentSeq && !DialogUtils.confirmDialog(panel, "Secventa introdusa " + userLastSeq + " este mai mica decat ultima secventa " + currentSeq + " . Doriti sa continuati ", LangRoAll.confirmare)) {
                        EcrLicensePanel.this.sequence.setText(currentSeq + "");
                        return;
                    }
                    Date proposedExpireDate = DateUtils.addDaysToDate(new Date(), 380);
                    newExpireDate = null;
                    try {
                        newExpireDate = Formatters.DATE_FORMAT.parse(EcrLicensePanel.this.dataExpirare.getText());
                        Date maxExpireDate = DateUtils.addDaysToDate(new Date(), 380);
                        if (!newExpireDate.after(maxExpireDate)) break block14;
                        if (DialogUtils.confirmDialog(panel, "Licenta se acorda pe maxim 380 zile, adica pana la " + Formatters.DATE_FORMAT.format(maxExpireDate) + " . Folosim aceasta data ", LangRoAll.confirmare)) {
                            newExpireDate = maxExpireDate;
                            break block14;
                        }
                        EcrLicensePanel.this.dataExpirare.setText(Formatters.DATE_FORMAT.format(proposedExpireDate));
                        return;
                    }
                    catch (ParseException e1) {
                        DialogUtils.errorDialog(panel, "Data expirare incorecta", LangRoAll.nuPotContinua);
                        EcrLicensePanel.this.dataExpirare.setText(Formatters.DATE_FORMAT.format(proposedExpireDate));
                        return;
                    }
                }
                final Date expireDateFinal = newExpireDate;
                if (!Validators.correctString(EcrLicensePanel.this.mainVersion.getText())) {
                    DialogUtils.errorDialog(panel, "Versiune majora incorecta", LangRoAll.nuPotContinua);
                    EcrLicensePanel.this.mainVersion.setText(EcrLicensePanel.defaultMainVersion);
                    return;
                }
                ExportLicense.getInstance();
                EcrLicensePanel.this.resultLicense = ExportLicense.composeNewLicenseBean(new LicenseBeanInterface(){

                    @Override
                    public Date getExpireDate() {
                        return expireDateFinal;
                    }

                    @Override
                    public String getChosenApp() {
                        return EcrLicensePanel.this.chosenApp.getSelectedItem().toString();
                    }

                    @Override
                    public Vector<String> getChosenModules() {
                        Vector selected = EcrLicensePanel.this.modulesMultichoiceCombo.getSelectedItems();
                        String printString = "";
                        for (int i = 0; i < selected.size(); ++i) {
                            String modul = (String)selected.elementAt(i);
                            printString = printString + modul;
                            if (i >= selected.size() - 1) continue;
                            printString = printString + ",";
                        }
                        Vector moduleString = Utils.splitString(printString, ',');
                        return moduleString;
                    }

                    @Override
                    public String getBrand() {
                        return EcrLicensePanel.this.brand.getText();
                    }

                    @Override
                    public String getSocietate() {
                        return EcrLicensePanel.this.societate.getText();
                    }

                    @Override
                    public String getCui() {
                        return EcrLicensePanel.this.cui.getText();
                    }

                    @Override
                    public String getPCName() {
                        return "ecr_" + EcrLicensePanel.this.hddId.getText();
                    }

                    @Override
                    public String getDBId() {
                        return EcrLicensePanel.this.bdID.getText();
                    }

                    @Override
                    public String getClientName() {
                        return EcrLicensePanel.this.clientName.getText();
                    }

                    @Override
                    public String getHDDId() {
                        return EcrLicensePanel.this.hddId.getText();
                    }

                    @Override
                    public int getCurrentSequence() {
                        return Integer.parseInt(EcrLicensePanel.this.sequence.getText());
                    }

                    @Override
                    public String getMajorVersion() {
                        return EcrLicensePanel.this.mainVersion.getText();
                    }

                    @Override
                    public String getEmailAddress() {
                        return EcrLicensePanel.this.emailAddress.getText();
                    }

                    @Override
                    public String getMobileNumber() {
                        return EcrLicensePanel.this.mobileNumber.getText();
                    }
                });
                EcrLicensePanel.this.dialog.dispose();
            }
        });
        this.add(save);
        JButton cancel = new JButton("Renunta");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcrLicensePanel.this.dialog.dispose();
            }
        });
        this.add((Component)cancel, "wrap");
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public LicenseBean getResultLicense() {
        return this.resultLicense;
    }
}

