/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.mortbay.jetty.Server;
import org.mortbay.util.InetAddrPort;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.ScalaXmlImporter;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.web.WebServerInterface;

public class EcrMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        Properties properties;
        Logger.grabOutput = true;
        EcrMain.deleteErrorsFile();
        Logger.getInstance(6, "ecr.log");
        String file = Utils.getCmdlineValue("-file", args, "");
        String nativeFile = Utils.getCmdlineValue("-nativefile", args, "");
        String nativeDir = Utils.getCmdlineValue("-nativedir", args, "");
        String portS = Utils.getCmdlineValue("-webserverport", args, "");
        String scalaFile = Utils.getCmdlineValue("-scalaFile", args, "");
        String scalaDir = Utils.getCmdlineValue("-scalaDir", args, "");
        String licenseCode = Utils.getCmdlineValue("-licenseCode", args, "");
        String nativeFileCharset = Utils.getCmdlineValue("-nativeFileCharset", args);
        String secondsWaitBeforeExit = Utils.getCmdlineValue("-secondsWait", args, "30000");
        int secondsWait = -1;
        File errorDir = FileUtils.getCurrentDirAsFile();
        File readFromDir = null;
        if (Validators.correctInteger(secondsWaitBeforeExit)) {
            secondsWait = Integer.parseInt(secondsWaitBeforeExit);
        }
        Logger.logDebug("EcrMain", args.toString());
        EcrLogic reader = EcrLogic.getInstance(args, true, null);
        final AbstractCashRegister cashRegister = reader.getEcr();
        if (Validators.correctString(licenseCode)) {
            cashRegister.addLicenseCode(licenseCode);
        }
        boolean startServer = false;
        if (Validators.correctString(file)) {
            Logger.logDebug("EcrMain", "processing standard XML file");
            cashRegister.processXml(file);
        } else if (Validators.correctString(nativeFile)) {
            Logger.logDebug("EcrMain", "processing standard native file");
            try {
                String content = FileUtils.readFileToString(nativeFile);
                cashRegister.processBonFiscal(content, "1", -1, null, null, null);
            }
            catch (IOException e) {
                Logger.logException("EcrMain", (Exception)e);
            }
        } else if (Validators.correctString(nativeDir)) {
            Logger.logDebug("EcrMain", "processing native dir :" + nativeDir + " in DAEMON MODE ");
            readFromDir = new File(nativeDir);
            if (!readFromDir.exists() || readFromDir.isFile()) {
                DialogUtils.errorDialog(null, "Director inexistent : " + nativeDir, LangRoAll.nuPotContinua);
                System.exit(1);
            }
            reader.startDirDaemon(readFromDir, cashRegister, nativeFileCharset, "*.inp,*.bon");
            startServer = true;
        } else if (Validators.correctString(scalaFile)) {
            Logger.logDebug("EcrMain", "processing scala XML file");
            try {
                properties = new Properties();
                properties.load(new FileInputStream("conf/ecr/scala_ecr.properties"));
                File currentFile = new File(scalaFile);
                EcrMain.processScalaXmlFile(properties, currentFile, cashRegister);
            }
            catch (Exception e) {
                Logger.logException("EcrMain", e);
                System.exit(1);
            }
        } else if (Validators.correctString(scalaDir)) {
            Logger.logDebug("EcrMain", "processing scala XML dir :" + scalaDir + " in DAEMON MODE ");
            try {
                properties = new Properties();
                properties.load(new FileInputStream("conf/ecr/scala_ecr.properties"));
                final File dir = new File(scalaDir);
                if (!dir.exists() || dir.isFile()) {
                    DialogUtils.errorDialog(null, "Director inexistent : " + scalaDir, LangRoAll.nuPotContinua);
                    System.exit(1);
                }
                Thread scalaReaderThread = new Thread(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            File[] xmlFiles = dir.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    String fname = name.toLowerCase();
                                    return fname.endsWith(".xml");
                                }
                            });
                            if (xmlFiles != null && xmlFiles.length > 0) {
                                for (int i = 0; i < xmlFiles.length; ++i) {
                                    File currentFile = xmlFiles[i];
                                    try {
                                        EcrMain.processScalaXmlFile(properties, currentFile, cashRegister);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        Logger.logException(this, e);
                                        System.exit(1);
                                    }
                                }
                            }
                            Utils.systemExit();
                        }
                    }
                };
                scalaReaderThread.setName("Scala reader thread");
                scalaReaderThread.start();
            }
            catch (Exception e) {
                Logger.logException("EcrMain", e);
                System.exit(1);
            }
            startServer = true;
        } else {
            startServer = true;
        }
        if (Validators.correctInteger(portS) && startServer) {
            Logger.logDebug("EcrMain", "starting as daemon webserver");
            try {
                int port = Integer.parseInt(portS);
                final Server s = new Server();
                s.addListener(new InetAddrPort(port));
                cashRegister.setWebserver(new WebServerInterface(){

                    @Override
                    public Object prepareWebServer(int port) {
                        return s;
                    }
                });
                s.start();
            }
            catch (Exception e) {
                Logger.logException("EcrMain", e);
            }
        } else {
            final boolean startServerFinal = startServer;
            final File errorDirFinal = readFromDir != null ? readFromDir : errorDir;
            final Object waitO = new Object();
            cashRegister.addListener(new EcrFeedbackInterface(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void bonFinished(int idOrder, int nrBon, int nrZ, int idCasa, MP55Impl.CASA_EXPLAIN_MESSAGES explain_messages, String orderIdentifier, boolean lastBon) {
                    String s = "OK;Z=" + nrZ + "|NR=" + nrBon + "|UNIQUE_ID=" + orderIdentifier;
                    EcrMain.writeErrorsToFile(errorDirFinal, s, orderIdentifier);
                    if (lastBon && !startServerFinal) {
                        Object object = waitO;
                        synchronized (object) {
                            waitO.notify();
                        }
                    }
                }
            });
            Object object = waitO;
            synchronized (object) {
                try {
                    if (secondsWait > 0) {
                        waitO.wait(secondsWait);
                    } else {
                        waitO.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Utils.systemExit();
        }
    }

    private static void writeErrorsToFile(File currentDir, String s, String originalFilename) {
        try {
            String file = "errors_" + originalFilename + "_" + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date()) + ".txt";
            String absFile = currentDir.getAbsolutePath() + File.separator + file;
            FileUtils.writeTextToFile(absFile, s);
        }
        catch (IOException e) {
            Logger.logException(EcrMain.class.getName(), (Exception)e);
        }
    }

    private static void deleteErrorsFile() {
        new File("errors.txt").delete();
    }

    private static synchronized void processScalaXmlFile(Properties properties, File scalaFile, AbstractCashRegister cashRegister) throws Exception {
        ScalaXmlImporter handler = new ScalaXmlImporter(properties);
        Utils.importXml((DefaultHandler)handler, scalaFile.getAbsolutePath());
        Vector<String> toCheck = new Vector<String>();
        double total = 0.0;
        for (EcrSale ecrSale : handler.getSales()) {
            total += ecrSale.getQuantity() * ecrSale.getPpuOriginal();
            String detalii = ecrSale.getProduct() + " CANT: " + ecrSale.getQuantity() + " PRET UNITAR : " + ecrSale.getPpuDupaDiscount();
            toCheck.add(detalii);
        }
        TipPlata cashDefault = null;
        String title = "Verificati produsele !!";
        String message = Utils.getStringForJDialogList(title, "", toCheck);
        DialogUtils.okDialog(null, message, title);
        if (DialogUtils.confirmDialog(null, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare)) {
            cashRegister.printBonFiscal(handler.getSales(), total, handler.getPlati(), cashDefault, handler.getComments(), "", -1);
        } else {
            DialogUtils.errorDialog(null, LangRoAll.operatieEsuata, LangRoAll.nuPotContinua);
        }
        scalaFile.renameTo(new File(scalaFile.getAbsolutePath() + "_done"));
    }
}

