/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.EcrFactory;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLicensePanel;
import ro.atreides.ecr.EcrLicenseVerifier;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrMain;
import ro.atreides.ecr.EcrPrevalidareType;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.EcrUserFeedbackInterface;
import ro.atreides.ecr.SerialLibraryType;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.PidFileUtil;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.licensing.ExportLicense;
import ro.deversoft.licensing.ExportLicenseInterface;
import ro.deversoft.licensing.ExportUtils;
import ro.deversoft.licensing.LicenseBean;
import ro.deversoft.licensing.LicenseBeanInterface;
import ro.deversoft.licensing.ResellerKey;

public class EcrMainGui
extends JFrame {
    private Component panel;
    private Properties configs;
    private static final String configFile = "conf" + File.separator + "ecr.properties";
    private JComboBox<EcrType> tipuriEcr = new JComboBox<EcrType>(EcrType.values());
    private JComboBox<SerialLibraryType> tipLibrarieSeriala = new JComboBox<SerialLibraryType>(SerialLibraryType.values());
    private JComboBox<EcrPrevalidareType> tipuriPrevalidare = new JComboBox<EcrPrevalidareType>(EcrPrevalidareType.values());
    private final JTextField portField = new JTextField(10);
    private final JTextField speedField = new JTextField(10);
    private final JTextField nativeDir = new JTextField(30);
    private final JTextField nativeCharset = new JTextField(10);
    private final JTextField nativeExtension = new JTextField(10);
    final JTextField produsEliberareNume = new JTextField(20);
    final JTextField produsEliberareCod = new JTextField(5);
    final JTextField produsEliberareCodDepartament = new JTextField(5);
    final JTextField produsEliberareTvaCod = new JTextField(3);
    final JTextField produsEliberareTvaCota = new JTextField(5);
    final JTextField produsComisionNume = new JTextField(10);
    final JTextField produsComisionCod = new JTextField(5);
    final JTextField produsComisionCodDepartament = new JTextField(5);
    final JTextField produsComisionTvaCod = new JTextField(3);
    final JTextField produsComisionTvaCota = new JTextField(5);
    final JTextField tipPlataCardCodCasa = new JTextField(3);
    final JTextField tipPlataCardNume = new JTextField(3);
    final JTextField comisionProcent = new JTextField(3);
    final JTextPane area = new JTextPane();
    private JScrollPane logScrollPane;
    private String areaText = "";
    private JButton cereLicenta;
    private ResellerKey resellerKey;
    private SystemTray tray;
    private TrayIcon trayIcon;

    public EcrMainGui(Properties configs1) {
        this.panel = this;
        this.configs = configs1;
        this.resellerKey = ResellerKey.getResellerKeyFromFile("reseller_key.json");
        if (this.resellerKey == null) {
            DialogUtils.errorDialog(this.panel, "Lipsa fisier reseller_key.json", "Programul se va inchide");
            Utils.systemExit();
        }
        if (!this.resellerKey.verifyChecksum()) {
            DialogUtils.errorDialog(this.panel, "Fisier reseller_key.json corupt !!", "Programul se va inchide");
            Utils.systemExit();
        }
        if (SystemTray.isSupported()) {
            System.out.println("system tray supported");
            this.tray = SystemTray.getSystemTray();
            this.setDefaultCloseOperation(1);
            BufferedImage img = null;
            try {
                img = ImageIO.read(ClassLoader.getSystemResource("images/dever_logo_mic.png"));
                this.setIconImage(img);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PopupMenu popup = new PopupMenu();
            MenuItem exit = new MenuItem("Inchide driver");
            exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EcrMainGui.this.inchideApp();
                }
            });
            popup.add(exit);
            MenuItem afiseaza = new MenuItem("Afiseaza");
            afiseaza.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EcrMainGui.this.setVisible(true);
                    EcrMainGui.this.setExtendedState(0);
                }
            });
            popup.add(afiseaza);
            MenuItem ascunde = new MenuItem("Ascunde");
            ascunde.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EcrMainGui.this.setVisible(false);
                    EcrMainGui.this.setExtendedState(1);
                }
            });
            popup.add(ascunde);
            this.trayIcon = new TrayIcon(img, "FiscalWire", popup);
            this.trayIcon.setImageAutoSize(true);
            try {
                this.tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            this.setIconImage(img);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (EcrMainGui.this.isVisible()) {
                        EcrMainGui.this.setVisible(false);
                        EcrMainGui.this.setExtendedState(1);
                    } else {
                        EcrMainGui.this.setVisible(true);
                        EcrMainGui.this.setExtendedState(0);
                    }
                }
            });
        } else {
            this.setDefaultCloseOperation(3);
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout());
        JTabbedPane panes = new JTabbedPane();
        String ecrType = this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString());
        EcrType ecrDef = EcrType.valueOf(ecrType);
        JPanel panel2 = new JPanel((LayoutManager)new MigLayout("", "grow"));
        panel2.add((Component)this.buildCommSettingsPanel(), "span 3, wrap, growx");
        panel2.add((Component)this.buildDirectorySettingsPanel(), "span 3, wrap, growx");
        panel2.add((Component)this.buildCashbackSettingsPanel(ecrDef), "span 3, wrap, growx");
        JButton salveaza = new JButton("Salveaza si Restart");
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentPassword = DialogUtils.passwordDialog(EcrMainGui.this.panel, "Introduceti parola de configurare");
                if (currentPassword != null && EcrMainGui.this.verifySettingsPassword(currentPassword)) {
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ecrPort.toString(), EcrMainGui.this.portField.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ecrSpeed.toString(), EcrMainGui.this.speedField.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString(), EcrMainGui.this.tipuriEcr.getSelectedItem().toString());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.SERIAL_TYPE.toString(), EcrMainGui.this.tipLibrarieSeriala.getSelectedItem().toString());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_DIR.toString(), EcrMainGui.this.nativeDir.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_CHARSET.toString(), EcrMainGui.this.nativeCharset.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_EXTENSIONS.toString(), EcrMainGui.this.nativeExtension.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_TVA_COD.toString(), EcrMainGui.this.produsEliberareTvaCod.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_TVA_COTA.toString(), EcrMainGui.this.produsComisionTvaCota.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_PRODUS_NUME.toString(), EcrMainGui.this.produsEliberareNume.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_PRODUS_COD.toString(), EcrMainGui.this.produsEliberareCod.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_PRODUS_CODDEPARTAMENT.toString(), EcrMainGui.this.produsComisionCodDepartament.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.CARD_CODCASA.toString(), EcrMainGui.this.tipPlataCardCodCasa.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.CARD_NUME.toString(), EcrMainGui.this.tipPlataCardNume.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PROCENT.toString(), EcrMainGui.this.comisionProcent.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_TVA_COD.toString(), EcrMainGui.this.produsComisionTvaCod.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_TVA_COTA.toString(), EcrMainGui.this.produsComisionTvaCota.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PRODUS_NUME.toString(), EcrMainGui.this.produsComisionNume.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PRODUS_COD.toString(), EcrMainGui.this.produsComisionCod.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PRODUS_CODDEPARTAMENT.toString(), EcrMainGui.this.produsComisionCodDepartament.getText());
                    EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.PREVALIDARE_TYPE.toString(), ((EcrPrevalidareType)((Object)EcrMainGui.this.tipuriPrevalidare.getSelectedItem())).name());
                    try {
                        EcrMainGui.this.configs.store(new FileWriter(configFile), "");
                        DialogUtils.okDialog(EcrMainGui.this.panel, LangRoAll.operatieExecutata + ". Programul se va inchide. Trebuie repornit manual !", LangRoAll.succes);
                        Utils.systemExit();
                    }
                    catch (IOException e1) {
                        Logger.logException("EcrMainGui", (Exception)e1);
                    }
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Parola actuala gresita", LangRoAll.nuPotContinua);
                }
            }
        });
        panel2.add(salveaza);
        JButton schimbaParola = new JButton("Schimba parola si Restart");
        schimbaParola.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String[] passwords = DialogUtils.changePasswordDialog(EcrMainGui.this.panel, "Schimbare parola");
                    if (passwords != null) {
                        String currentPassword = passwords[0];
                        if (EcrMainGui.this.verifySettingsPassword(currentPassword)) {
                            String pass1 = passwords[1];
                            String pass2 = passwords[2];
                            if (pass1.equals(pass2)) {
                                EcrMainGui.this.configs.setProperty(EcrLogic.ECR_GUI_CONFIGS.hashedPassword.toString(), EcrMainGui.encodePassword(pass1));
                                EcrMainGui.this.configs.store(new FileWriter(configFile), "");
                                DialogUtils.okDialog(EcrMainGui.this.panel, LangRoAll.operatieExecutata + " " + "Programul se va inchide. Trebuie repornit manual !", LangRoAll.succes);
                                Utils.systemExit();
                            } else {
                                DialogUtils.errorDialog(EcrMainGui.this.panel, "Parolele noi nu coincid", LangRoAll.nuPotContinua);
                            }
                        } else {
                            DialogUtils.errorDialog(EcrMainGui.this.panel, "Parola actuala gresita", LangRoAll.nuPotContinua);
                        }
                    }
                }
                catch (IOException e1) {
                    Logger.logException("EcrMainGui", (Exception)e1);
                }
            }
        });
        panel2.add(schimbaParola);
        this.cereLicenta = new JButton("Cere licenta");
        this.cereLicenta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcrMainGui.this.requestNewLicense(EcrMainGui.this.getExistingLicenseBean());
            }
        });
        panel2.add(this.cereLicenta);
        JPanel panel1 = new JPanel((LayoutManager)new MigLayout("", "[grow][][]", "[][][][grow]"));
        panel1.add((Component)this.buildAboutPanel(), "grow, span 2");
        panel1.add((Component)this.buildActiuniPanel(), "grow, wrap");
        panel1.add((Component)this.buildCashBackPanel(), "growx");
        panel1.add((Component)this.buildDepuneScoatePanel(), "grow, span 2, wrap");
        panel1.add((Component)this.buildCodFiscalPanel(), "growx, span 3, wrap");
        panel1.add((Component)this.buildLogPanel(), "grow, span 3");
        panes.addTab("Operatiuni", panel1);
        panes.addTab("Setari", panel2);
        this.getContentPane().add(panes);
        this.pack();
        this.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
        GuiUtils.currentFrame = this;
    }

    private static String encodePassword(String password) {
        try {
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            password = password + "jkdf8hgj2dfhgjhg4asb5ndh";
            encryptor.update(password.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            return hex.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean verifySettingsPassword(String userPassword) {
        String userPasswordHashed = EcrMainGui.encodePassword(userPassword);
        String currentPassword = this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.hashedPassword.toString());
        return currentPassword.equals(userPasswordHashed);
    }

    public static final void main(String[] args) {
        FileUtils.buildTempDir();
        Logger.grabOutput = true;
        Logger.getInstance(6, "ecr_gui.log");
        PidFileUtil.checkForRunningInstances("fiscalwirepid", false, false);
        final Properties conf = new Properties();
        try {
            conf.load(new FileInputStream(configFile));
        }
        catch (IOException e) {
            // empty catch block
        }
        String ecrType = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString());
        if (ecrType == null) {
            EcrType[] val;
            Vector<EcrType> items = new Vector<EcrType>();
            for (EcrType type : val = EcrType.values()) {
                items.add(type);
            }
            EcrType chosen = (EcrType)((Object)DialogUtils.getItemChooserDialog(items, 5, false));
            if (chosen != null) {
                conf.setProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString(), chosen.toString());
                DialogUtils.okDialog(GuiUtils.currentFrame, "Programul se va inchide, trebuie repornit manual", LangRoAll.atentie);
                try {
                    conf.store(new FileWriter(configFile), "");
                }
                catch (IOException e1) {
                    Logger.logException("EcrMainGui", (Exception)e1);
                }
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "NU Ati ales modelul de casa de marcat. Programul se va inchide, trebuie repornit manual", LangRoAll.atentie);
            }
            Utils.systemExit();
        }
        EcrType ecrDef = EcrType.valueOf(ecrType);
        String ecrPort = null;
        String ecrSpeed = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.ecrSpeed.toString(), ecrDef.getPreferredSpeed() + "");
        String osname = System.getProperty("os.name");
        osname = osname.toLowerCase();
        System.out.println("osname : " + osname);
        String serialType = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.SERIAL_TYPE.toString());
        if (serialType == null) {
            if (osname.contains("windows")) {
                SerialLibraryType preferedSerialLibraryType = ecrDef.getPreferedSerialLibraryTypeWindows();
                serialType = preferedSerialLibraryType.toString();
            } else {
                serialType = SerialLibraryType.PureJava.toString();
            }
        }
        if (osname.contains("windows")) {
            ecrPort = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.ecrPort.toString(), "COM1");
        } else if (osname.contains("linux")) {
            ecrPort = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.ecrPort.toString(), "/dev/ttyS0");
        } else if (osname.contains("mac")) {
            ecrPort = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.ecrPort.toString(), "/dev/tt\u200c\u200by.usbserial-xxxx");
        }
        String nativeDir = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_DIR.toString(), FileUtils.getCurrentDirAsFile().getAbsolutePath() + File.separator + "bonuri");
        String nativeCharset = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_CHARSET.toString(), "");
        String extensions = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_EXTENSIONS.toString(), ".inp,.bon");
        String currentPasswordHashed = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.hashedPassword.toString());
        if (currentPasswordHashed == null) {
            currentPasswordHashed = EcrMainGui.encodePassword("deveruser");
            conf.put(EcrLogic.ECR_GUI_CONFIGS.hashedPassword.toString(), currentPasswordHashed);
        }
        conf.put(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString(), ecrType);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.ecrPort.toString(), ecrPort);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.ecrSpeed.toString(), ecrSpeed);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.SERIAL_TYPE.toString(), serialType);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.NATIVE_DIR.toString(), nativeDir);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.NATIVE_CHARSET.toString(), nativeCharset);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.NATIVE_EXTENSIONS.toString(), extensions);
        conf.put(EcrLogic.ECR_GUI_CONFIGS.ECR_MAX_DPT.toString(), ecrDef.getMaxDepartments() + "");
        String ecrClass = ecrDef.getDriverClass();
        EcrFactory.launcherProperties.put(ecrClass, conf);
        String[] args1 = new String[]{"-ecrType", ecrClass};
        EcrLogic reader = EcrLogic.getInstance(args1, true, null);
        final File errorDirFinal = new File(nativeDir);
        errorDirFinal.mkdirs();
        final EcrMainGui ecrMainGui = new EcrMainGui(conf);
        ecrMainGui.setTitle("FiscalWire - nici o licenta incarcata");
        reader.setEcrUserFeedbackInterface(new EcrUserFeedbackInterface(){

            @Override
            public void showTextToUser(String text) {
                ecrMainGui.appendLog(text, LOG_IMPORTANCE.INFO);
            }
        });
        reader.setEcrType(ecrDef);
        reader.setResponseInterface(new BonValidatorResponseInterface(){

            @Override
            public void processErrors(Map<Integer, Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>> errors, String initialText, String serieFiscala, String bonId, Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> generalErrors) {
                String out = BonValidator.createFprintLikeOutput(errors, initialText, serieFiscala, generalErrors);
                System.out.println(out);
                boolean bonAnulat = false;
                try {
                    String absDirPath = errorDirFinal.getAbsolutePath() + File.separator;
                    FileUtils.writeTextToFile(absDirPath + "answer.txt", out);
                    if (Validators.correctString(bonId)) {
                        String string = bonId.trim().replace(' ', '_');
                        FileUtils.writeTextToFile(absDirPath + string + ".ans", out);
                    }
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
                for (Integer n : errors.keySet()) {
                    Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> errForLine = errors.get(n);
                    if (errForLine.size() <= 0) continue;
                    for (Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE> map : errForLine) {
                        for (BonValidator.ERROR_FUNCTION function : map.keySet()) {
                            switch (function) {
                                case ERROR: {
                                    ecrMainGui.appendLog(n + ": " + map.get((Object)function).toString(), LOG_IMPORTANCE.ERROR);
                                    bonAnulat = true;
                                    break;
                                }
                                case WARNING: {
                                    ecrMainGui.appendLog(n + ": " + map.get((Object)function).toString(), LOG_IMPORTANCE.WARNING);
                                }
                            }
                        }
                    }
                }
                for (Map map : generalErrors) {
                    for (BonValidator.ERROR_FUNCTION function : map.keySet()) {
                        switch (function) {
                            case ERROR: {
                                ecrMainGui.appendLog(((BonValidator.ERROR_TYPE)((Object)map.get((Object)function))).toString(), LOG_IMPORTANCE.ERROR);
                                bonAnulat = true;
                                break;
                            }
                            case WARNING: {
                                ecrMainGui.appendLog(((BonValidator.ERROR_TYPE)((Object)map.get((Object)function))).toString(), LOG_IMPORTANCE.WARNING);
                            }
                        }
                    }
                }
                if (bonAnulat) {
                    ecrMainGui.appendLog("BON ANULAT: " + bonId + " (" + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()) + ")", LOG_IMPORTANCE.ERROR);
                    ecrMainGui.appendLog("------ Contactati suportul tehnic AL PROGRAMULUI DE GESTIUNE-VANZARE ------- ", LOG_IMPORTANCE.ERROR);
                    ecrMainGui.setVisible(true);
                    ecrMainGui.setExtendedState(0);
                    ecrMainGui.toFront();
                }
            }
        });
        AbstractCashRegister ecr = reader.getEcr();
        ecr.setEcrSerialNumberReadInterface(new EcrSerialNumberReadInterface(){

            @Override
            public void licenseBySerieFiscala(String serieFiscala) {
                EcrLicenseVerifier.APP_TYPE licensedApp;
                EcrLogic.getInstance().setSerieFiscala(serieFiscala);
                Vector<String> errors = EcrLicenseVerifier.getInstance().setSerieFiscalaCasaAndLicenseJson(serieFiscala);
                if (errors != null && errors.size() > 0) {
                    DialogUtils.bulletedErrorDialog(ecrMainGui, errors, "Erori de licentiere");
                }
                if ((licensedApp = EcrLicenseVerifier.getInstance().getLicensedApp()) == null || EcrLicenseVerifier.getInstance().isExpired()) {
                    ecrMainGui.cerereLicenta();
                } else {
                    ecrMainGui.setTitle("FiscalWire - Licenta " + licensedApp.toString() + " Expira la " + Formatters.DATE_FORMAT.format(EcrLicenseVerifier.getInstance().getExpireDate()));
                    boolean canCorrect = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.correctBonEnabled);
                    EcrPrevalidareType prevalidare_type = null;
                    String prevalidareS = conf.getProperty(EcrLogic.ECR_GUI_CONFIGS.PREVALIDARE_TYPE.toString());
                    if (Validators.correctString(prevalidareS)) {
                        prevalidare_type = EcrPrevalidareType.valueOf(prevalidareS);
                    }
                    if (prevalidare_type != null) {
                        ecrMainGui.tipuriPrevalidare.setSelectedItem((Object)prevalidare_type);
                    } else {
                        conf.setProperty(EcrLogic.ECR_GUI_CONFIGS.PREVALIDARE_TYPE.toString(), EcrPrevalidareType.REJECT_BONURI_ERONATE.name());
                        ecrMainGui.tipuriPrevalidare.setSelectedItem((Object)EcrPrevalidareType.REJECT_BONURI_ERONATE);
                    }
                }
            }
        });
        ecr.addListener(new EcrFeedbackInterface(){

            @Override
            public void bonFinished(int idOrder, int nrBon, int nrZ, int idCasa, MP55Impl.CASA_EXPLAIN_MESSAGES explain_messages, String orderIdentifier, boolean lastBon) {
                String nrBonS = "";
                nrBonS = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.raportareNrBonFiscalEnabled) ? nrBon + "" : "Nu aveti acces la aceasta functie. Achizitionati un pachet superior";
                String s = "OK;Z=" + nrZ + "|NR=" + nrBonS + "|UNIQUE_ID=" + orderIdentifier;
                EcrMainGui.writeErrorsToFile(errorDirFinal, s, orderIdentifier);
            }
        });
        reader.startDirDaemon(errorDirFinal, ecr, nativeCharset, extensions);
    }

    private static void writeErrorsToFile(File currentDir, String s, String originalFilename) {
        try {
            String originalFilename1 = originalFilename.trim().replace(' ', '_');
            String file = originalFilename1 + ".err";
            String absFile = currentDir.getAbsolutePath() + File.separator + file;
            s = s + "|" + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date());
            FileUtils.writeTextToFile(absFile, s);
        }
        catch (IOException e) {
            Logger.logException(EcrMain.class.getName(), (Exception)e);
        }
    }

    private JPanel buildCommSettingsPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.add(new JLabel("Model casa marcat"));
        result.add(this.tipuriEcr, "");
        result.add(new JLabel("Librarie seriala"));
        result.add(this.tipLibrarieSeriala, "wrap");
        result.add(new JLabel("Port"));
        result.add((Component)this.portField, "");
        result.add(new JLabel("Viteza"));
        result.add((Component)this.speedField, "wrap");
        this.portField.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ecrPort.toString()));
        this.speedField.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ecrSpeed.toString()));
        String ecrTypeS = this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ECR_TYPE.toString());
        EcrType ecrType = EcrType.valueOf(ecrTypeS);
        this.tipuriEcr.setSelectedItem((Object)ecrType);
        String serialTypeS = this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.SERIAL_TYPE.toString());
        SerialLibraryType serialType = SerialLibraryType.valueOf(serialTypeS);
        this.tipLibrarieSeriala.setSelectedItem((Object)serialType);
        result.setBorder(new TitledBorder("Comunicatie"));
        return result;
    }

    private JPanel buildDirectorySettingsPanel() {
        final JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.add(new JLabel("Citeste din directorul"));
        result.add((Component)this.nativeDir, "growx, span 3");
        this.nativeDir.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_DIR.toString()));
        JButton browse = new JButton("Alege");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String proposedDirectory = FileDialog.getLoadDialogFolder(result, "Alege directorul");
                if (Validators.correctString(proposedDirectory)) {
                    EcrMainGui.this.nativeDir.setText(proposedDirectory);
                }
            }
        });
        result.add((Component)browse, "wrap");
        result.add(new JLabel("Charset fisiere"));
        result.add((Component)this.nativeCharset, "");
        this.nativeCharset.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_CHARSET.toString()));
        result.add(new JLabel("Extensii fisiere"));
        result.add((Component)this.nativeExtension, "wrap");
        this.nativeExtension.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.NATIVE_EXTENSIONS.toString()));
        result.add(new JLabel("Prevalidare bonuri"));
        result.add(this.tipuriPrevalidare, "span 3");
        result.setBorder(new TitledBorder("Director si tratare erori"));
        return result;
    }

    private JPanel buildCashbackSettingsPanel(EcrType ecrTypeFromConfigs) {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        JPanel produsEliberarePanel = new JPanel((LayoutManager)new MigLayout());
        produsEliberarePanel.add(new JLabel("Nume produs eliberare numerar (*)"));
        produsEliberarePanel.add((Component)this.produsEliberareNume, "wrap");
        produsEliberarePanel.add(new JLabel("Cod produs eliberare numerar"));
        produsEliberarePanel.add((Component)this.produsEliberareCod, "wrap");
        produsEliberarePanel.add(new JLabel("Cod departament produs eliberare numerar"));
        produsEliberarePanel.add((Component)this.produsEliberareCodDepartament, "wrap");
        produsEliberarePanel.add(new JLabel("Cod TVA produs eliberare numerar"));
        produsEliberarePanel.add((Component)this.produsEliberareTvaCod, "wrap");
        produsEliberarePanel.add(new JLabel("Cota TVA produs eliberare numerar"));
        produsEliberarePanel.add((Component)this.produsEliberareTvaCota, "wrap");
        produsEliberarePanel.setBorder(new TitledBorder("Definire produs eliberare numerar"));
        this.produsEliberareNume.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_PRODUS_NUME.toString(), "Eliberare numerar"));
        this.produsEliberareCod.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_PRODUS_COD.toString(), "-1"));
        this.produsEliberareCodDepartament.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_PRODUS_CODDEPARTAMENT.toString(), "1"));
        this.produsEliberareTvaCod.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_TVA_COD.toString(), "A"));
        this.produsEliberareTvaCota.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.ELIBERARE_TVA_COTA.toString(), "0.00"));
        JPanel produsComisionPanel = new JPanel((LayoutManager)new MigLayout());
        produsComisionPanel.add(new JLabel("Nume produs comision (*)"));
        produsComisionPanel.add((Component)this.produsComisionNume, "wrap");
        produsComisionPanel.add(new JLabel("Cod produs comision"));
        produsComisionPanel.add((Component)this.produsComisionCod, "wrap");
        produsComisionPanel.add(new JLabel("Cod departament produs comision"));
        produsComisionPanel.add((Component)this.produsComisionCodDepartament, "wrap");
        produsComisionPanel.add(new JLabel("Cod TVA produs comision"));
        produsComisionPanel.add((Component)this.produsComisionTvaCod, "wrap");
        produsComisionPanel.add(new JLabel("Cota TVA produs comision"));
        produsComisionPanel.add((Component)this.produsComisionTvaCota, "wrap");
        produsComisionPanel.setBorder(new TitledBorder("Definire produs comision"));
        this.produsComisionNume.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PRODUS_NUME.toString(), "Comision"));
        this.produsComisionCod.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PRODUS_COD.toString(), "-1"));
        this.produsComisionCodDepartament.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PRODUS_CODDEPARTAMENT.toString(), "1"));
        this.produsComisionTvaCod.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_TVA_COD.toString(), "A"));
        this.produsComisionTvaCota.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_TVA_COTA.toString(), "0.00"));
        JPanel altelePanel = new JPanel((LayoutManager)new MigLayout());
        altelePanel.add(new JLabel("Tip Plata Card COD casa"));
        altelePanel.add((Component)this.tipPlataCardCodCasa, "wrap");
        this.tipPlataCardCodCasa.setEditable(false);
        altelePanel.add(new JLabel("Tip Plata Card NUME"));
        altelePanel.add((Component)this.tipPlataCardNume, "wrap");
        altelePanel.add(new JLabel("Procent comision"));
        altelePanel.add((Component)this.comisionProcent, "wrap");
        altelePanel.setBorder(new TitledBorder("General"));
        String property = this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.CARD_CODCASA.toString(), ecrTypeFromConfigs.getTipPlataCardEnum().getCode() + "");
        this.tipPlataCardCodCasa.setText(property);
        this.tipPlataCardNume.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.CARD_NUME.toString(), "Card"));
        this.comisionProcent.setText(this.configs.getProperty(EcrLogic.ECR_GUI_CONFIGS.COMISION_PROCENT.toString(), "0"));
        result.add(altelePanel);
        result.add((Component)produsComisionPanel, "wrap");
        result.add((Component)produsEliberarePanel, "span, wrap");
        result.setBorder(new TitledBorder("Cash-back"));
        return result;
    }

    private JPanel buildAboutPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.setBorder(new TitledBorder("Despre"));
        JLabel title = new JLabel("FiscalWire - driver case de marcat");
        title.setForeground(Color.RED);
        result.add((Component)title, "wrap");
        JLabel distribuitor = new JLabel("Distribuit de " + this.resellerKey.getNumePartener());
        result.add((Component)distribuitor, "wrap");
        JLabel web = new JLabel("Website: " + this.resellerKey.getWww());
        result.add((Component)web, "wrap");
        JLabel telefon = new JLabel("Tel: " + this.resellerKey.getTel());
        result.add((Component)telefon, "wrap");
        JLabel email = new JLabel("Email: " + this.resellerKey.getEmail());
        result.add((Component)email, "wrap");
        JTextArea area = new JTextArea();
        area.setText(this.resellerKey.getAltele());
        result.add((Component)area, "wrap");
        return result;
    }

    private JPanel buildCodFiscalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        result.add(new JLabel("Cod Fiscal - cu RO pt platitor TVA"));
        final JTextField nextBonCuiField = new JTextField(15);
        result.add((Component)nextBonCuiField, "wrap");
        JButton confirma = new JButton("Confirma");
        confirma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.printCodFiscalEnabled)) {
                    String text = nextBonCuiField.getText();
                    if (Validators.correctString(text)) {
                        EcrLogic.getInstance().setNextBonCUI("CUI " + text);
                        nextBonCuiField.setText("");
                        DialogUtils.okDialog(EcrMainGui.this.panel, "CUI-ul va fi folosit la urmatorul bon fiscal trimis catre driver", LangRoAll.succes);
                    }
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Nu aveti acces la aceasta functie. Achizitionati un pachet superior", LangRoAll.nuPotContinua);
                    nextBonCuiField.setText("");
                }
            }
        });
        result.add(confirma);
        result.add(new JButton("Anuleaza"));
        result.setBorder(new TitledBorder("Cod fiscal"));
        return result;
    }

    private JPanel buildLogPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "grow", "grow"));
        this.area.setEditable(false);
        this.area.setContentType("text/html");
        Dimension preferredSize = new Dimension(200, 250);
        this.area.setMinimumSize(preferredSize);
        this.area.setPreferredSize(preferredSize);
        this.logScrollPane = new JScrollPane(this.area);
        result.add((Component)this.logScrollPane, "grow, wrap");
        return result;
    }

    public void appendLog(String message, LOG_IMPORTANCE importance) {
        String newLine = "";
        switch (importance) {
            case ERROR: {
                newLine = "<font color=\"red\">" + message + "</font><br>";
                break;
            }
            case WARNING: {
                newLine = "<font color=\"orange\">" + message + "</font><br>";
                break;
            }
            case OK: {
                newLine = "<font color=\"blue\">" + message + "</font><br>";
                break;
            }
            case INFO: {
                newLine = message + "<br>";
            }
        }
        this.areaText = this.areaText + newLine;
        this.area.setText("<html>" + this.areaText + "</html>");
        this.area.selectAll();
        int selectionEnd = this.area.getSelectionEnd();
        this.area.select(selectionEnd, selectionEnd);
    }

    private void resetLog() {
        this.areaText = "";
        this.area.setText("<html>" + this.areaText + "</html>");
    }

    private JPanel buildDepuneScoatePanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        final JTextField depundeBaniField = new JTextField(10);
        final JTextField scoateBaniField = new JTextField(10);
        result.add(new JLabel("Depune bani in casa"));
        result.add((Component)depundeBaniField, "wrap");
        result.add(new JLabel("Scoate bani din casa"));
        result.add((Component)scoateBaniField, "wrap");
        final Callable clear = new Callable(){

            public Object call() throws Exception {
                scoateBaniField.setText("");
                depundeBaniField.setText("");
                return null;
            }
        };
        JButton confirma = new JButton("Confirma");
        confirma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.incarcaCasaEnabled)) {
                    double val;
                    if (Validators.correctDouble(depundeBaniField.getText())) {
                        val = Double.parseDouble(depundeBaniField.getText());
                        val = FloatUtils.roundDoubleUp(val, 2);
                        if (DialogUtils.confirmDialog(EcrMainGui.this.panel, "Introducem " + val + " RON in casa", LangRoAll.confirmare)) {
                            EcrLogic.getInstance().getEcr().introduNumerar(val);
                        }
                    }
                    if (Validators.correctDouble(scoateBaniField.getText())) {
                        val = Double.parseDouble(scoateBaniField.getText());
                        val = FloatUtils.roundDoubleUp(val, 2);
                        if (DialogUtils.confirmDialog(EcrMainGui.this.panel, "Scoatem " + val + " RON din casa", LangRoAll.confirmare)) {
                            EcrLogic.getInstance().getEcr().introduNumerar(-val);
                        }
                    }
                    try {
                        clear.call();
                    }
                    catch (Exception exception) {}
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Nu aveti acces la aceasta functie. Achizitionati un pachet superior", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add(confirma);
        JButton anuleaza = new JButton("Anuleaza");
        anuleaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    clear.call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        result.add(anuleaza);
        result.setBorder(new TitledBorder("Operatiuni numerar casa"));
        return result;
    }

    private JPanel buildActiuniPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow][]"));
        JButton raportX = new JButton("Raport X");
        raportX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcrType ecrType = EcrLogic.getInstance().getEcrType();
                if (ecrType.isSupportsX()) {
                    if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.xzReportsEnabled)) {
                        EcrLogic.getInstance().getEcr().printX();
                    } else {
                        DialogUtils.errorDialog(EcrMainGui.this.panel, "Nu aveti acces la aceasta functie. Achizitionati un pachet superior", LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Functie nesuportata de acest model de casa de marcat", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)raportX, "grow");
        JButton raportZ = new JButton("Raport Z");
        raportZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcrType ecrType = EcrLogic.getInstance().getEcrType();
                if (ecrType.isSupportsZ()) {
                    if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.xzReportsEnabled)) {
                        EcrLogic.getInstance().getEcr().printZ();
                        EcrMainGui.this.resetLog();
                    } else {
                        DialogUtils.errorDialog(EcrMainGui.this.panel, "Nu aveti acces la aceasta functie. Achizitionati un pachet superior", LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Functie nesuportata de acest model de casa de marcat", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)raportZ, "grow, wrap");
        JButton copieBon = new JButton("Copie bon");
        copieBon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcrLogic.getInstance().getEcr().copieBon();
            }
        });
        result.add(copieBon);
        JButton inchide = new JButton("Inchide aplicatie");
        inchide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcrMainGui.this.inchideApp();
            }
        });
        result.add((Component)inchide, "wrap, growx");
        result.setBorder(new TitledBorder("Actiuni"));
        return result;
    }

    private void inchideApp() {
        if (DialogUtils.confirmDialog(this.panel, "ATENTIE ! Driverul se va inchide . Nu va mai putea tipari bonuri la casa de marcat ! Sunteti sigur ", LangRoAll.confirmare)) {
            Utils.systemExit();
        }
    }

    private JPanel buildCashBackPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout());
        final JLabel comisionProcentLabel = new JLabel("");
        final JTextField sumaCatreClientField = new JTextField(10);
        final JLabel valoareComisionLabel = new JLabel("");
        final JLabel totalPlataClient = new JLabel("");
        JCheckBox wantCopy = new JCheckBox();
        final Callable clear = new Callable(){

            public Object call() throws Exception {
                sumaCatreClientField.setText("");
                comisionProcentLabel.setText("");
                valoareComisionLabel.setText("");
                totalPlataClient.setText("");
                return null;
            }
        };
        result.add(new JLabel("SUMA"));
        result.add((Component)sumaCatreClientField, "wrap");
        sumaCatreClientField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String sumaText = sumaCatreClientField.getText();
                if (Validators.correctDouble(sumaText)) {
                    double sumaCatreClient = Double.parseDouble(sumaText);
                    double[] values = EcrLogic.getInstance().cashbackCompute(sumaCatreClient, EcrMainGui.this.configs);
                    comisionProcentLabel.setText(values[3] + "");
                    valoareComisionLabel.setText(values[1] + "");
                    totalPlataClient.setText(values[2] + "");
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Introduceti un numar", LangRoAll.nuPotContinua);
                    try {
                        clear.call();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sumaCatreClientField.requestFocus();
                }
            }
        });
        result.add(new JLabel("Comision %"));
        result.add((Component)comisionProcentLabel, "wrap");
        result.add(new JLabel("Comision calculat"));
        result.add((Component)valoareComisionLabel, "wrap");
        result.add(new JLabel("Total de plata client"));
        result.add((Component)totalPlataClient, "wrap");
        JButton confirma = new JButton("Confirma");
        confirma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.cashbackEnabled)) {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Nu aveti acces la aceasta functie. Achizitionati un pachet superior", LangRoAll.nuPotContinua);
                    return;
                }
                String sumaText = sumaCatreClientField.getText();
                if (Validators.correctDouble(sumaText)) {
                    double sumaCatreClient = Double.parseDouble(sumaText);
                    if (Utils.isValueGreaterThanZero(sumaCatreClient) && sumaCatreClient <= 200.0) {
                        boolean copie = DialogUtils.confirmDialog(EcrMainGui.this.panel, "Doriti copie bon", LangRoAll.confirmare);
                        EcrLogic.getInstance().cashback(sumaCatreClient, copie, EcrMainGui.this.configs);
                        try {
                            clear.call();
                        }
                        catch (Exception e1) {}
                    } else {
                        DialogUtils.errorDialog(EcrMainGui.this.panel, "Suma eronata ( 1-200 )", LangRoAll.nuPotContinua);
                        try {
                            clear.call();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        sumaCatreClientField.requestFocus();
                    }
                } else {
                    DialogUtils.errorDialog(EcrMainGui.this.panel, "Introduceti un numar", LangRoAll.nuPotContinua);
                    try {
                        clear.call();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sumaCatreClientField.requestFocus();
                }
            }
        });
        result.add(confirma);
        JButton anuleaza = new JButton("Anuleaza");
        anuleaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    clear.call();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        result.add(anuleaza);
        result.setBorder(new TitledBorder("Cash-Back"));
        return result;
    }

    private LicenseBean getExistingLicenseBean() {
        LicenseBean bean = null;
        String fileContent = ExportUtils.readFile(new File("license.json"));
        if (Validators.correctString(fileContent)) {
            bean = ExportUtils.getLicenseBeanFromJson(fileContent);
        }
        if (bean == null) {
            LicenseBeanInterface beanInterface = new LicenseBeanInterface(){

                @Override
                public String getBrand() {
                    return "";
                }

                @Override
                public String getSocietate() {
                    return "";
                }

                @Override
                public String getCui() {
                    return "";
                }

                @Override
                public String getPCName() {
                    return "ecr_" + this.getHDDId();
                }

                @Override
                public String getDBId() {
                    return "";
                }

                @Override
                public String getClientName() {
                    return "";
                }

                @Override
                public String getHDDId() {
                    String hddID = EcrLicenseVerifier.getInstance().getSerieFiscalaCasa();
                    return hddID;
                }

                @Override
                public int getCurrentSequence() {
                    return 1;
                }

                @Override
                public String getMajorVersion() {
                    return "2016";
                }

                @Override
                public String getEmailAddress() {
                    return "";
                }

                @Override
                public String getMobileNumber() {
                    return "";
                }

                @Override
                public String getChosenApp() {
                    return "";
                }

                @Override
                public Vector<String> getChosenModules() {
                    return new Vector<String>();
                }

                @Override
                public Date getExpireDate() {
                    return DateUtils.addDaysToDate(new Date(), 31);
                }
            };
            bean = ExportLicense.composeNewLicenseBean(beanInterface);
        }
        return bean;
    }

    public void requestNewLicense(LicenseBean existingData) {
        String APPS_URL = "http://arhiva.deversoft.ro/fiscalwireapps.txt";
        String MODULES_URL = "http://arhiva.deversoft.ro/fiscalwiremodules.txt";
        final EcrLicensePanel panel = new EcrLicensePanel(existingData, "http://arhiva.deversoft.ro/fiscalwireapps.txt", "http://arhiva.deversoft.ro/fiscalwiremodules.txt");
        JDialog dialog = DialogUtils.getJDialog(panel, GuiUtils.currentFrame, "Cerere licenta", 1.2);
        panel.setDialog(dialog);
        dialog.setVisible(true);
        ExportLicenseInterface licenseInterface = new ExportLicenseInterface(){

            @Override
            public void showErrorDialog(String message, String title) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, message, title);
            }

            @Override
            public void showOkDialog(String message, String title) {
                DialogUtils.okDialog(GuiUtils.currentFrame, message, title);
            }

            @Override
            public boolean canAddLicenseRequest() {
                return true;
            }

            @Override
            public void checkGlobalConfigs() {
            }

            @Override
            public void registerLicenseRequest(ExportLicense.RequestType rType, long licenseRequestId) {
                if (licenseRequestId > 0L) {
                    Logger.logDebug("EcrMainGui", "LicenseRequest node id : " + licenseRequestId);
                    Vector<String> instructiuni = new Vector<String>();
                    instructiuni.add("Notati numarul cererii de licenta : \"" + licenseRequestId + "\"");
                    instructiuni.add("Daca ati cerut o licenta gratuita, veti primi fisierul pe mail in aproximativ 30 min, in timpul programului de lucru.");
                    instructiuni.add("Daca ati cerut o licenta platita, veti fi contactat in aproximativ 30 min, in timpul programului de lucru.");
                    instructiuni.add("Descarcati licenta primita pe email. Daca nu ati primit mail, verificati Spam");
                    instructiuni.add("Daca nu gasiti mailul nici in Spam, sunati la " + EcrMainGui.this.resellerKey.getTel() + " cu numarul cererii de licenta");
                    instructiuni.add("Salvati fisierul de licenta cu numele \"license.json\" in directorul \"" + FileUtils.getCurrentDir() + "\"");
                    instructiuni.add("Reporniti programul");
                    DialogUtils.bulletedErrorDialog(panel, instructiuni, LangRoAll.instructiuni);
                } else {
                    DialogUtils.errorDialog(panel, LangRoAll.operatieEsuata, LangRoAll.nuPotContinua);
                }
            }

            @Override
            public void openOnlineShopUrl(String url) {
                boolean openOk = GuiUtils.openLinkInBrowser(url);
                if (!openOk) {
                    DialogUtils.errorDialog(panel, "Deschideti MANUAL linkul " + url + " !!! ", LangRoAll.atentie);
                }
            }
        };
        LicenseBean resultLicense = panel.getResultLicense();
        if (resultLicense != null) {
            ExportLicense.getInstance().requestNewLicense(resultLicense, licenseInterface, this.resellerKey);
            Utils.systemExit();
        }
    }

    public void cerereLicenta() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EcrMainGui.this.cereLicenta.doClick();
            }
        });
    }

    public static enum LOG_IMPORTANCE {
        ERROR,
        WARNING,
        OK,
        INFO;

    }
}

