/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.util.List;
import java.util.Vector;
import ro.atreides.ecr.ConfigUtils;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.utils.tricky.NonPrintedBonInterface;

public class EcrPersistentList {
    protected String persistentFile;
    private List<EcrReceipt> products;

    public EcrPersistentList(String file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.persistentFile = file;
        this.products = ConfigUtils.getDataFor(this.persistentFile);
    }

    public final EcrReceipt next() {
        EcrReceipt next;
        while ((next = this.nextInternal()) == null) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {
            }
        }
        return next;
    }

    private EcrReceipt nextInternal() {
        return this.products.size() > 0 ? this.products.get(0) : null;
    }

    public final synchronized void addReceipt(EcrReceipt bon) {
        if (bon != null) {
            this.products.add(bon);
            this.update();
        }
    }

    public final synchronized void selled(EcrReceipt bon) {
        this.products.remove(bon);
        this.update();
    }

    public final synchronized void update() {
        ConfigUtils.setDataFor(this.products, this.persistentFile);
    }

    public final int size() {
        return this.products.size();
    }

    public String toStringOld() {
        return super.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (EcrReceipt o : this.products) {
            buffer.append(o);
        }
        return buffer.toString();
    }

    public synchronized void deleteNonPrintedBons(NonPrintedBonInterface inter) {
        EcrReceipt bon1;
        int i;
        Vector<EcrReceipt> toRemove = new Vector<EcrReceipt>();
        for (i = 0; i < this.products.size(); ++i) {
            bon1 = this.products.get(i);
            if (bon1.getIdOrder() <= 0 || !inter.processNonPrintedBon(bon1.getIdOrder())) continue;
            toRemove.add(bon1);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            bon1 = (EcrReceipt)toRemove.elementAt(i);
            this.products.remove(bon1);
        }
        ConfigUtils.setDataFor(this.products, this.persistentFile);
    }
}

