/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.security.MessageDigest;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import ro.atreides.ecr.CashRegisterInterface;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;

public class EcrUtils {
    public static String getPrice(int totalDigits, int decimalPlaces, double toConvert) {
        String result = "";
        double correctForm = FloatUtils.roundDoubleUp(toConvert, decimalPlaces);
        long printPrice = 1L;
        for (int i = 0; i < decimalPlaces; ++i) {
            printPrice *= 10L;
        }
        printPrice = (long)((double)printPrice * correctForm);
        String part = "" + printPrice;
        int size = part.length();
        for (int i = totalDigits; i > size; --i) {
            result = result + "0";
        }
        result = result + part;
        return result;
    }

    public static boolean isLicensed(String seria, String license) {
        try {
            if (seria == null) {
                return false;
            }
            if (seria.equals("000000")) {
                return true;
            }
            String hddID = seria + 87;
            if (hddID == null || hddID.length() < 1) {
                return false;
            }
            System.out.println(">>>>>>>>>>>>>>>>>> CALCULATING LICENSE <<<<<<<<<<<<<<<<<<<");
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            hddID = hddID + "d1hfu53j4h5jhg4asb5ndhjkdf8hgj2dfhg7k345";
            encryptor.update(hddID.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            if (hex.toString().equalsIgnoreCase(license)) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.logException("EcrUtils", e);
        }
        return false;
    }

    public static EcrPlata getEcrPlata(Plata p, CashRegisterInterface cashRegister, TipPlata defaultTipPlata) {
        EcrPlata plata = new EcrPlata();
        String forcedEcrMapping = cashRegister.getForcedEcrMapping(p.getTipPlata());
        if (forcedEcrMapping == null) {
            forcedEcrMapping = p.getEcrMapping();
        }
        plata.setDefault(p.getIdTipPlata() == defaultTipPlata.getId());
        plata.setEcrMapping(forcedEcrMapping);
        plata.setSuma(FloatUtils.roundDoubleUp(p.getSuma(), 2));
        plata.setTipPlata(p.getTipPlata());
        return plata;
    }

    public static Vector<EcrPlata> getEcrPlati(Vector<Plata> plati, CashRegisterInterface cashRegister, TipPlata defaultTipPlata) {
        Vector<EcrPlata> result = new Vector<EcrPlata>();
        for (Plata p : plati) {
            EcrPlata plata = EcrUtils.getEcrPlata(p, cashRegister, defaultTipPlata);
            result.add(plata);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                EcrPlata p1 = (EcrPlata)o1;
                EcrPlata p2 = (EcrPlata)o2;
                if (p1.isDefault()) {
                    return 1;
                }
                if (p2.isDefault()) {
                    return -1;
                }
                return p1.getTipPlata().compareToIgnoreCase(p2.getTipPlata());
            }
        });
        return result;
    }
}

