/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.ExtraCommandsBean;
import ro.atreides.ecr.GenericXmlHandlerInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class GenericXmlHandler
extends DefaultHandler {
    private Vector<EcrSale> sales = new Vector();
    private Vector<EcrPlata> plati = new Vector();
    private Vector<String> comments = new Vector();
    private Vector<ExtraCommandsBean> extraCommands = new Vector();
    private String idBon = "";
    private int idOrder = -1;
    private double totalSales = 0.0;
    private double totalPlati = 0.0;
    private GenericXmlHandlerInterface inter;

    public GenericXmlHandler(GenericXmlHandlerInterface inter) {
        this.inter = inter;
    }

    @Override
    public void startElement(String uri, String qName, String localName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            String product = attributes.getValue("label");
            String priceS = attributes.getValue("price");
            String priceOriginalS = attributes.getValue("priceOriginal");
            String qS = attributes.getValue("quantity");
            String vatCode = attributes.getValue("vat");
            String vatRateS = attributes.getValue("vatRate");
            int cod = Integer.parseInt(attributes.getValue("productCode"));
            String dept = attributes.getValue("department");
            int grupa = Integer.parseInt(attributes.getValue("group"));
            double q = Utils.parseDouble(qS);
            double vatRate = Utils.parseDouble(vatRateS);
            double ppuDupaDiscount = Utils.parseDouble(priceS);
            double ppuOriginal = Utils.parseDouble(priceOriginalS);
            double discount = ppuOriginal - ppuDupaDiscount;
            EcrSale sale = new EcrSale(product, q, ppuDupaDiscount, ppuOriginal, discount, cod, dept, grupa, vatCode, vatRate);
            this.sales.add(sale);
        } else if (qName.equalsIgnoreCase("ad")) {
            String text = attributes.getValue("text");
            if (text == null || text.length() == 0) {
                text = " ";
            }
            this.comments.add(text);
        } else if (qName.equalsIgnoreCase("discount")) {
            attributes.getValue("percent");
        } else if (qName.equalsIgnoreCase("adaos")) {
            attributes.getValue("percent");
        } else if (qName.equalsIgnoreCase("payment")) {
            String type = attributes.getValue("type");
            type = type.toUpperCase();
            String codCasa = this.inter.getEcrPaymentCode(type);
            String valueS = attributes.getValue("amount");
            EcrPlata plata = new EcrPlata();
            plata.setEcrMapping(codCasa);
            if (Validators.correctDouble(valueS)) {
                double value = Utils.parseDouble(valueS);
                plata.setSuma(value);
            } else {
                plata.setDefault(true);
            }
            plata.setTipPlata(type);
            this.plati.add(plata);
        } else if (qName.equalsIgnoreCase("receipt")) {
            this.idBon = attributes.getValue("bonId");
            this.idOrder = Integer.parseInt(attributes.getValue("idOrder"));
            this.totalSales = 0.0;
            this.totalPlati = 0.0;
            this.sales.clear();
            this.plati.clear();
            this.comments.clear();
        } else if (qName.equalsIgnoreCase("extraCommand")) {
            String operationS = attributes.getValue("operation");
            ExtraCommandsBean.ExtraCommandOperation operation = ExtraCommandsBean.ExtraCommandOperation.valueOf(operationS);
            ExtraCommandsBean bean = new ExtraCommandsBean();
            bean.setOperation(operation);
            switch (operation) {
                case addCash: 
                case removeCash: {
                    String paramS = attributes.getValue("params");
                    Double val = Double.parseDouble(paramS);
                    bean.setValue(val);
                    break;
                }
            }
            this.extraCommands.add(bean);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("receipt")) {
            if (this.totalPlati < this.totalSales) {
                // empty if block
            }
            this.idBon = "";
            this.idOrder = -1;
        }
    }

    public int getIdOrder() {
        return this.idOrder;
    }

    public Vector<String> getComments() {
        return this.comments;
    }

    public String getIdBon() {
        return this.idBon;
    }

    public Vector<EcrPlata> getPlati() {
        return this.plati;
    }

    public double getTotalPlati() {
        return this.totalPlati;
    }

    public Vector<EcrSale> getSales() {
        return this.sales;
    }

    public double getTotalSales() {
        return this.totalSales;
    }

    public Vector<ExtraCommandsBean> getExtraCommands() {
        return this.extraCommands;
    }
}

