/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import ro.atreides.ecr.EcrClosedException;
import ro.atreides.ecr.EcrLogger;
import ro.atreides.ecr.EcrPersistentList;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.SerialDriver;
import ro.atreides.utils.Logger;
import ro.atreides.utils.tricky.NonPrintedBonInterface;

public abstract class SerialEcr
extends SerialDriver {
    protected EcrPersistentList productsList;
    protected EcrLogger logger = new EcrLogger();

    public SerialEcr(String id) {
        super(id + "_last_detected_");
        this.productsList = new EcrPersistentList(id + "_persistent_list_");
    }

    @Override
    protected final void startDriver() {
        Logger.logVerbose(this, "ECR: STARTING TO SELL");
        while (this.isRunning()) {
            EcrReceipt receipt = null;
            try {
                receipt = this.productsList.next();
                if (!this.isRunning()) break;
                this.newReceipt(receipt);
                this.productsList.selled(receipt);
            }
            catch (EcrClosedException e) {
                Logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>> ECR CLOSED <<<<<<<<<<<<<<<<<<<<<<<<<");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.productsList.selled(receipt);
            }
        }
        this.stop();
    }

    protected final void updatePersistentList() {
        this.productsList.update();
    }

    public final int getNoOfBonsToPrint() {
        return this.productsList.size();
    }

    public final void addEcrReceipt(EcrReceipt bon) {
        this.productsList.addReceipt(bon);
    }

    @Override
    public String getDriverName() {
        return "Ecr Printing Thread";
    }

    public void log(String s) {
        if (this.logger != null) {
            this.logger.log((Object)this, s);
        }
    }

    public void log(Exception e) {
        if (this.logger != null) {
            this.logger.log((Object)this, e);
        }
    }

    protected final void removeReceipt(EcrReceipt receipt) {
        this.productsList.selled(receipt);
    }

    protected abstract void newReceipt(EcrReceipt var1) throws EcrClosedException;

    public void deleteNonPrintedBons(NonPrintedBonInterface inter) {
        this.productsList.deleteNonPrintedBons(inter);
    }
}

