/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import purejavacomm.SerialPort;
import ro.atreides.ecr.EcrLogger;
import ro.atreides.utils.Logger;

public abstract class SerialReader {
    protected InputStream in;
    protected SerialPort serial;
    private boolean closed = false;
    private EcrLogger logger;
    protected final ReentrantLock ECR_CLOSED_LOCK = new ReentrantLock(true);

    public SerialReader(InputStream in, SerialPort serial) {
        if (in == null || serial == null) {
            throw new NullPointerException();
        }
        this.in = in;
        this.serial = serial;
    }

    public final boolean isReaderClosed() {
        return this.closed;
    }

    public final void close() {
        this.closed = true;
    }

    public void log(String s) {
        if (this.logger == null) {
            Logger.logVerbose(this, s);
        } else {
            this.logger.log(s);
        }
    }

    public void log(Exception e) {
        if (this.logger == null) {
            Logger.logVerbose(this, "Exception: " + e.getMessage());
        } else {
            this.logger.log((Object)this, e);
        }
    }

    public void setLogger(EcrLogger logger) {
        this.logger = logger;
    }

    public final ReentrantLock getLock() {
        return this.ECR_CLOSED_LOCK;
    }

    public abstract Object read(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReader() {
        this.ECR_CLOSED_LOCK.lock();
        try {
            int available;
            if (!this.isReaderClosed() && (available = this.in.available()) > 0) {
                this.in.skip(available);
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        finally {
            this.ECR_CLOSED_LOCK.unlock();
        }
    }
}

