/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import purejavacomm.SerialPort;
import ro.atreides.ecr.SerialReader;

public abstract class SerialReaderImpl
extends SerialReader {
    private byte[] buffer = new byte[10240];
    private Vector messages = new Vector();
    private final Object WAIT_LOCK = new Object();

    public SerialReaderImpl(final InputStream input, SerialPort serial) {
        super(input, serial);
        try {
            serial.enableReceiveTimeout(10);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n = 0;
                    while (!SerialReaderImpl.this.isReaderClosed()) {
                        SerialReaderImpl.this.ECR_CLOSED_LOCK.lock();
                        try {
                            if (SerialReaderImpl.this.isReaderClosed()) {
                                return;
                            }
                            n = input.read(SerialReaderImpl.this.buffer);
                        }
                        finally {
                            SerialReaderImpl.this.ECR_CLOSED_LOCK.unlock();
                        }
                        if (n > 0) {
                            SerialReaderImpl.this.dataArrived(SerialReaderImpl.this.buffer, 0, n);
                            continue;
                        }
                        if (n != -1) continue;
                        return;
                    }
                }
                catch (Exception e) {
                    SerialReaderImpl.this.log(e);
                }
                finally {
                    SerialReaderImpl.this.close();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object nextMessage(long timeout) throws IOException {
        long stop = System.currentTimeMillis() + timeout;
        Object next = null;
        Object object = this.WAIT_LOCK;
        synchronized (object) {
            while ((next = this.nextMessage()) == null) {
                long delay = stop - System.currentTimeMillis();
                if (delay <= 0L) {
                    return next;
                }
                try {
                    this.WAIT_LOCK.wait(delay);
                }
                catch (InterruptedException e) {
                    this.log(e);
                }
            }
            return next;
        }
    }

    private Object nextMessage() throws IOException {
        if (this.isReaderClosed()) {
            throw new IOException();
        }
        return this.messages.size() > 0 ? this.messages.remove(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMessage(Object message) {
        if (message != null) {
            this.messages.add(message);
            Object object = this.WAIT_LOCK;
            synchronized (object) {
                this.WAIT_LOCK.notifyAll();
            }
        }
    }

    @Override
    public Object read(int timeout) throws IOException {
        return this.nextMessage(timeout);
    }

    @Override
    public void clearReader() {
        super.clearReader();
        this.messages.clear();
    }

    protected abstract void dataArrived(byte[] var1, int var2, int var3);
}

