/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr;

import java.io.IOException;
import java.io.OutputStream;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.EcrLogger;
import ro.atreides.utils.Logger;

public class SerialWriter {
    private OutputStream out;
    private boolean closed = false;
    private EcrLogger logger;

    public SerialWriter(OutputStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        this.out = out;
    }

    public final synchronized boolean writetoport(byte[] array) {
        try {
            this.writetoport_NOFLUSH_Internal(array);
            this.flushInternal();
            return true;
        }
        catch (IOException e) {
            this.log(e);
            return false;
        }
    }

    public final synchronized boolean writetoport_NOFLUSH(byte[] array) {
        try {
            this.writetoport_NOFLUSH_Internal(array);
            return true;
        }
        catch (IOException e) {
            this.log(e);
            return false;
        }
    }

    public final synchronized boolean flush() {
        try {
            this.flushInternal();
            return true;
        }
        catch (IOException e) {
            this.log(e);
            return false;
        }
    }

    private void writetoport_NOFLUSH_Internal(byte[] array) throws IOException {
        if (array != null) {
            this.out.write(array);
            this.log("writing: " + BinaryUtils.toHexString(array) + ", string = " + new String(array));
        }
    }

    private void flushInternal() throws IOException {
        this.out.flush();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void close() {
        this.closed = true;
    }

    public void log(String s) {
        if (this.logger == null) {
            Logger.logVerbose(this, s);
        } else {
            this.logger.log(s);
        }
    }

    public void log(Exception e) {
        if (this.logger == null) {
            Logger.logVerbose(this, "Exception: " + e.getMessage());
        } else {
            this.logger.log((Object)this, e);
        }
    }

    public void setLogger(EcrLogger logger) {
        this.logger = logger;
    }
}

