/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.aclas;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.aclas.AclasPersistentListDefaultImpl;
import ro.atreides.ecr.aclas.noarch.AclasImpl;
import ro.atreides.ecr.aclas.noarch.AclasPersistentList;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tricky.NonPrintedBonInterface;

public class AclasDefaultImpl
extends AclasImpl {
    private Socket socket;
    private SerialPort serialPort;

    public AclasDefaultImpl(String port) {
        super(port);
    }

    @Override
    protected void logException(Exception e) {
        Logger.logException(this, e);
    }

    @Override
    protected void logError(AclasImpl thiis, Object th) {
        Logger.logError((Object)this, th.toString());
    }

    @Override
    protected AclasPersistentList getPersistentList() {
        return new AclasPersistentListDefaultImpl(0);
    }

    @Override
    protected void ecrConnected(boolean status) {
        EcrLogic.getInstance().ecrConnected(status);
    }

    @Override
    protected boolean connectSerial() throws IOException {
        try {
            int speed = 9600;
            int dataBits = 8;
            int stopBits = 1;
            int parity = 0;
            this.serialPort = null;
            boolean portFound = false;
            CommPortIdentifier portId = null;
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                String shortPortName = this.portName.replace("/dev/", "");
                String curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase(this.portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: " + this.portName);
                portFound = true;
                break;
            }
            if (!portFound) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "aclas: port incorect : \"" + this.portName + "\"." + " Corectati si reporniti !!", LangRoAll.nuPotContinua);
                return false;
            }
            PortSettingsPureJava settings = new PortSettingsPureJava();
            settings.setName(this.portName);
            settings.setSpeed(speed);
            settings.setDataBits(dataBits);
            settings.setStopBits(stopBits);
            settings.setPariry(parity);
            this.serialPort = (SerialPort)portId.open("aclas", 2000);
            this.inS = this.serialPort.getInputStream();
            this.outS = this.serialPort.getOutputStream();
            this.serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
            return true;
        }
        catch (PortInUseException e) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "aclas: port ocupat : \"" + this.portName + "\" ." + "<br> Verificati ce aplicatii folosesc portul, SAU incercati mai tarziu, SAU restart", LangRoAll.nuPotContinua);
        }
        catch (UnsupportedCommOperationException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        return false;
    }

    @Override
    protected boolean connectTCP() {
        try {
            Vector items = Utils.splitString(this.portName, '=');
            if (items.size() < 3 || !Validators.correctString((String)items.get(1)) || !Validators.correctInteger((String)items.get(2))) {
                Logger.logError((Object)this, "Configurare incorecta . Eroare fatala!!");
                Utils.systemExit();
            }
            String ip = (String)items.get(1);
            int port = Integer.parseInt((String)items.get(2));
            this.socket = new Socket();
            InetSocketAddress sa = new InetSocketAddress(ip, port);
            this.socket.connect(sa);
            this.inS = this.socket.getInputStream();
            this.outS = this.socket.getOutputStream();
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    @Override
    protected void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void closeSerialPort() {
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void errorDialog(String message, String title) {
        DialogUtils.errorDialog(GuiUtils.currentFrame, message, title);
    }

    public void deleteNonPrintedBons(NonPrintedBonInterface inter) {
        this.outQueue.clear();
    }
}

