/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.aclas;

import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.aclas.AclasDefaultImpl;
import ro.atreides.ecr.aclas.noarch.AclasXmlHandler;
import ro.atreides.ecr.aclas.noarch.Bon;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageDiscount;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageDrawerCashEntry;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageDrawerCashPaid;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessagePayment;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageSaleProduct;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageSubtotal;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageXReport;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageZReport;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    AclasDefaultImpl driver;
    private boolean discountGlobal;
    private boolean errorNotifications;
    private boolean discountLaProdus;
    private String port;
    private String defaultPayment = "";

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(conf.getProperty("discountLaProdus", "false"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.defaultPayment = conf.getProperty("defaultPayment", "").toUpperCase();
        Logger.logInfo(this, "table = " + this.paymentTypes + " defaultPayment : " + this.defaultPayment);
        this.port = conf.getProperty("ecrPort", "/dev/ttyS0");
        this.port = this.port.replace("/dev/", "");
    }

    @Override
    public void processXml(String fileName) {
        try {
            AclasXmlHandler xmlHandler = new AclasXmlHandler(this.paymentTypes, this.defaultPayment);
            Utils.importXml((DefaultHandler)xmlHandler, fileName);
            this.processBon(xmlHandler.getReceipt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void processBon(Bon b) {
        this.driver.addBon(b);
    }

    private AclasMessageDiscount calculeazaProcentDiscount(double valoareOriginala, double discount, boolean discountGlobal) {
        if (discount == 0.0) {
            return null;
        }
        if (valoareOriginala < discount) {
            double procent = discount * 100.0 / valoareOriginala;
            AclasMessageDiscount disc = new AclasMessageDiscount(discountGlobal, procent, LangRoAll.majorare, true);
            return disc;
        }
        if (valoareOriginala > discount) {
            double procent = discount * 100.0 / valoareOriginala;
            AclasMessageDiscount disc = new AclasMessageDiscount(discountGlobal, procent, LangRoAll.discount, false);
            return disc;
        }
        AclasMessageDiscount disc = new AclasMessageDiscount(discountGlobal, 99.99, LangRoAll.discount, false);
        return disc;
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        AclasMessageDiscount disc;
        Bon b = new Bon(idOrder);
        b.setCashDefault(cashDefault);
        double totalOriginal = 0.0;
        double totalDiscount = 0.0;
        for (Object o : sales) {
            EcrSale sale = (EcrSale)o;
            double price = sale.getPpuDupaDiscount();
            if (this.discountGlobal || this.discountLaProdus) {
                price = sale.getPpuOriginal();
            }
            AclasMessageSaleProduct produs = new AclasMessageSaleProduct(price, sale.getQuantity(), sale.getProduct(), "", sale.getDepartament());
            b.addProduct(produs);
            if (this.discountLaProdus) {
                b.addProduct(this.calculeazaProcentDiscount(sale.getPpuOriginal(), sale.getDiscount(), false));
                continue;
            }
            if (!this.discountGlobal) continue;
            totalDiscount += sale.getDiscount() * sale.getQuantity();
            totalOriginal += sale.getPpuOriginal() * sale.getQuantity();
        }
        if (this.discountGlobal && totalDiscount != 0.0 && (disc = this.calculeazaProcentDiscount(totalOriginal, totalDiscount, true)) != null) {
            b.addProduct(new AclasMessageSubtotal());
            b.addProduct(disc);
        }
        double totalPlatit = 0.0;
        for (Object o : plati) {
            EcrPlata plata = (EcrPlata)o;
            AclasMessagePayment payment = new AclasMessagePayment(plata.getEcrMapping(), plata.getSuma());
            b.addPayment(payment);
            totalPlatit += plata.getSuma();
        }
        this.driver.addBon(b);
    }

    @Override
    public void printX() {
        Bon b = new Bon();
        b.addProduct(new AclasMessageXReport());
        this.driver.addBon(b);
    }

    @Override
    public void printZ() {
        Bon b = new Bon();
        b.addProduct(new AclasMessageZReport());
        this.driver.addBon(b);
    }

    @Override
    public void introduNumerar(double suma) {
        Bon b = new Bon();
        if (suma > 0.0) {
            b.addProduct(new AclasMessageDrawerCashEntry(suma));
        } else if (suma < 0.0) {
            b.addProduct(new AclasMessageDrawerCashPaid(-suma));
        } else {
            return;
        }
        this.driver.addBon(b);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void startECR() {
        this.driver = new AclasDefaultImpl(this.port);
        this.driver.setName("AclasImpl");
        this.driver.start();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.driver.deleteNonPrintedBons(this.inter);
        }
    }

    @Override
    public int getNoOfBonsToPrint() {
        if (this.driver != null) {
            return this.driver.getNoOfBonsToPrint();
        }
        return 0;
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public boolean ecrConnectedAtStartup() {
        return false;
    }
}

