/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.aclas.noarch;

import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.aclas.noarch.AclasUtils;
import ro.atreides.ecr.aclas.noarch.Bon;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageDiscount;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageFooterMessage;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageOpenDrawer;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessagePayment;
import ro.atreides.ecr.aclas.noarch.messages.AclasMessageSaleProduct;
import ro.atreides.utils.Utils;

public class AclasXmlHandler
extends DefaultHandler {
    Bon b = null;
    double totalSales;
    double totalPlati;
    protected Hashtable<String, String> paymentTypes;
    protected Vector<AclasMessageFooterMessage> comments = new Vector();
    private String defaultPayment;

    public AclasXmlHandler(Hashtable<String, String> paymentTypes, String defaultPayment) {
        this.paymentTypes = paymentTypes;
        this.defaultPayment = defaultPayment;
    }

    public Bon getReceipt() {
        return this.b;
    }

    private void addCommentsIfAny() {
        if (this.comments.size() > 0) {
            for (AclasMessageFooterMessage comment : this.comments) {
                this.b.addProduct(comment);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            double price;
            String name = attributes.getValue("label");
            double priceOriginal = price = Utils.parseDouble(attributes.getValue("price"));
            String priceOrigS = attributes.getValue("priceOriginal");
            if (AclasUtils.correctFloat(priceOrigS)) {
                priceOriginal = Utils.parseDouble(priceOrigS);
            }
            double quantity = Utils.parseDouble(attributes.getValue("quantity"));
            String department = attributes.getValue("department");
            AclasMessageSaleProduct produs = new AclasMessageSaleProduct(priceOriginal, quantity, name, "", department);
            this.b.addProduct(produs);
            this.totalSales += quantity * price;
            if (price != priceOriginal) {
                boolean isMajorare;
                boolean bl = isMajorare = price > priceOriginal;
                if (isMajorare) {
                    double percent = (price - priceOriginal) / priceOriginal * 100.0;
                    AclasMessageDiscount discount = new AclasMessageDiscount(false, percent, "MAJORARE", isMajorare);
                    this.b.addProduct(discount);
                } else {
                    double percent = (priceOriginal - price) / priceOriginal * 100.0;
                    AclasMessageDiscount discount = new AclasMessageDiscount(false, percent, "DISCOUNT", isMajorare);
                    this.b.addProduct(discount);
                }
            }
        } else if (qName.equalsIgnoreCase("payment")) {
            double amount = Utils.parseDouble(attributes.getValue("amount"));
            String type = attributes.getValue("type");
            type = type.toUpperCase();
            String codCasa = this.paymentTypes.get(type);
            AclasMessagePayment payment = new AclasMessagePayment(codCasa, amount);
            this.b.addProduct(payment);
            this.totalPlati += amount;
        } else if (qName.equalsIgnoreCase("ad")) {
            String text = attributes.getValue("text");
            if (AclasUtils.correctString(text) && this.comments.size() < 2) {
                AclasMessageFooterMessage footer = new AclasMessageFooterMessage(this.comments.size() + 1, text);
                this.comments.add(footer);
            }
        } else if (qName.equalsIgnoreCase("discount")) {
            double percent = Utils.parseDouble(attributes.getValue("percent"));
            AclasMessageDiscount discount = new AclasMessageDiscount(false, percent, "DISCOUNT", false);
            this.b.addProduct(discount);
        } else if (qName.equalsIgnoreCase("adaos")) {
            double percent = Utils.parseDouble(attributes.getValue("percent"));
            AclasMessageDiscount adaos = new AclasMessageDiscount(false, percent, "ADAOS", false);
            this.b.addProduct(adaos);
        } else if (qName.equalsIgnoreCase("receipt")) {
            String idBon = attributes.getValue("bonId");
            String idOrderS = attributes.getValue("idOrder");
            int idOrder = Integer.parseInt(idOrderS);
            this.b = new Bon(idOrder);
            this.totalSales = 0.0;
            this.totalPlati = 0.0;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("receipt")) {
            String cod;
            if (this.totalPlati < this.totalSales && (cod = this.paymentTypes.get(this.defaultPayment)) != null) {
                this.b.addProduct(new AclasMessagePayment(cod, this.totalSales - this.totalPlati));
            }
            AclasMessageOpenDrawer drawer = new AclasMessageOpenDrawer();
            this.b.addProduct(drawer);
            this.comments.clear();
        }
    }
}

