/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.cashprn;

import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private int ecrPort = 1;
    private int decimalPointPosition = 2;
    private String cashPrnCommand = "";

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.ecrPort = Integer.parseInt(conf.getProperty("ecrPort", "1"));
        this.cashPrnCommand = conf.getProperty("cashPrnCommand", "cashprn ") + " ";
        this.decimalPointPosition = Integer.parseInt(conf.getProperty("decimalPointPosition", "3"));
    }

    @Override
    public void printBonFiscal(Vector<EcrSale> sales, double total, Vector<EcrPlata> plati, TipPlata cashDefault, Vector<String> comments, String orderIdentifier, int idOrder) {
        for (EcrPlata plata : plati) {
            if (Validators.correctString(plata.getEcrMapping())) continue;
            Logger.logWarning(this, "Tipul de plata : " + plata.getTipPlata() + " nu are setat ecr mapping.");
            return;
        }
        String items = "";
        for (EcrSale sale : sales) {
            String price = Utils.getString2DecimalsNoTrunc(sale.getPpuDupaDiscount());
            price = price.replace(".", "");
            String line = this.cashPrnCommand + "1;" + this.ecrPort + ";1;" + sale.getCod() + ";" + sale.getDepartament() + ";" + Utils.getStringMaxSize(12, sale.getProduct(), Character.valueOf(' '), false) + ";" + Utils.getString3DecimalsNoTrunc(sale.getQuantity()) + ";" + price + ";0;" + this.decimalPointPosition + ";1;" + sale.getCodTva();
            items = items + line + "\r\n";
        }
        for (String comment : comments) {
            if (!Validators.correctString(comment)) continue;
            String line = this.cashPrnCommand + "2;" + this.ecrPort + ";1;" + Utils.getStringMaxSize(16, comment, Character.valueOf(' '), false);
            items = items + line + "\r\n";
        }
        String line = this.cashPrnCommand + "0;" + this.ecrPort + ";1";
        items = items + line + "\r\n";
        Logger.logDebugVerbose(this, "Content bon fiscal : " + items);
        this.pt.addToQueue(items);
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public boolean multiplePaymentTypesSupported() {
        return false;
    }
}

