/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrDialogUtils;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.client.LocatieTransmisie;
import ro.atreides.utils.HttpUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private int ecrClientPort;
    private String ecrClientHost;
    private static final String casaFile = "client.ser";
    private Vector<LocatieTransmisie> sectii;
    private boolean serverErrorNotifications;
    private boolean catreToateSectiile = false;

    private void writeToDisk(Vector list) {
        try {
            FileOutputStream fout = new FileOutputStream(casaFile);
            ObjectOutputStream out = new ObjectOutputStream(fout);
            out.writeObject(list);
            out.flush();
            out.close();
            fout.close();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private Vector readFromDisk() {
        try {
            FileInputStream fin = new FileInputStream(casaFile);
            ObjectInputStream in = new ObjectInputStream(fin);
            Vector list = (Vector)in.readObject();
            in.close();
            fin.close();
            return list;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (ClassNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        return new Vector();
    }

    public synchronized String getCommands() {
        Vector list = this.readFromDisk();
        if (list.size() > 0) {
            String tmp = (String)list.get(0);
            return tmp;
        }
        return null;
    }

    public synchronized void removeTop() {
        Vector list = this.readFromDisk();
        if (list.size() > 0) {
            list.remove(0);
            this.writeToDisk(list);
        }
    }

    public synchronized void addCommand(String urlRequest) {
        Vector list = this.readFromDisk();
        list.add(urlRequest);
        this.writeToDisk(list);
    }

    @Override
    public void buildConfiguration(Properties conf) {
        this.ecrClientHost = conf.getProperty("ecrClientHost");
        this.ecrClientPort = Integer.parseInt(conf.getProperty("ecrClientPort"));
        this.sectii = new Vector();
        String sectiiString = conf.getProperty("locationsList");
        if (sectiiString != null && sectiiString != "") {
            String[] sectiiSplit = sectiiString.split("\\|");
            int numarSectii = sectiiSplit.length;
            for (int i = 0; i < numarSectii && !this.catreToateSectiile; ++i) {
                String s = sectiiSplit[i];
                LocatieTransmisie loc = new LocatieTransmisie(s);
                if (loc.getSectie().equalsIgnoreCase("All")) {
                    this.catreToateSectiile = true;
                    this.sectii.removeAllElements();
                    this.sectii.add(loc);
                    break;
                }
                this.sectii.add(loc);
            }
        } else {
            LocatieTransmisie locatieTransmisie = new LocatieTransmisie();
            locatieTransmisie.setIp(this.ecrClientHost);
            locatieTransmisie.setPort(this.ecrClientPort);
            locatieTransmisie.setSectie("All");
            this.sectii.add(locatieTransmisie);
        }
        this.serverErrorNotifications = Boolean.parseBoolean(conf.getProperty("serverErrorNotifications", "true"));
    }

    @Override
    public boolean start() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    String fullUrl;
                    if ((fullUrl = Generic.this.getCommands()) != null) {
                        try {
                            String result = HttpUtils.postHttpPage(fullUrl);
                            if (result != null && result.equalsIgnoreCase("OK")) {
                                Generic.this.removeTop();
                            }
                        }
                        catch (Exception e) {
                            Logger.logException(this, e);
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        for (LocatieTransmisie loc : this.sectii) {
            int i;
            StringBuffer text = new StringBuffer();
            double suma = 0.0;
            boolean existaProdusePeSectie = false;
            text.append("<receipt bonId=\"" + orderIdentifier + "\" idOrder=\"" + idOrder + "\">\n");
            for (i = 0; i < sales.size(); ++i) {
                EcrSale sale = (EcrSale)sales.elementAt(i);
                if (!sale.getNumeSectie().equalsIgnoreCase(loc.getSectie()) && !loc.getSectie().equalsIgnoreCase("All")) continue;
                existaProdusePeSectie = true;
                String codTva = "1";
                if (Validators.correctString(sale.getCodTva())) {
                    codTva = sale.getCodTva() + "";
                }
                String prod = TextUtils.escapeForXML(sale.getProduct());
                text.append("<product label=\"" + prod + "\"" + " price=\"" + Utils.getString2DecimalsNoTrunc(sale.getPpuDupaDiscount()) + "\"" + " priceOriginal=\"" + Utils.getString2DecimalsNoTrunc(sale.getPpuOriginal()) + "\"" + " quantity=\"" + Utils.getString3DecimalsNoTrunc(sale.getQuantity()) + "\"" + " department=\"" + sale.getDepartament() + "\"" + " group=\"" + sale.getGrupa() + "\"" + " vat=\"" + codTva + "\"" + " vatRate=\"" + Utils.getString2Decimals(sale.getCotaTva()) + "\"" + " productCode=\"" + sale.getCod() + "\"" + " />\n");
                suma += sale.getPpuDupaDiscount() * sale.getQuantity();
            }
            if (!existaProdusePeSectie) continue;
            for (i = 0; i < comments.size(); ++i) {
                String com = (String)comments.elementAt(i);
                com = TextUtils.escapeForXML(com);
                text.append("<ad text=\"" + com + "\" />");
            }
            if (loc.getSectie().equalsIgnoreCase("All")) {
                for (i = 0; i < plati.size(); ++i) {
                    EcrPlata pl = (EcrPlata)plati.elementAt(i);
                    text.append("<payment type=\"" + pl.getTipPlata() + "\" amount=\"" + Utils.getString2DecimalsNoTrunc(pl.getSuma()) + "\" />");
                }
            } else {
                String tipPlata2 = "Cash";
                if (cashDefault != null) {
                    tipPlata2 = cashDefault.getLabel();
                }
                if (plati.size() > 0) {
                    EcrPlata plata = (EcrPlata)plati.get(0);
                    tipPlata2 = plata.getTipPlata();
                }
                for (int i2 = 0; i2 < plati.size(); ++i2) {
                    text.append("<payment type=\"" + tipPlata2 + "\" amount=\"" + Utils.getString2DecimalsNoTrunc(suma) + "\" />");
                }
            }
            text.append("</receipt>\n");
            Logger.logDebugVerbose(this, "Locatia " + loc.getSectie() + ": Content bon fiscal " + orderIdentifier + ": " + text);
            String fullUrl = "";
            if (this.serverErrorNotifications) {
                fullUrl = "http://" + loc.getIp() + ":" + loc.getPort() + "/ecrPrint/all?verify=on";
                String result = HttpUtils.getHttpPage(fullUrl);
                if (result == null) {
                    String message = "<html>Server de casa de marcat negasit la <font color=red size=4>" + loc.getIp() + ":" + loc.getPort() + "</font>" + "<br>Cauze posibile:" + "<br>1) Server inchis" + "<br>2) Greseli de configurare</html>";
                    String[] buttons = new String[]{"Trimite bonul, va fi tiparit la repornirea serverului", "Anuleaza bonul"};
                    String rs1 = null;
                    while (rs1 == null) {
                        rs1 = EcrDialogUtils.choiseDialog(GuiUtils.currentFrame, message, "Atentie", buttons);
                    }
                    if (rs1.equals(buttons[1])) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "BON FISCAL ANULAT !!!! Folositi functia de retiparire !!!", "Atentie");
                        return;
                    }
                } else if (!result.equalsIgnoreCase("OK")) {
                    String m = "<html><font color=red size=5>Casa de marcat deconectata !!!</font><br>Verificati:<font color=blue><br>1) Casa este conectata la calculator<br>2) Casa este in modul vanzare<br>3) Scoateti Z (golire)</font></html>";
                    DialogUtils.errorDialog(GuiUtils.currentFrame, m, "Atentie");
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "<html>Bonul fiscal va fi tiparit AUTOMAT dupa conectarea casei de marcat.<br><font color=\"red\" size=5>NU DATI RETIPARIRE</font></html>", "Atentie");
                }
            }
            try {
                String encodedText = URLEncoder.encode(text.toString(), "UTF-8");
                fullUrl = "http://" + loc.getIp() + ":" + loc.getPort() + "/ecrPrint/all?xml=" + encodedText;
                this.addCommand(fullUrl);
            }
            catch (UnsupportedEncodingException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    public boolean startServer() {
        return false;
    }

    @Override
    public void processXml(String fileName) {
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public boolean multiplePaymentTypesSupported() {
        if (this.catreToateSectiile) {
            return super.multiplePaymentTypesSupported();
        }
        return false;
    }
}

