/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Fprint
extends AbstractCashRegister {
    private boolean forceTotal;
    private boolean forceTotalAt2Decimals;
    private boolean discountGlobal;
    private boolean priceAsLong;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
        this.forceTotalAt2Decimals = Boolean.parseBoolean(conf.getProperty("forceTotalAt2Decimals", "false"));
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.priceAsLong = Boolean.parseBoolean(conf.getProperty("priceAsLong", "false"));
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        long printPrice = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            printPrice *= 10L;
        }
        String items = "";
        Iterator iter = sales.iterator();
        boolean aDouaZecimala = false;
        double totalFaraReducere = 0.0;
        double totalReducere = 0.0;
        while (iter.hasNext()) {
            double price;
            String line = "S,1,______,_,__;";
            EcrSale newsaleentry = (EcrSale)iter.next();
            String pNou = newsaleentry.getProduct().toUpperCase();
            line = line + Utils.getStringMaxSize(22, pNou, null, false) + ";";
            double quantity = newsaleentry.getQuantity();
            double d = price = this.discountGlobal ? newsaleentry.getPpuOriginal() : newsaleentry.getPpuDupaDiscount();
            if (this.priceAsLong) {
                long priceL = (long)((double)printPrice * price);
                line = line + priceL + ";";
            } else {
                line = line + Utils.getString2DecimalsNoTrunc(price) + ";";
            }
            line = line + Utils.getString3DecimalsNoTrunc(quantity) + ";";
            String dep = Fprint.getDepartament(newsaleentry);
            line = line + dep + ";";
            line = line + Fprint.getGrupa(newsaleentry) + ";";
            String codTva = newsaleentry.getCodTva();
            if (Validators.correctString(codTva)) {
                line = line + codTva + ";";
            }
            line = line + "0;0;";
            items = items + line + "\n";
            double value = price * newsaleentry.getQuantity();
            totalFaraReducere += newsaleentry.getPpuOriginal() * newsaleentry.getQuantity();
            totalReducere += (newsaleentry.getPpuOriginal() - newsaleentry.getPpuDupaDiscount()) * newsaleentry.getQuantity();
            double valueFaraZecimala = FloatUtils.roundDoubleUp(value, 1);
            if (value == valueFaraZecimala) continue;
            Logger.logWarning(this, "2 Zecimale !! " + line);
            aDouaZecimala = true;
        }
        if (comments.size() > 0) {
            items = items + "P,1,______,_,__;";
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = (String)comments.elementAt(i);
            o = o.toUpperCase();
            List<String> lines = Utils.splitEqually(o, 16);
            for (String line : lines) {
                items = items + line + ";";
            }
        }
        if (comments.size() > 0) {
            items = items + ";;;\n";
        }
        if (this.discountGlobal && totalReducere != 0.0) {
            items = items + "T,1,______,_,__;4;;;;;\n";
            char command = '1';
            if (totalReducere < 0.0) {
                command = '0';
                totalReducere = -totalReducere;
            }
            double procent = totalReducere * 100.0 / totalFaraReducere;
            items = items + "C,1,______,_,__;" + command + ";" + Utils.getString2DecimalsNoTrunc(procent) + ";;;;\n";
        }
        if (plati == null || plati.size() == 0) {
            items = items + "T,1,______,_,__;\n";
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                double platimAcum = plata.getSuma();
                if (this.priceAsLong) {
                    long priceL = (long)((double)printPrice * platimAcum);
                    items = items + "T,1,______,_,__;" + plata.getEcrMapping() + ";" + priceL + ";;;;\n";
                } else {
                    items = items + "T,1,______,_,__;" + plata.getEcrMapping() + ";" + Utils.getString2DecimalsNoTrunc(platimAcum) + ";;;;\n";
                }
                totalPlatit += platimAcum;
            }
            if (this.forceTotal || totalPlatit < total || aDouaZecimala && this.forceTotalAt2Decimals) {
                items = items + "T,1,______,_,__;\n";
            }
        }
        this.pt.addToQueue(items);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + items);
    }

    @Override
    public void introduNumerar(double suma) {
        String codOp = "";
        String sumaNoua = "";
        if (suma > 0.0) {
            codOp = "0";
        } else if (suma < 0.0) {
            codOp = "1";
        } else {
            return;
        }
        suma = Math.abs(suma);
        sumaNoua = Utils.getString2DecimalsNoTrunc(suma);
        String s = "I,1,______,_,__;" + codOp + ";" + sumaNoua + ";;;;\n";
        this.pt.addToQueue(s);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + s);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void forceTotal() {
        String items = "T,1,______,_,__;\n";
        this.pt.addToQueue(items);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + items);
    }
}

