/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.datecs.CasaDeMarkatXmlHandler;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.MP55Interface;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private CasaDeMarkatXmlHandler xmlHandler;
    protected MP55Interface casa;
    protected boolean forceTotal;
    protected boolean forceTotalAt2Decimals;
    protected boolean discountGlobal;
    protected boolean errorNotifications;
    protected boolean discountLaProdus;
    protected Vector ecrLicenseCode = new Vector();
    private String discountText;
    private String adaosText;
    protected int ecrId = 0;
    private Object syncLock = new Object();
    protected Vector<String> filters = new Vector();
    private boolean useDefaultXmlHandler;
    protected boolean rts = false;
    protected PortSettingsPureJava.SerialLibrary serialLibraryType = PortSettingsPureJava.SerialLibrary.PURE_JAVA;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.discountText = conf.getProperty("discountText", "Discount");
        this.adaosText = conf.getProperty("adaosText", "Adaos");
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
        this.forceTotalAt2Decimals = Boolean.parseBoolean(conf.getProperty("forceTotalAt2Decimals", "false"));
        Enumeration<?> enu = conf.propertyNames();
        while (enu.hasMoreElements()) {
            String nume = (String)enu.nextElement();
            if (!nume.startsWith("datecs.ecr.code.")) continue;
            String value = conf.getProperty(nume);
            this.ecrLicenseCode.add(value);
        }
        String s2 = conf.getProperty("ecrLicenceCode");
        if (Validators.correctString(s2)) {
            this.ecrLicenseCode.add(s2);
        }
        this.ecrLicenseCode.add("917b203efec1c523103f234b21b83e53bc3bed1");
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(conf.getProperty("discountLaProdus", "false"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.ecrId = Integer.parseInt(conf.getProperty("ecrId", "0"));
        String prop = conf.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        this.filters = Utils.splitString(prop, ',');
        if (this.discountLaProdus) {
            this.discountGlobal = false;
        }
        this.useDefaultXmlHandler = Boolean.parseBoolean(conf.getProperty("useDefaultXmlHandler", "true"));
        this.rts = Boolean.parseBoolean(conf.getProperty("rts", "false"));
        this.serialLibraryType = PortSettingsPureJava.SerialLibrary.valueOf(conf.getProperty("serialLibraryType", "PURE_JAVA"));
        System.out.println("Filters: " + this.filters + " ecrId : " + this.ecrId);
    }

    @Override
    public void addLicenseCode(String licenseCode) {
        this.ecrLicenseCode.add(licenseCode);
    }

    @Override
    public boolean ecrConnectedAtStartup() {
        return false;
    }

    public Generic() {
        this.xmlHandler = new CasaDeMarkatXmlHandler();
    }

    public void processBonFiscal(String items, String bonId, int idOrder) {
        System.out.println("Received bonId \"" + bonId + "\" items \"" + items + "\"");
        if (this.casa != null) {
            this.casa.process(items, idOrder, bonId);
        }
    }

    @Override
    public synchronized void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER");
        this.casa.stop();
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER");
        Vector<EcrFeedbackInterface> feedbackInterface = new Vector();
        if (this.casa != null) {
            this.casa.stop();
            feedbackInterface = this.casa.getListeners();
        }
        this.casa = new MP55Impl(this.ecrLicenseCode, this.ecrId, feedbackInterface, this.rts, this.serialLibraryType);
        this.casa.setForceTotal(this.forceTotal);
        this.casa.setFilters(this.filters);
        this.casa.setErrorNotifications(this.errorNotifications);
        this.casa.start();
    }

    @Override
    public void processXml(String xmlFilename) {
        if (this.useDefaultXmlHandler) {
            super.processXml(xmlFilename);
        } else {
            try {
                this.xmlHandler.resetBuffer();
                this.xmlHandler.setMaxGrp(ecrMaxGrp);
                this.xmlHandler.setMinGrp(ecrMinGrp);
                Utils.importXml((DefaultHandler)this.xmlHandler, xmlFilename);
                String bon = this.xmlHandler.getBuffer().toUpperCase();
                String idBon = this.xmlHandler.getIdBon();
                Logger.logDebug(this, "Received from xml bon:" + idBon);
                Logger.logDebugVerbose(this, "Received from xml, content = " + bon);
                int idOrder = this.xmlHandler.getIdOrder();
                this.processBonFiscal(bon, idBon, idOrder);
            }
            catch (Throwable e) {
                Logger.logError((Object)this, e);
            }
        }
    }

    public static String buildBonFiscalText(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder, boolean discountGlobal, boolean discountLaProdus, boolean forceTotal, boolean forceTotalAt2Decimals, String discountText, String adaosText) {
        boolean subtotal = false;
        String items = "";
        Iterator iter = sales.iterator();
        boolean aDouaZecimala = false;
        double totalFaraReducere = 0.0;
        double totalReducere = 0.0;
        while (iter.hasNext()) {
            double procent;
            String line = "S,1,______,_,__;";
            EcrSale newsaleentry = (EcrSale)iter.next();
            String pNou = newsaleentry.getProduct().toUpperCase();
            line = line + Utils.getStringMaxSize(22, pNou, null, false) + ";";
            double quantity = newsaleentry.getQuantity();
            double discount = 0.0;
            double price = discountGlobal || discountLaProdus ? newsaleentry.getPpuOriginal() : newsaleentry.getPpuDupaDiscount();
            discount = discountLaProdus ? newsaleentry.getDiscount() : 0.0;
            line = line + Utils.getString2DecimalsNoTrunc(price) + ";";
            line = line + Utils.getString3DecimalsNoTrunc(quantity) + ";";
            String dep = Generic.getDepartament(newsaleentry);
            line = line + dep + ";";
            line = line + Generic.getGrupa(newsaleentry) + ";";
            String codTva = newsaleentry.getCodTva();
            if (Validators.correctString(codTva)) {
                line = line + codTva + ";";
            }
            line = line + "0;0;";
            items = items + line + "\n";
            double value = price * newsaleentry.getQuantity();
            double valoareCurentFaraReducere = newsaleentry.getPpuOriginal() * newsaleentry.getQuantity();
            totalFaraReducere += valoareCurentFaraReducere;
            double reducereCurenta = (newsaleentry.getPpuOriginal() - newsaleentry.getPpuDupaDiscount()) * newsaleentry.getQuantity();
            totalReducere += reducereCurenta;
            double valueFaraZecimala = FloatUtils.roundDoubleUp(value, 1);
            if (value != valueFaraZecimala) {
                Logger.logWarning(Generic.class.getName(), "2 Zecimale !! " + line);
                aDouaZecimala = true;
            }
            if (discount == 0.0) continue;
            char command = '1';
            String text = discountText;
            if (totalReducere < 0.0) {
                command = '0';
                totalReducere = -totalReducere;
                text = adaosText;
            }
            if ((procent = reducereCurenta * 100.0 / valoareCurentFaraReducere) == 100.0) {
                procent = 99.99;
            }
            items = items + "C,1,______,_,__;" + command + ";" + Utils.getString2DecimalsNoTrunc(procent) + ";;;;\n";
            items = items + "P,1,______,_,__;" + text + ";;;;;\n";
        }
        if (comments.size() > 0) {
            items = items + "P,1,______,_,__;";
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = (String)comments.elementAt(i);
            if (!Validators.correctString(o)) {
                o = " ";
            }
            o = o.toUpperCase();
            List<String> lines = Utils.splitEqually(o, 16);
            for (String line : lines) {
                items = items + line + ";";
            }
        }
        if (comments.size() > 0) {
            items = items + ";;;\n";
        }
        if (discountGlobal && totalReducere != 0.0) {
            double procent;
            items = items + "T,1,______,_,__;4;;;;;\n";
            char command = '1';
            String text = discountText;
            if (totalReducere < 0.0) {
                command = '0';
                totalReducere = -totalReducere;
                text = adaosText;
            }
            if ((procent = totalReducere * 100.0 / totalFaraReducere) == 100.0) {
                procent = 99.99;
            }
            items = items + "C,1,______,_,__;" + command + ";" + Utils.getString2DecimalsNoTrunc(procent) + ";;;;\n";
            items = items + "P,1,______,_,__;" + text + ";;;;;\n";
        }
        if (plati == null || plati.size() == 0) {
            items = items + "T,1,______,_,__;\n";
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                if (!plata.isDefault()) {
                    double platimAcum = plata.getSuma();
                    items = items + "T,1,______,_,__;" + plata.getEcrMapping() + ";" + Utils.getString2DecimalsNoTrunc(platimAcum) + ";;;;\n";
                    totalPlatit += platimAcum;
                    continue;
                }
                if (!(totalPlatit < total)) continue;
                items = items + "T,1,______,_,__;" + plata.getEcrMapping() + ";;;;;\n";
                totalPlatit = total;
            }
            if (forceTotal || totalPlatit < total || aDouaZecimala && forceTotalAt2Decimals) {
                items = items + "T,1,______,_,__;\n";
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String items = Generic.buildBonFiscalText(sales, total, plati, cashDefault, comments, orderIdentifier, idOrder, this.discountGlobal, this.discountLaProdus, this.forceTotal, this.forceTotalAt2Decimals, this.discountText, this.adaosText);
        Object object = this.syncLock;
        synchronized (object) {
            this.processBonFiscal(items, orderIdentifier, idOrder);
        }
        Logger.logDebugVerbose(this, "Content bon fiscal : " + items);
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void introduNumerar(double suma) {
        String codOp = "";
        String sumaNoua = "";
        if (suma > 0.0) {
            codOp = "0";
        } else if (suma < 0.0) {
            codOp = "1";
        } else {
            return;
        }
        suma = Math.abs(suma);
        sumaNoua = Utils.getString2DecimalsNoTrunc(suma);
        String s = "I,1,______,_,__;" + codOp + ";" + sumaNoua + ";;;;\n";
        Object object = this.syncLock;
        synchronized (object) {
            String idBon = Utils.getLocalComputerName() + "_L_" + "numerar";
            this.processBonFiscal(s, idBon, -1);
        }
        Logger.logDebugVerbose(this, "Content bon fiscal : " + s);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.xmlHandler.setPaymentTypes(this.paymentTypes);
        this.startECR();
    }

    public void modifyECRparametres(String portname, int speed) {
        Logger.logVerbose(this, "modifyECRparametres() method does NOT modify ANYTHING, deprecated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceTotal() {
        String items = "T,1,______,_,__;\n";
        Object object = this.syncLock;
        synchronized (object) {
            String idBon = Utils.getLocalComputerName() + "_L_" + "total";
            this.processBonFiscal(items, idBon, -1);
        }
        Logger.logDebugVerbose(this, "Content bon fiscal : " + items);
    }

    @Override
    public int getNoOfBonsToPrint() {
        if (this.casa != null) {
            return this.casa.getNoOfBonsToPrint();
        }
        return 0;
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.casa.deleteNonPrintedBons(this.inter);
            this.casa.setAnulareBon(true);
            this.stopECR();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Logger.logException(this, (Exception)e);
            }
            this.startECR();
        }
    }

    @Override
    public void deleteBonByIdentifier(String identifier) {
        this.casa.deleteByIdentifier(identifier);
    }

    @Override
    public void clearFeedbackFile() {
        this.casa.clearFeedbackFile();
    }

    @Override
    public String getFeedbackByIdentifier(String identifier) {
        return this.casa.getFeedback(identifier);
    }

    @Override
    public void addListener(EcrFeedbackInterface listener) {
        this.casa.addListener(listener);
    }
}

