/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.util.Date;

public class ArrivedMessage {
    public static final int TYPE_ACK = 0;
    public static final int TYPE_NACK = 1;
    public static final int TYPE_1 = 2;
    public static final int TYPE_3 = 3;
    public static final int TYPE_7 = 4;
    public static final int TYPE_A = 5;
    public static final int TYPE_B = 6;
    public static final int TYPE_F = 7;
    public static final int TYPE_NOTHING = -1;
    private int type = -1;
    private String seria;
    private int index = -1;
    private int nrBon = -1;
    private int nrZ = -1;
    private double total = -1.0;
    private byte[] sourceMessage;
    private boolean isIDLE = true;
    private boolean isError_Message = false;
    private Date receivedAt;

    public ArrivedMessage(byte[] source) {
        this.sourceMessage = source;
    }

    public ArrivedMessage(int type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getNrBon() {
        return this.nrBon;
    }

    public void setNrBon(int nrBon) {
        this.nrBon = nrBon;
    }

    public int getNrZ() {
        return this.nrZ;
    }

    public void setNrZ(int nrZ) {
        this.nrZ = nrZ;
    }

    public String getSeria() {
        return this.seria;
    }

    public void setSeria(String seria) {
        this.seria = seria;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public boolean hasTotalRest() {
        if (this.nrZ == -1) {
            return !this.isIDLE();
        }
        return this.getTotal() != 0.0;
    }

    public static ArrivedMessage buildAck() {
        return new ArrivedMessage(0);
    }

    public static ArrivedMessage buildNack() {
        return new ArrivedMessage(1);
    }

    public static ArrivedMessage buildNothingMessage() {
        return new ArrivedMessage(-1);
    }

    public boolean isValid() {
        return this.type != -1;
    }

    public boolean isType_A() {
        return this.type == 5;
    }

    public boolean isACK() {
        return this.type == 0;
    }

    public boolean isNACK() {
        return this.type == 1;
    }

    public String getSourceBytesAsString() {
        return new String(this.sourceMessage);
    }

    public byte[] getSourceBytesAsBytes() {
        return this.sourceMessage == null ? null : (byte[])this.sourceMessage.clone();
    }

    public boolean isIDLE() {
        return this.isIDLE;
    }

    public void setIDLE(boolean isIDLE) {
        this.isIDLE = isIDLE;
    }

    public boolean isError_Message() {
        return this.isError_Message;
    }

    public void setError_Message(boolean isError_Message) {
        this.isError_Message = isError_Message;
    }

    private String typeToString(int type) {
        switch (type) {
            case 2: {
                return "1";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "7";
            }
            case 5: {
                return "A";
            }
            case 0: {
                return "ACK";
            }
            case 6: {
                return "B";
            }
            case 7: {
                return "F";
            }
            case 1: {
                return "NACK";
            }
            case -1: {
                return "NOTHING";
            }
        }
        return "Unknown(tell me if you see this)";
    }

    public String toString() {
        return "ArrivedMessage{type=" + this.typeToString(this.type) + ", seria='" + this.seria + '\'' + ", index=" + this.index + ", nrBon=" + this.nrBon + ", nrZ=" + this.nrZ + ", total=" + this.total + '}';
    }

    public Date getReceivedAt() {
        return this.receivedAt;
    }

    public void setReceivedAt(Date receivedAt) {
        this.receivedAt = receivedAt;
    }
}

