/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.atreides.ecr.EcrPaymentType;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.drivers.datecs.gen3.noarch.Validators;

public class BonValidator {
    private static final Pattern PATTERN_PRODUCT = Pattern.compile("S,[0-9]*,[^;]*;[^;]*;[0-9]{1,10}[.]?[0-9]*;[0-9]{1,10}[.]?[0-9]*;[0-9]*;[0-9]*;[0-9]*;.*", 2);
    private static final Pattern PATTERN_RETURN = Pattern.compile("S,[0-9]*,[^;]*;[^;]*;-[0-9]{1,10}[.]?[0-9]*;[0-9]{1,10}[.]?[0-9]*;[0-9]*;[0-9]*;[0-9]*;.*", 2);
    private static final Pattern PATTERN_TOTAL_FARA_TIP_PLATA = Pattern.compile("T,[0-9]*,[^;]*;.*", 2);
    private static final Pattern PATTERN_TOTAL_CU_TIP_PLATA_FARA_SUMA = Pattern.compile("T,[0-9]*,[^;]*;[0-6];.*", 2);
    private static final Pattern PATTERN_SUBTOTAL = Pattern.compile("T,[0-9]*,[^;]*;[4];.*", 2);
    private static final Pattern PATTERN_COPIEBON_TOTAL8 = Pattern.compile("T,[0-9]*,[^;]*;[8];.*", 2);
    private static final Pattern PATTERN_COPIEBON_D = Pattern.compile("D,[0-9]*,[^;]*;.*", 2);
    private static final Pattern PATTERN_TOTAL_CU_TIP_PLATA_SI_SUMA = Pattern.compile("T,[0-9]*,[^;]*;[0-6];[0-9]{1,10}[.]?[0-9]*;.*", 2);
    private static final Pattern PATTERN_PRINT = Pattern.compile("P,[0-9]*,[^;]*;[^;]*;.*", 2);
    private static final Pattern PATTERN_Z = Pattern.compile("Z.*", 2);
    private static final Pattern PATTERN_INTRODUCERE = Pattern.compile("I,[0-9]*,[^;]*;[0-1];.*", 2);
    private static final Pattern PATTERN_MAJORARE = Pattern.compile("C,[0-9]*,[^;]*;[0-1];[0-9]{1,10}[.]?[0-9]*;.*", 2);
    private static final Pattern PATTERN_BLOCARE = Pattern.compile("H.*", 2);
    private static final Pattern PATTERN_DEBLOCARE = Pattern.compile("F.*", 2);
    public static final Pattern[] patterns = new Pattern[]{PATTERN_PRODUCT, PATTERN_TOTAL_FARA_TIP_PLATA, PATTERN_TOTAL_CU_TIP_PLATA_FARA_SUMA, PATTERN_TOTAL_CU_TIP_PLATA_SI_SUMA, PATTERN_MAJORARE, PATTERN_PRINT, PATTERN_Z, PATTERN_INTRODUCERE, PATTERN_BLOCARE, PATTERN_DEBLOCARE, PATTERN_COPIEBON_TOTAL8, PATTERN_COPIEBON_D, PATTERN_RETURN};

    public static boolean correctBon(Collection<String> lines) {
        StringBuilder buffer = new StringBuilder();
        boolean incorrectFound = false;
        for (String s : lines) {
            boolean correct = BonValidator.correctLine(s);
            if (!correct) {
                incorrectFound = true;
                buffer.append("<br>").append("<font color=red>").append(s).append("</font>");
                continue;
            }
            buffer.append("<br>").append(s);
        }
        if (incorrectFound) {
            buffer.insert(0, "<html>Formatul bonului este incorrect:");
            buffer.append("<br><br><font size=4>Bonul este ignorat.</font></html>");
            DialogUtils.errorDialog(GuiUtils.currentFrame, buffer.toString(), LangRoAll.eroare);
            return false;
        }
        return true;
    }

    private static boolean correctLine(String line) {
        for (int i = 0; i < patterns.length; ++i) {
            Pattern pattern = patterns[i];
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    boolean checkPattern(Pattern pattern, String line) {
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private boolean checkTotalLine(EcrType ecrType, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>> errors, double platiBonTotal, double valoareBon, Vector plataIntegralaAlready, boolean tryToRepair) {
        if (plataIntegralaAlready.size() > 0) {
            if (!ecrType.isPermitTotalIfPaidInFull()) {
                if (tryToRepair) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.WARNING, ERROR_TYPE.TOTAL_DEJA_ATINS_DAR_LINIE_TOTAL_INTEGRAL));
                    return true;
                }
                errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.TOTAL_DEJA_ATINS_DAR_LINIE_TOTAL_INTEGRAL));
                return false;
            }
        } else if (!(platiBonTotal < valoareBon)) {
            if (platiBonTotal > valoareBon) {
                if (!ecrType.isPermitTotalIfPaidInFull()) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    return false;
                }
            } else if (valoareBon > 0.0 && !ecrType.isPermitTotalIfPaidInFull()) {
                errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                return false;
            }
        }
        return true;
    }

    private Hashtable<ERROR_FUNCTION, ERROR_TYPE> getCurrErr(ERROR_FUNCTION function, ERROR_TYPE type) {
        Hashtable<ERROR_FUNCTION, ERROR_TYPE> currErr = new Hashtable<ERROR_FUNCTION, ERROR_TYPE>();
        currErr.put(function, type);
        return currErr;
    }

    public Map<Integer, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>>> checkForErrors(String inputFile, EcrType ecrType, Map<Double, String> tvaMapping, boolean tryToRepair, int roundValues, int roundQty, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>> generalErrors) {
        Map<Integer, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>>> resultMap = Collections.synchronizedMap(new LinkedHashMap());
        Vector<String> lines = Utils.getLines(inputFile);
        boolean stlFound = false;
        boolean copieBon = false;
        char NULL = '\u0000';
        Vector<Object> plataIntegralaAlready = new Vector<Object>();
        double platiBonTotal = 0.0;
        double platiBonFaraRest = 0.0;
        double valoareBon = 0.0;
        double lastProductValue = 0.0;
        int i = 0;
        for (String line : lines) {
            String codTipPlataS;
            Vector items;
            Vector<Map<ERROR_FUNCTION, ERROR_TYPE>> errors = new Vector<Map<ERROR_FUNCTION, ERROR_TYPE>>();
            resultMap.put(++i, errors);
            if (!Validators.correctString(line)) continue;
            if (copieBon) {
                errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                continue;
            }
            if (this.checkPattern(PATTERN_PRODUCT, line) || this.checkPattern(PATTERN_RETURN, line)) {
                int deptCode;
                String tvaCotaByDever;
                items = ro.atreides.utils.Utils.splitStringKeepStructure(line, ';', NULL);
                if (items.size() < 6) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                String numeProdus = (String)items.get(1);
                String pretS = (String)items.get(2);
                String qtyS = (String)items.get(3);
                String dept = (String)items.get(4);
                String grupa = (String)items.get(5);
                String tvaCode = (String)items.get(6);
                if (!(Validators.correctString(numeProdus) && Validators.correctDouble(pretS) && Validators.correctDouble(qtyS) && Validators.correctInteger(dept) && Validators.correctInteger(grupa) && Validators.correctInteger(tvaCode))) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                if (items.size() > 9 && tvaMapping != null && !(tvaCotaByDever = (String)items.get(9)).equals(NULL + "")) {
                    if (!Validators.correctDouble(tvaCotaByDever)) {
                        errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                        continue;
                    }
                    double tvaCota = Double.parseDouble(tvaCotaByDever);
                    String expectedCode = tvaMapping.get(tvaCota);
                    if (!expectedCode.equalsIgnoreCase(tvaCode)) {
                        errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.TVA_INCORECT));
                        continue;
                    }
                }
                if ((deptCode = Integer.parseInt(dept)) > ecrType.getMaxDepartments()) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.DEPARTAMENT_INCORECT));
                    continue;
                }
                double toRoundPrice = Double.parseDouble(pretS);
                double price = FloatUtils.roundDoubleUp(toRoundPrice, roundValues);
                if (price < 0.0 && !ecrType.isAllowNegativePrice()) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.FUNCTIE_RETUR_NESUPORTATA));
                    continue;
                }
                double toRoundQty = Double.parseDouble(qtyS);
                double qty = FloatUtils.roundDoubleUp(toRoundQty, roundQty);
                double value = price * qty;
                lastProductValue = value = FloatUtils.roundDoubleUp(value, roundValues);
                valoareBon += value;
                continue;
            }
            if (this.checkPattern(PATTERN_SUBTOTAL, line)) {
                stlFound = true;
                continue;
            }
            if (this.checkPattern(PATTERN_COPIEBON_TOTAL8, line)) {
                copieBon = true;
                continue;
            }
            if (this.checkPattern(PATTERN_COPIEBON_D, line)) {
                copieBon = true;
                continue;
            }
            if (this.checkPattern(PATTERN_TOTAL_CU_TIP_PLATA_SI_SUMA, line)) {
                if (!this.checkTotalLine(ecrType, errors, platiBonTotal, valoareBon, plataIntegralaAlready, tryToRepair)) continue;
                items = ro.atreides.utils.Utils.splitStringKeepStructure(line, ';', NULL);
                codTipPlataS = (String)items.get(1);
                if (!Validators.correctInteger(codTipPlataS)) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                String sumaS = (String)items.get(2);
                if (sumaS.equals(NULL + "")) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                double platimAcum = Double.parseDouble(sumaS);
                platimAcum = FloatUtils.roundDoubleUp(platimAcum, roundValues);
                Character codTP = Character.valueOf(codTipPlataS.charAt(0));
                Map<Character, EcrPaymentType> payments = ecrType.getPayments();
                EcrPaymentType paymentType = payments.get(codTP);
                if (paymentType == null) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.TIP_PLATA_INCORECT));
                    continue;
                }
                platiBonTotal += platimAcum;
                if (!paymentType.isPermiteRest()) {
                    platiBonFaraRest += platimAcum;
                }
                if (!(platiBonTotal >= valoareBon)) continue;
                plataIntegralaAlready.add(new Object());
                continue;
            }
            if (this.checkPattern(PATTERN_TOTAL_CU_TIP_PLATA_FARA_SUMA, line)) {
                if (!this.checkTotalLine(ecrType, errors, platiBonTotal, valoareBon, plataIntegralaAlready, tryToRepair)) continue;
                items = ro.atreides.utils.Utils.splitStringKeepStructure(line, ';', NULL);
                codTipPlataS = (String)items.get(1);
                if (!Validators.correctInteger(codTipPlataS)) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                plataIntegralaAlready.add(new Object());
                continue;
            }
            if (this.checkPattern(PATTERN_TOTAL_FARA_TIP_PLATA, line)) {
                if (!this.checkTotalLine(ecrType, errors, platiBonTotal, valoareBon, plataIntegralaAlready, tryToRepair)) continue;
                plataIntegralaAlready.add(new Object());
                continue;
            }
            if (this.checkPattern(PATTERN_MAJORARE, line)) {
                items = ro.atreides.utils.Utils.splitStringKeepStructure(line, ';', NULL);
                String operatie = (String)items.get(1);
                if (!Validators.correctInteger(operatie)) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                String valoareS = (String)items.get(2);
                if (!Validators.correctDouble(valoareS)) {
                    errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
                    continue;
                }
                double val = Double.parseDouble(valoareS);
                val = FloatUtils.roundDoubleUp(val, roundValues);
                Integer operInt = Integer.parseInt(operatie);
                double baseValue = lastProductValue;
                if (stlFound) {
                    baseValue = valoareBon;
                }
                double newVal = baseValue;
                switch (operInt) {
                    case 1: {
                        double toRound = baseValue * (100.0 - val) / 100.0;
                        newVal = FloatUtils.roundDoubleUp(toRound, roundValues);
                        break;
                    }
                    case 2: {
                        double toRound2 = baseValue * (100.0 + val) / 100.0;
                        newVal = FloatUtils.roundDoubleUp(toRound2, roundValues);
                    }
                }
                valoareBon = newVal > baseValue ? (valoareBon += newVal - baseValue) : (valoareBon -= baseValue - newVal);
                valoareBon = FloatUtils.roundDoubleUp(valoareBon, roundValues);
                continue;
            }
            if (this.checkPattern(PATTERN_PRINT, line)) {
                System.out.println("P");
                continue;
            }
            if (this.checkPattern(PATTERN_Z, line)) {
                System.out.println("Z");
                continue;
            }
            if (this.checkPattern(PATTERN_INTRODUCERE, line)) {
                System.out.println("INPUT");
                continue;
            }
            if (this.checkPattern(PATTERN_BLOCARE, line)) {
                System.out.println("BLOCARE");
                continue;
            }
            if (this.checkPattern(PATTERN_DEBLOCARE, line)) {
                System.out.println("DEBLOCARE");
                continue;
            }
            errors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.SINTAXA_INCORECTA));
        }
        if (plataIntegralaAlready.size() <= 0 && platiBonTotal < valoareBon) {
            generalErrors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.TOTALUL_NU_ACOPERA_PRODUSELE));
        }
        if (platiBonFaraRest > valoareBon) {
            generalErrors.add(this.getCurrErr(ERROR_FUNCTION.ERROR, ERROR_TYPE.PLATA_MAI_MARE_DECAT_TOTALUL_SI_NU_POT_DA_REST));
        }
        return resultMap;
    }

    public static final void main(String[] args) {
        BonValidator.testFile("teste_ecr/test_total_standard.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_total_standard.inp", "000000", EcrType.Datecs_MP55);
        BonValidator.testFile("teste_ecr/test_bon_polisano.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_bon_polisano_total_cu_suma_ok.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_bon_polisano_total_cu_suma_preamare_si_cash.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_bon_polisano_total_cu_suma_preamare_si_card.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_zecimala3.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_total_depasit.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_total_atins_si_forcetotal.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_total_insuficient.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_card_depasit.inp", "000000", EcrType.Datecs_DP25);
        BonValidator.testFile("teste_ecr/test_card_depasit.inp", "000000", EcrType.Datecs_MP55);
        BonValidator.testFile("teste_ecr/test_card_ok.inp", "000000", EcrType.Datecs_DP25);
    }

    private static void testFile(String file, String serieFiscala, EcrType ecrType) {
        BonValidator bv = new BonValidator();
        boolean tryToRepair = false;
        try {
            String inputFile3 = FileUtils.readFileToString(file);
            Vector<Map<ERROR_FUNCTION, ERROR_TYPE>> generalErrors = new Vector<Map<ERROR_FUNCTION, ERROR_TYPE>>();
            Map<Integer, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>>> errorsDP25Bad3 = bv.checkForErrors(inputFile3, ecrType, null, tryToRepair, 2, 3, generalErrors);
            System.out.println("Nume test : " + file + " tip casa : " + (Object)((Object)ecrType));
            String out4 = BonValidator.createFprintLikeOutput(errorsDP25Bad3, inputFile3, serieFiscala, generalErrors);
            System.out.println(out4);
        }
        catch (IOException e) {
            Logger.logException("BonValidator", (Exception)e);
        }
    }

    public static String createFprintLikeOutput(Map<Integer, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>>> errors, String content, String serieFiscalaCasa, Vector<Map<ERROR_FUNCTION, ERROR_TYPE>> generalErrors) {
        boolean isGeneralError = false;
        String generalErrorsLine = "";
        for (Map<ERROR_FUNCTION, ERROR_TYPE> errTypeMap : generalErrors) {
            for (ERROR_FUNCTION error_function : errTypeMap.keySet()) {
                switch (error_function) {
                    case ERROR: {
                        isGeneralError = true;
                    }
                }
                ERROR_TYPE value = errTypeMap.get((Object)error_function);
                generalErrorsLine = generalErrorsLine + value.toString() + ",";
            }
        }
        String out = "";
        int sequence = 1;
        int i = 1;
        Vector<String> lines = Utils.getLines(content);
        for (String line : lines) {
            String resultLine = line.substring(0, 3);
            resultLine = resultLine + "," + serieFiscalaCasa + "," + sequence++ + ",";
            Vector<Map<ERROR_FUNCTION, ERROR_TYPE>> errorsAtLine = errors.get(i);
            boolean isErr = false;
            for (Map<ERROR_FUNCTION, ERROR_TYPE> errTypeMap : errorsAtLine) {
                for (ERROR_FUNCTION error_function : errTypeMap.keySet()) {
                    switch (error_function) {
                        case ERROR: {
                            isErr = true;
                        }
                    }
                }
            }
            resultLine = isErr || isGeneralError ? resultLine + "Er;" : resultLine + "Ok;";
            resultLine = resultLine + line.substring(16, line.length());
            for (Map<ERROR_FUNCTION, ERROR_TYPE> errTypeMap : errorsAtLine) {
                for (ERROR_TYPE errValue : errTypeMap.values()) {
                    resultLine = resultLine + errValue.toString() + ",";
                }
            }
            ++i;
            if (sequence > 9) {
                sequence = 0;
            }
            out = out + resultLine + "\r\n";
        }
        if (Validators.correctString(generalErrorsLine)) {
            out = out + "T,1," + serieFiscalaCasa + "," + i + ",";
            out = isGeneralError ? out + "Er;" : out + "Ok;";
            out = out + generalErrorsLine + "\r\n";
        }
        return out;
    }

    public static enum ERROR_TYPE {
        TOTALUL_NU_ACOPERA_PRODUSELE(true),
        TVA_INCORECT(false),
        DEPARTAMENT_INCORECT(false),
        TIP_PLATA_INCORECT(false),
        SINTAXA_INCORECTA(false),
        FUNCTIE_RETUR_NESUPORTATA(false),
        PLATA_MAI_MARE_DECAT_TOTALUL_SI_NU_POT_DA_REST(true),
        TOTAL_DEJA_ATINS_DAR_LINIE_TOTAL_INTEGRAL(true);

        private boolean canBeRepaired;

        private ERROR_TYPE(boolean canBeRepaired) {
            this.canBeRepaired = canBeRepaired;
        }

        public boolean isCanBeRepaired() {
            return this.canBeRepaired;
        }
    }

    public static enum ERROR_FUNCTION {
        WARNING,
        ERROR;

    }
}

