/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class CasaDeMarkatServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        String verifyOnly = request.getParameter("verify");
        if (Validators.correctString(verifyOnly)) {
            if (!EcrLogic.getInstance().isEcrConnected()) {
                this.sendResponse("CASA DE MARCAT DECONECTATA", out);
            } else {
                this.sendResponse("OK", out);
            }
            return;
        }
        String action = request.getParameter("xml");
        String unique = request.getParameter("unique");
        if (unique == null) {
            unique = "";
        }
        if (action != null) {
            this.sendBonXML(action);
        } else {
            action = request.getParameter("native");
            if (action != null) {
                this.sendBonNative(action, unique, -1);
            }
        }
        if (action != null) {
            this.sendResponse("OK", out);
        } else {
            this.sendResponse("ERROR", out);
        }
    }

    private void sendResponse(String s, PrintWriter out) {
        out.write(s);
        out.flush();
    }

    private synchronized void sendBonXML(String xml) {
        String filename = "casademarkat_temp_for_bons.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file, false);
            writer.append(xml);
            writer.flush();
            writer.close();
            EcrLogic.getInstance().getEcr().processXml(filename);
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
        }
    }

    private synchronized void sendBonNative(String bon, String externalIdBon, int idOrder) {
        StringBuffer sb = new StringBuffer();
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(bon));
        boolean firstline = true;
        try {
            String line = lineNumberReader.readLine();
            while (line != null) {
                if (Validators.correctString(line)) {
                    if (firstline && line.toUpperCase().startsWith("UNIQUE")) {
                        Vector tokens = Utils.splitString(line, '=');
                        externalIdBon = (String)tokens.get(1);
                    } else {
                        sb.append(line + "\n");
                    }
                    firstline = false;
                }
                line = lineNumberReader.readLine();
            }
        }
        catch (IOException e) {
            Logger.logException((Object)this, (Exception)e);
        }
        EcrLogic.getInstance().getEcr().processBonFiscal(sb.toString(), externalIdBon, idOrder, null, null, null);
    }
}

