/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.util.Date;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;

public class EcrLogger {
    public static final int DEBUGVERBOSE = 6;
    public static final int DEBUG = 5;
    public static final int VERBOSE = 4;
    public static final int INFO = 3;
    public static final int WARNING = 2;
    public static final int ERROR = 1;
    public static final int NONE = 0;
    private int logLevel = 6;
    private boolean PRINT_SYSTEM_OUT = true;
    private StringBuilder buffer = new StringBuilder();
    private int nrBon = 0;
    private int nrZ = 0;
    private int id;

    public EcrLogger(int id) {
        this.id = id;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (EcrLogger.this.buffer.length() > 0) {
                    Logger.logError((Object)this, EcrLogger.this.buffer.toString());
                }
            }
        });
    }

    public void setNrBon(int nrBon) {
        this.nrBon = nrBon;
    }

    public void setNrZ(int nrZ) {
        this.nrZ = nrZ;
    }

    public void saveLogs(Date date) {
        String log = this.buffer.toString();
        this.buffer.delete(0, this.buffer.length());
        Utils.saveLog(log, this.nrZ, this.nrBon, date, this.id);
    }

    public synchronized void logException(Object o, Exception ex) {
        this.logException(o.getClass().getName(), ex);
    }

    public synchronized void logException(String className, Exception ex) {
        String message = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()) + " : " + className + " : " + ex.getMessage();
        this.print(message);
    }

    public synchronized void log(String className, String message, int level) {
        if (level <= this.logLevel) {
            String text = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()) + " : " + className + " : " + message;
            this.buffer.append(text).append('\n');
            if (this.PRINT_SYSTEM_OUT) {
                System.out.println(text);
            }
        }
    }

    private void print(String s) {
        this.buffer.append(s);
        this.buffer.append("\n");
        if (this.PRINT_SYSTEM_OUT) {
            System.out.println(s + "\n");
        }
    }

    public synchronized void logInfo(String className, String message) {
        this.log(className, message, 3);
    }

    public synchronized void logInfo(Object o, String message) {
        this.log(o.getClass().getName(), message, 3);
    }

    public synchronized void logDebugVerbose(String className, String message) {
        this.log(className, message, 6);
    }

    public synchronized void logDebugVerbose(Object o, String message) {
        this.log(o.getClass().getName(), message, 6);
    }

    public synchronized void logDebug(String className, String message) {
        this.log(className, message, 5);
    }

    public synchronized void logDebug(Object o, String message) {
        this.log(o.getClass().getName(), message, 5);
    }

    public synchronized void logVerbose(String className, String message) {
        this.log(className, message, 4);
    }

    public synchronized void logVerbose(Object o, String message) {
        this.log(o.getClass().getName(), message, 4);
    }

    public synchronized void logWarning(String className, String message) {
        this.log(className, message, 2);
    }

    public synchronized void logWarning(Object o, String message) {
        this.log(o.getClass().getName(), message, 2);
    }

    public synchronized void logError(String className, String message, Throwable th) {
        this.log(className, message, 1);
        if (th != null) {
            th.printStackTrace();
        }
    }

    public synchronized void logError(Object o, String message) {
        this.logError(o.getClass().getName(), message, null);
    }

    public synchronized void logError(Object o, Throwable th) {
        this.logError(o.getClass().getName(), th.getMessage(), th);
    }

    public synchronized void logError(Object o, String message, Throwable th) {
        this.logError(o.getClass().getName(), message, th);
    }
}

