/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.InputStream;
import java.io.OutputStream;
import ro.atreides.ecr.datecs.nativeImpl.EcrLogger;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecs.nativeImpl.Reader;
import ro.atreides.ecr.datecs.nativeImpl.ReaderImpl;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.ecr.datecs.nativeImpl.Writer;

public class EcrPortInstanse {
    private PortSettingsPureJava settings;
    private InputStream input;
    private OutputStream output;
    private SerialPortWrapper serialPort;
    private Writer writer;
    private Reader reader;

    public EcrPortInstanse(InputStream in, OutputStream out, SerialPortWrapper port, PortSettingsPureJava settings) {
        this.input = in;
        this.output = out;
        this.serialPort = port;
        this.settings = settings;
        this.writer = new Writer(out);
        this.reader = new ReaderImpl(in, port);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getPort() {
        return this.settings.getName();
    }

    public int getSpeed() {
        return this.settings.getSpeed();
    }

    public void setLogger(EcrLogger ecrLogger) {
        if (this.writer != null) {
            this.writer.setEcrLogger(ecrLogger);
        }
        if (this.reader != null) {
            this.reader.setEcrLogger(ecrLogger);
        }
    }

    public synchronized void close() {
        Utils.closeAll(this.input, this.output, this.serialPort);
        this.input = null;
        this.output = null;
        this.serialPort = null;
    }
}

