/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.util.Date;
import java.util.Vector;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.datecs.nativeImpl.AcquireLockTimeoutException;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.CasaClosedException;
import ro.atreides.ecr.datecs.nativeImpl.Constants;
import ro.atreides.ecr.datecs.nativeImpl.DoNotProcessCurrentBonException;
import ro.atreides.ecr.datecs.nativeImpl.EcrImpl;
import ro.atreides.ecr.datecs.nativeImpl.MP55Interface;
import ro.atreides.ecr.datecs.nativeImpl.MessageTypes;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecs.nativeImpl.Product;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.ecr.datecs.nativeImpl.Wrapper;
import ro.atreides.utils.Logger;

public class MP55Impl
extends EcrImpl
implements MP55Interface {
    private static final int ACQUIRE_LOCK_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 150;
    private static final int SUCCESS = 0;
    private static final int CLOSED_BEFORE_SELL = 1;
    private static final int CLOSED_BEFORE_CONFIRM = 2;
    private static final int ANULARE_BON = 3;
    private static final int IGNORED_PRODUCT = 4;
    private ArrivedMessage lastLocked;
    private boolean forceTotal = true;
    private boolean anulareBon = false;
    private int nrBon = 0;
    private int nrZ = 0;

    public MP55Impl(Vector license, int id, Vector<EcrFeedbackInterface> feedbackInterface, boolean rts, PortSettingsPureJava.SerialLibrary type) {
        super(license, id, feedbackInterface, rts, type);
    }

    @Override
    public void setAnulareBon(boolean anulareBon) {
        this.anulareBon = anulareBon;
    }

    public boolean isForceTotal() {
        return this.forceTotal;
    }

    @Override
    public void setForceTotal(boolean forceTotal) {
        this.forceTotal = forceTotal;
    }

    private boolean check_running() throws CasaClosedException {
        if (this.isRunning()) {
            return true;
        }
        throw new CasaClosedException();
    }

    private void finishedBon(CASA_EXPLAIN_MESSAGES explain, Bon bon, int nrBon, int nrZ, boolean lastBon) {
        this.productsList.selled(bon);
        bon.setCasaExplain(explain);
        bon.setCasaBon(nrBon + "");
        bon.setCasaZ(nrZ + "");
        this.feedbackList.addBon(bon);
        this.notifyListeners(explain, bon, nrBon, nrZ, lastBon);
    }

    @Override
    protected void startSelling() {
        Logger.logVerbose(this, "ECR " + this.id + " : STARTING TO SELL");
        Utils.startEcrLoggsArchivatorThread(this.id);
        while (true) {
            try {
                while (true) {
                    Bon bon = this.productsList.nextBon();
                    if (EcrLogic.skipBons <= 0) {
                        Date start = new Date();
                        this.sell_bon(bon);
                        this.finishedBon(CASA_EXPLAIN_MESSAGES.BON_IN_QUEUE_WHEN_DRIVER_STARTED, bon, this.nrBon, this.nrZ, true);
                        this.logger.saveLogs(start);
                        continue;
                    }
                    --EcrLogic.skipBons;
                    this.finishedBon(CASA_EXPLAIN_MESSAGES.BON_SKIPPED_BECAUSE_CMDLINE_PARAM, bon, -1, -1, false);
                    System.out.println("Skipping bon!");
                }
            }
            catch (CasaClosedException e) {
                Logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>> ECR " + this.id + " : CLOSED <<<<<<<<<<<<<<<<<<<<<<<<<");
                this.stop();
                return;
            }
            catch (DoNotProcessCurrentBonException doNotProcessCurrentBonException) {
                continue;
            }
            break;
        }
    }

    private void sell_bon(Bon bon) throws CasaClosedException, DoNotProcessCurrentBonException {
        if (bon == null) {
            this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>  ECR " + this.id + " : BON == NULL <<<<<<<<<<<<<<<<<<<<");
            return;
        }
        this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  ECR " + this.id + " :BON START <<<<<<<<<<<<<<<<<<<<<<<<<<");
        this.logger.logVerbose(this, bon.getSource());
        this.releaseLock();
        this.printTotalBefore();
        if (!this.licenseInstance.isLicensed()) {
            this.logger.logVerbose(this, " ECR " + this.id + " :HAVE NO LICENSE");
            this.sell_product(this.wrapper.buildNoLicenseMessage());
            MP55Impl mP55Impl = this;
            this.sell_product(mP55Impl.wrapper.buildTotal());
            return;
        }
        Vector<Product> selled_products = new Vector<Product>();
        boolean selledOneProduct = false;
        try {
            Vector<Product> products = bon.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                int result;
                Product p = products.get(i);
                if (i + 1 == products.size()) {
                    this.finishedBon(CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY, bon, this.nrBon, this.nrZ, true);
                }
                if ((result = this.sell_product(p)) == 0) {
                    selledOneProduct = true;
                    selled_products.add(p);
                    continue;
                }
                this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>  NOT SUCCESS  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                if (result == 1) {
                    this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>> CLOSED BEFORE SELL <<<<<<<<<<<<<<<<<<<<<<<");
                    throw new CasaClosedException();
                }
                if (result == 2) {
                    this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>> CLOSED BEFORE CONFIRM <<<<<<<<<<<<<<<<<<<<<<");
                    throw new CasaClosedException();
                }
                if (result == 3) {
                    this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>> ANULARE BON <<<<<<<<<<<<<<<<<<<<<<<<<<");
                    this.anulare_bon(selled_products);
                    return;
                }
                if (result != 4) continue;
                this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>> IGNORED PRODUCT <<<<<<<<<<<<<<<<<<<<<<<<<<");
            }
        }
        catch (CasaClosedException e) {
            if (selledOneProduct) {
                this.finishedBon(CASA_EXPLAIN_MESSAGES.BON_CLOSED_COMMAND_F, bon, this.nrBon, this.nrZ, true);
            }
            throw e;
        }
        this.printTotalAfter();
        this.releaseLock();
    }

    private void anulare_bon(Vector products) throws CasaClosedException {
        this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>>> ANULATING BON <<<<<<<<<<<<<<<<<<<<<<<<<");
        this.releaseLock();
        products = Wrapper.getAnulareForProducts(products);
        for (int i = 0; i < products.size(); ++i) {
            Product p = (Product)products.get(i);
            int result = this.sell_product(p);
            if (result != 2 && result != 1) continue;
            this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> ANULARE NU A REUSIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> SCOT TOTALUL SI GATA <<<<<<<<<<<<<<<<<<<<<<<<<<<");
            break;
        }
        this.releaseLock();
        MP55Impl mP55Impl = this;
        this.sell_product(mP55Impl.wrapper.buildTotal());
    }

    private int sell_product(Product product) throws CasaClosedException {
        int number_of_atempts_after_error_reply = 0;
        this.logger.logVerbose(this, "\n");
        this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>  ECR " + this.id + " : SELLING START <<<<<<<<<<<<<<<<<<<<<<<<");
        this.logger.logVerbose(this, ">>>>>>>>>>> PRODUCT: " + product.getSource() + " <<<<<<<<<");
        double oldTotal = 0.0;
        while (true) {
            ArrivedMessage lock;
            String id = null;
            String first_id = null;
            int maxRetries = 3;
            while (this.check_running() && maxRetries > 0) {
                lock = this.lock();
                if (lock == null) {
                    return 1;
                }
                if (lock.isError_Message()) {
                    this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> THIS IS ERROR MESSAGE(B or F) <<<<<<<<<<<<<<<<<<<<<<<<");
                    this.logger.logVerbose(this, ">>>>> " + lock);
                    this.freeLock();
                    continue;
                }
                this.logger.setNrZ(lock.getNrZ());
                this.logger.setNrBon(lock.getNrBon());
                this.nrBon = lock.getNrBon();
                this.nrZ = lock.getNrZ();
                oldTotal = lock.getTotal();
                id = this.typeA_TO_ID(lock);
                if (first_id == null) {
                    first_id = id;
                } else if (!first_id.equals(id)) {
                    this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>>>> DUBLARE DETECTATA <<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                    return 0;
                }
                this.logger.logVerbose(this, lock.toString());
                boolean done = false;
                for (int i = 0; i < 8; ++i) {
                    this.logger.logVerbose(this, ">> retry index = " + i);
                    this.write(product.getRawMessage());
                    ArrivedMessage mm = this.read(100);
                    this.logger.logVerbose(this, mm.toString());
                    if (mm.getType() != 0) continue;
                    done = true;
                    break;
                }
                if (done) break;
                this.freeLock();
                --maxRetries;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {}
            }
            this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> SELLED, CONFIRMING... <<<<<<<<<<<<<<<<<<<<<<<<");
            this.releaseLock();
            lock = this.lock_new();
            if (lock == null) {
                return 2;
            }
            if (lock.isError_Message()) {
                first_id = null;
                this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> CONFIRM: THIS IS ERROR MESSAGE(B or F) <<<<<<<<<<<<<<<<<<<<<<<<");
                this.logger.logVerbose(this, ">>>>> " + lock);
                if (++number_of_atempts_after_error_reply <= 10) continue;
                this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> NUMBER OF ERROR ATTEMPTS REACHED THE LIMIT, SHOWING ERROR DIALOG <<<<<<<<<<<<<<<<<");
                id = this.typeA_TO_ID(lock);
            }
            String second_id = this.typeA_TO_ID(lock);
            boolean isTotalWrong = false;
            if (product.getItemType() == MessageTypes.PRODUCT) {
                double newTotal = lock.getTotal();
                this.logger.logVerbose(this, "AVEM UN PRODUCT : OLD TOTAL : " + oldTotal + " NEW TOTAL : " + newTotal);
                if (newTotal == oldTotal) {
                    if (oldTotal != -1.0) {
                        double price = product.getItemPrice();
                        double qty = product.getItemQuantity();
                        double value = price * qty;
                        this.logger.logVerbose(this, "PRODUCT PRICE " + price + " qty : " + qty + " value : " + value);
                        if (value <= 1.0E-4) {
                            this.logger.logVerbose(this, "PRODUCT VALUE IS ZERO. OK !!");
                        } else {
                            this.logger.logVerbose(this, "TOTAL IS WRONG !! ");
                            isTotalWrong = true;
                        }
                    } else {
                        this.logger.logVerbose(this, "CASA DE MARCAT FOAAARTE VECHE . NU AM CAMP DE TOTAL !! ");
                    }
                }
            }
            if (!id.equals(second_id) && !isTotalWrong) break;
            this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>> CONFIRM FAILED <<<<<<<<<<<<<<<<<<<<<<<<<");
            this.freeLock();
            Logger.logVerbose(this, "ECR INTERFACE: PRODUCT PRINT FAILED");
            int tmp = this.ecrInterface.failedPrint(product.clone());
            if (tmp == 2) {
                Logger.logVerbose(this, "ECR INTERFACE: user choose IGNORE PRODUCT");
                return 4;
            }
            if (tmp == 1) {
                Logger.logVerbose(this, "ECR INTERFACE: user choose ANULARE BON");
                return 3;
            }
            Logger.logVerbose(this, "ECR INTERFACE: user choose RETRY PRODUCT");
        }
        this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> CONFIRMED <<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return 0;
    }

    protected void printTotalBefore() throws CasaClosedException, DoNotProcessCurrentBonException {
        this.logger.logVerbose(this, "\n");
        this.logger.logVerbose(this, "TOTAL CHECK BEFORE SELL");
        this.printTotal(false);
    }

    protected void printTotalAfter() throws CasaClosedException, DoNotProcessCurrentBonException {
        this.logger.logVerbose(this, "\n");
        this.logger.logVerbose(this, "TOTAL CHECK AFTER SELL");
        this.printTotal(this.forceTotal);
    }

    private void printTotal(boolean forceTotal) throws CasaClosedException, DoNotProcessCurrentBonException {
        this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> VERIFYING TOTAL START <<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        while (true) {
            ArrivedMessage message = this.lock();
            if (this.anulareBon) {
                this.anulareBon = false;
                throw new DoNotProcessCurrentBonException();
            }
            if (message.isError_Message()) {
                this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> THIS IS ERROR MESSAGE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                this.releaseLock();
                continue;
            }
            if (message != null) {
                String log;
                if (forceTotal) {
                    log = ">>>>>>>>> FORCED TOTAL FOR: " + message.getSourceBytesAsString();
                    Logger.logVerbose(this, log);
                    this.logger.logVerbose(this, log);
                } else {
                    log = ">>>>>>>>> GETTING TOTAL FROM THIS: " + message.getSourceBytesAsString();
                    Logger.logVerbose(this, log);
                    this.logger.logVerbose(this, log);
                }
                if (forceTotal || message.hasTotalRest()) {
                    this.logger.logVerbose(this, ">>>>> FOUND LEFT TOTAL, CLEARING IT UP");
                    MP55Impl mP55Impl = this;
                    int sellResult = this.sell_product(mP55Impl.wrapper.buildTotal());
                    this.freeLock();
                    this.logger.logVerbose(this, ">>>>> CLEAR RESULT = " + sellResult);
                } else {
                    this.logger.logVerbose(this, ">>>>> TOTAL IS ZERO, DOING NOTHING");
                }
                this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>> VERIFYING TOTAL END <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
                return;
            }
            this.freeLock();
        }
    }

    private ArrivedMessage lock() throws CasaClosedException {
        ArrivedMessage lock;
        if (this.lastLocked != null) {
            this.logger.logVerbose(this, ">>>>>>>>>>>>>>>>>>>>>>>> USING LAST LOCK <<<<<<<<<<<<<<<<<<<<<<");
            lock = this.lastLocked;
        } else {
            this.lastLocked = lock = this.acquire_lock();
        }
        return lock;
    }

    private ArrivedMessage lock_new() throws CasaClosedException {
        this.freeLock();
        return this.lock();
    }

    private void freeLock() {
        this.logger.logVerbose(this, ">>>>>> Clearing current lock");
        this.lastLocked = null;
    }

    private ArrivedMessage acquire_lock() throws CasaClosedException {
        ArrivedMessage result;
        while (true) {
            try {
                while ((result = this.acquireLock_TypeA()) == null) {
                }
            }
            catch (AcquireLockTimeoutException e) {
                boolean detected;
                this.logger.logException(this, (Exception)e);
                if (detected = this.detect(false)) continue;
                throw new CasaClosedException();
            }
            break;
        }
        return result;
    }

    private String typeA_TO_ID(ArrivedMessage message) {
        return message.getNrZ() + "_" + message.getNrBon() + "_" + message.getIndex();
    }

    private ArrivedMessage acquireLock_TypeA() throws AcquireLockTimeoutException, CasaClosedException {
        this.logger.logVerbose(this, "Acquiring lock");
        long start = System.currentTimeMillis();
        while (this.check_running() && System.currentTimeMillis() - start < 10000L) {
            this.clearReader();
            this.write(Constants.TAKE_MESSAGE);
            ArrivedMessage message = this.read(150);
            if (!message.isValid()) continue;
            this.write(Constants.ACK_MESSAGE);
            if (message.isType_A()) {
                this.licenseInstance.updateSerie(message.getSeria());
                return message;
            }
            if (!message.isNACK()) continue;
            this.releaseLock();
        }
        throw new AcquireLockTimeoutException();
    }

    private void releaseLock() throws CasaClosedException {
        this.logger.logVerbose(this, "Releasing lock");
        this.freeLock();
        this.write(Constants.RELEASE_MESSAGE);
    }

    public static enum CASA_EXPLAIN_MESSAGES {
        BON_SELLED_NORMALLY(1),
        BON_IN_QUEUE_WHEN_DRIVER_STARTED(2),
        BON_CLOSED_COMMAND_F(3),
        BON_SKIPPED_BECAUSE_CMDLINE_PARAM(4),
        BON_FAILED(5);

        int code;

        private CASA_EXPLAIN_MESSAGES(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

