/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.File;
import java.util.List;
import java.util.Vector;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.tricky.NonPrintedBonInterface;

public class PersistentList {
    public String PERSISTENT_FILE;
    private List products;

    public PersistentList(int id) {
        this("_ecr_persistent_products_list_" + (id == 0 ? "" : Integer.valueOf(id)));
    }

    public PersistentList(String filename) {
        this.PERSISTENT_FILE = filename;
        this.products = Utils.getProductsFor(FileUtils.getCurrentDir() + File.separator + this.PERSISTENT_FILE);
    }

    public Bon nextBon() {
        Bon next;
        while ((next = this.next()) == null) {
            Utils.sleep(50);
        }
        return next;
    }

    private Bon next() {
        return this.products.size() > 0 ? (Bon)this.products.get(0) : null;
    }

    public synchronized void addBon(Bon bon) {
        if (bon != null) {
            this.products.add(bon);
            Utils.setProductsFor(this.products, FileUtils.getCurrentDir() + File.separator + this.PERSISTENT_FILE);
        }
    }

    public synchronized void selled(Bon bon) {
        this.products.remove(bon);
        Utils.setProductsFor(this.products, FileUtils.getCurrentDir() + File.separator + this.PERSISTENT_FILE);
    }

    public synchronized Bon getByIdentifier(String identifier) {
        System.out.println("Searching for identifier " + identifier);
        for (Object product : this.products) {
            Bon b = (Bon)product;
            if (!b.getOrderIdentifier().equals(identifier)) continue;
            return b;
        }
        return null;
    }

    public synchronized void removeByIdentifier(String identifier) {
        Bon b = this.getByIdentifier(identifier);
        if (b != null) {
            System.out.println("gasit idenfier : " + identifier + " si sters!");
            this.products.remove(b);
            Utils.setProductsFor(this.products, FileUtils.getCurrentDir() + File.separator + this.PERSISTENT_FILE);
        }
    }

    public synchronized void deleteNonPrintedBons(NonPrintedBonInterface inter) {
        Bon bon1;
        int i;
        Vector<Bon> toRemove = new Vector<Bon>();
        for (i = 0; i < this.products.size(); ++i) {
            bon1 = (Bon)this.products.get(i);
            if (bon1.getIdOrder() <= 0 || !inter.processNonPrintedBon(bon1.getIdOrder())) continue;
            toRemove.add(bon1);
        }
        for (i = 0; i < toRemove.size(); ++i) {
            bon1 = (Bon)toRemove.elementAt(i);
            this.products.remove(bon1);
        }
        Utils.setProductsFor(this.products, FileUtils.getCurrentDir() + File.separator + this.PERSISTENT_FILE);
    }

    public int size() {
        return this.products.size();
    }

    public synchronized void clear() {
        this.products.clear();
        Utils.setProductsFor(this.products, FileUtils.getCurrentDir() + File.separator + this.PERSISTENT_FILE);
    }
}

