/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Crc;
import ro.atreides.ecr.datecs.nativeImpl.EcrLogger;
import ro.atreides.ecr.datecs.nativeImpl.EventType;
import ro.atreides.ecr.datecs.nativeImpl.Listener;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.atreides.utils.Logger;

public abstract class Reader {
    protected final Crc crcCalculator = new Crc();
    protected byte[] currentMessage = new byte[8192];
    protected byte[] buffer = new byte[4096];
    protected int currentPosition = 0;
    protected InputStream input;
    protected SerialPortWrapper port;
    protected EcrLogger ecrLogger;
    protected Listener listener;

    public Reader(InputStream input, SerialPortWrapper port) {
        this.input = input;
        this.port = port;
    }

    public final void setEcrLogger(EcrLogger logger) {
        this.ecrLogger = logger;
    }

    public final void logDebug(String s) {
        if (this.ecrLogger == null) {
            Logger.logDebug(this, s);
        } else {
            this.ecrLogger.logDebug(this, s);
        }
    }

    public final void logException(Exception e) {
        if (this.ecrLogger == null) {
            Logger.logWarning(this, e.toString());
        } else {
            this.ecrLogger.logException(this, e);
        }
    }

    protected abstract void dataArrived(byte[] var1, int var2, int var3);

    protected void fireEvent(EventType event) {
    }

    public void setListener(Listener l) {
        this.listener = l;
    }

    public abstract ArrivedMessage read(int var1) throws IOException, Exception;

    public abstract void clear();

    public abstract int queueSize();
}

