/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Crc;
import ro.atreides.ecr.datecs.nativeImpl.EventType;
import ro.atreides.ecr.datecs.nativeImpl.Listener;
import ro.atreides.ecr.datecs.nativeImpl.Message;
import ro.atreides.ecr.datecs.nativeImpl.Reader;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.atreides.ecr.datecs.nativeImpl.Wrapper;

public class ReaderImpl
extends Reader {
    public static final int IDLE = 0;
    public static final int SEARCHING_FOR_END = 1;
    public static final int SEARCHING_FOR_FIRST_CRC_BYTE = 2;
    public static final int SEARCHING_FOR_SECOND_CRC_BYTE = 3;
    private int state = 0;
    private Vector messages = new Vector();

    public ReaderImpl(InputStream input, SerialPortWrapper port) {
        super(input, port);
        this.setListener(new Listener(){

            @Override
            public void message(Message message) {
                ArrivedMessage arrived = Wrapper.parse(message);
                if (arrived != null) {
                    ReaderImpl.this.logDebug("Adding to list");
                    ReaderImpl.this.messages.add(arrived);
                } else {
                    ReaderImpl.this.logDebug("Wrapper.parse returned null");
                }
            }

            @Override
            public void ack() {
                ReaderImpl.this.messages.add(ArrivedMessage.buildAck());
            }

            @Override
            public void nack() {
                ReaderImpl.this.messages.add(ArrivedMessage.buildNack());
            }
        });
    }

    @Override
    protected void dataArrived(byte[] buffer, int offset, int len) {
        int i = 0;
        while (i < len) {
            switch (this.state) {
                case 0: {
                    byte b;
                    this.currentPosition = 0;
                    while (i < len) {
                        b = buffer[i];
                        if (b == 6) {
                            this.fireEvent(EventType.ACK_READ);
                            break;
                        }
                        if (b == 21) {
                            this.fireEvent(EventType.NACK_READ);
                            break;
                        }
                        if (b == 10) {
                            this.state = 1;
                            break;
                        }
                        ++i;
                    }
                    ++i;
                    break;
                }
                case 1: {
                    byte b;
                    while (i < len) {
                        b = buffer[i];
                        if (b == 13) {
                            this.state = 2;
                            this.currentMessage[this.currentPosition] = 13;
                            ++this.currentPosition;
                            break;
                        }
                        this.currentMessage[this.currentPosition] = b;
                        ++this.currentPosition;
                        ++i;
                    }
                    ++i;
                    break;
                }
                case 2: {
                    this.currentMessage[this.currentPosition] = buffer[i];
                    ++this.currentPosition;
                    this.state = 3;
                    ++i;
                    break;
                }
                case 3: {
                    this.currentMessage[this.currentPosition] = buffer[i];
                    ++this.currentPosition;
                    this.state = 0;
                    short crc = Crc.crcFast(this.currentMessage, this.currentPosition - 2);
                    short crcInMessage = (short)(this.currentMessage[this.currentPosition - 2] << 8 & 0xFF00 | this.currentMessage[this.currentPosition - 1] & 0xFF);
                    if (crc == crcInMessage) {
                        this.fireEvent(EventType.MESSAGE_OK);
                        return;
                    }
                    this.fireEvent(EventType.MESSAGE_ERROR);
                    return;
                }
            }
        }
    }

    @Override
    protected void fireEvent(EventType event) {
        try {
            switch (event) {
                case ACK_READ: {
                    this.logDebug("Reading ACK");
                    this.listener.ack();
                    break;
                }
                case NACK_READ: {
                    this.logDebug("Reading NACK");
                    this.listener.nack();
                    break;
                }
                case MESSAGE_ERROR: {
                    this.logDebug("crc error");
                    break;
                }
                case MESSAGE_OK: {
                    byte[] tmp = new byte[this.currentPosition - 3];
                    System.arraycopy(this.currentMessage, 0, tmp, 0, this.currentPosition - 3);
                    Message m = new Message(tmp);
                    this.logDebug("Reading : " + m);
                    this.listener.message(m);
                }
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    @Override
    public ArrivedMessage read(int timeout) throws Exception {
        try {
            this.port.enableReceiveTimeout(timeout);
            int n = this.input.read(this.buffer);
            this.dataArrived(this.buffer, 0, n);
            if (n != -1) {
                this.port.enableReceiveTimeout(10);
                while (this.state != 0) {
                    n = this.input.read(this.buffer);
                    this.dataArrived(this.buffer, 0, n);
                }
            }
        }
        catch (IOException e) {
            this.logException(e);
            throw e;
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
        if (this.messages.size() > 0) {
            return (ArrivedMessage)this.messages.remove(0);
        }
        return ArrivedMessage.buildNothingMessage();
    }

    @Override
    public void clear() {
        this.messages.clear();
    }

    @Override
    public int queueSize() {
        return this.messages.size();
    }
}

