/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import gnu.io.SerialPort;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Constants;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortInstanse;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortParams;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsRxtx;
import ro.atreides.ecr.datecs.nativeImpl.Reader;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortPureJavaImpl;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortRxtxImpl;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.atreides.ecr.datecs.nativeImpl.Writer;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ZipUtils;

public class Utils {
    public static final Integer[] speeds = new Integer[]{4800, 9600, 19200, 38400};
    public static final String CONFIG_FILE = "config.txt";
    public static final String LAST_DETECTED_ECR_FILE = "_ecr_last_detected_";
    private static final int DETECT_TIMEOUT = 2000;
    private static final Pattern PATTERN_IS_LOGFILE = Pattern.compile("[0-9]{4}-[0-1][0-9]-[0-3][0-9]_[0-2][0-9]-[0-6][0-9]__[-]?[0-9]{1,5}_[0-9]{1,3}[.]log", 2);
    private static final Object lockArchivator = new Object();
    private static Thread logArchivatorThread;

    public static void sleep(int msec) {
        try {
            Thread.sleep(msec);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Vector<String> getPorts(PortSettingsPureJava.SerialLibrary type) {
        TreeSet<String> treeset = new TreeSet<String>();
        switch (type) {
            case PURE_JAVA: {
                Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                    if (portId.getPortType() != 1) continue;
                    treeset.add(portId.getName());
                }
                return new Vector<String>(treeset);
            }
            case RXTX: {
                Enumeration portList = gnu.io.CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    gnu.io.CommPortIdentifier portId = (gnu.io.CommPortIdentifier)portList.nextElement();
                    if (portId.getPortType() != 1) continue;
                    treeset.add(portId.getName());
                }
                return new Vector<String>(treeset);
            }
        }
        return new Vector<String>();
    }

    public static Integer[] getSpeeds() {
        return speeds;
    }

    public static Vector<EcrPortParams> getEcrPortParams(int id, Vector<String> filters, boolean rts, PortSettingsPureJava.SerialLibrary type) {
        Vector<EcrPortParams> result1 = new Vector<EcrPortParams>();
        EcrPortParams lastDetected = Utils.getLastDetected(id);
        System.out.println("last detected " + lastDetected);
        if (lastDetected != null) {
            result1.add(lastDetected);
        }
        Vector<EcrPortParams> result2 = Utils.getAllEcrPortParams(filters, lastDetected, rts, type);
        result1.addAll(result2);
        return result1;
    }

    private static Vector<EcrPortParams> getAllEcrPortParams(Vector<String> filters, EcrPortParams toSkip, boolean rts, PortSettingsPureJava.SerialLibrary type) {
        Vector<EcrPortParams> result = new Vector<EcrPortParams>();
        Vector<String> ports = Utils.getPorts(type);
        for (int i = 0; i < ports.size(); ++i) {
            String port = ports.get(i);
            boolean ok = false;
            for (int j = 0; j < filters.size() && !ok; ++j) {
                String s = filters.elementAt(j);
                if (type.equals((Object)PortSettingsPureJava.SerialLibrary.PURE_JAVA) && s.startsWith("/dev/")) {
                    s = s.substring(5, s.length());
                }
                if (!port.matches(s)) continue;
                ok = true;
            }
            if (!ok) continue;
            Integer[] speeds = Utils.getSpeeds();
            for (int j = 0; j < speeds.length; ++j) {
                int speed = speeds[j];
                EcrPortParams toAdd = new EcrPortParams(port, speed);
                toAdd.setLibrary(type);
                toAdd.setRts(rts);
                if (toSkip != null && toAdd.equals(toSkip)) continue;
                result.add(toAdd);
            }
        }
        return result;
    }

    public static EcrPortParams getLastDetected(int id) {
        EcrPortParams result = null;
        Object o = Utils.readObjectFrom(LAST_DETECTED_ECR_FILE + (id == 0 ? "" : Integer.valueOf(id)));
        if (o instanceof EcrPortParams) {
            result = (EcrPortParams)o;
        }
        return result;
    }

    public static void setLastDetected(EcrPortParams pp, int id) {
        if (pp != null) {
            Utils.writeObjectTo(pp, LAST_DETECTED_ECR_FILE + (id == 0 ? "" : Integer.valueOf(id)));
        }
    }

    public static EcrPortInstanse detect(EcrPortParams params, int id) {
        EcrPortInstanse ecr = null;
        try {
            PortSettingsPureJava settings = null;
            switch (params.getLibrary()) {
                case PURE_JAVA: {
                    settings = new PortSettingsPureJava();
                    settings.setSpeed(params.getSpeed());
                    settings.setSerialLibraryType(PortSettingsPureJava.SerialLibrary.PURE_JAVA);
                    settings.setName(params.getName());
                    settings.setRTS(params.isRts());
                    ecr = Utils.initPortPureJava(settings);
                    break;
                }
                case RXTX: {
                    settings = new PortSettingsRxtx();
                    settings.setSpeed(params.getSpeed());
                    settings.setSerialLibraryType(PortSettingsPureJava.SerialLibrary.RXTX);
                    settings.setName(params.getName());
                    settings.setRTS(params.isRts());
                    ecr = Utils.initPortRxtx(settings);
                }
            }
            if (ecr != null) {
                Logger.logVerbose(Utils.getClassName(), ">>>>>>>>>>>>>>>>>>>>> DETECTARE CASA cu id " + id + " : port=" + settings.getName() + " speed=" + settings.getSpeed() + " <<<<<<<<<<<<<<<<<<<");
                boolean detected = Utils.detect(ecr.getWriter(), ecr.getReader());
                if (detected) {
                    Logger.logVerbose(Utils.getClassName(), ">>>>> casa cu id " + id + " a fost detectata pe port " + settings.getName() + " viteza " + settings.getSpeed());
                    Utils.setLastDetected(params, id);
                    return ecr;
                }
                Logger.logVerbose(Utils.getClassName(), ">>>>> casa cu id " + id + " NU a fost detectata!");
                ecr.close();
            }
        }
        catch (Exception e) {
            if (ecr != null) {
                ecr.close();
            }
            Logger.logWarning(Utils.class.getName(), e.toString());
        }
        return null;
    }

    public static EcrPortInstanse initPortPureJava(PortSettingsPureJava portSettings) {
        if (portSettings == null) {
            return null;
        }
        Logger.logVerbose(Utils.getClassName(), ">>>>>>>>>>>>>>>>>>> INITIALIZARE: port=" + portSettings.getName() + " speed=" + portSettings.getSpeed() + " <<<<<<<<<<<<<<<<<<");
        SerialPortPureJavaImpl serialPortWrapper = null;
        try {
            String portName = portSettings.getName();
            if (portName == null) {
                Logger.logWarning(Utils.getClassName(), ">>>>> nume port = null");
                throw new NullPointerException();
            }
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != portSettings.getPortType() || !portId.getName().equals(portName)) continue;
                Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
                purejavacomm.SerialPort serialPortReal = (purejavacomm.SerialPort)portId.open("datecs2GenPureJava", 2000);
                serialPortWrapper = new SerialPortPureJavaImpl();
                serialPortWrapper.setRealSerialPort(serialPortReal);
                serialPortWrapper.setRTS(portSettings.isRTS());
                serialPortWrapper.setSerialPortParams(portSettings.getSpeed(), portSettings.getDataBits(), portSettings.getStopBits(), portSettings.getPariry());
                InputStream input = serialPortWrapper.getInputStream();
                OutputStream output = serialPortWrapper.getOutputStream();
                Logger.logInfo(Utils.class.getName(), ">>>>> Initializare port corecta");
                return new EcrPortInstanse(input, output, serialPortWrapper, portSettings);
            }
            Logger.logWarning(Utils.class.getName(), "port indisponibil");
            throw new NoSuchPortException();
        }
        catch (Exception e) {
            Utils.closeAll(null, null, serialPortWrapper);
            Logger.logWarning(Utils.class.getName(), ">>>>> Eroare de initializare port, portul se va inchide");
            Logger.logWarning(Utils.class.getName(), e.toString());
            return null;
        }
    }

    public static EcrPortInstanse initPortRxtx(PortSettingsPureJava portSettings) {
        if (portSettings == null) {
            return null;
        }
        Logger.logVerbose(Utils.getClassName(), ">>>>>>>>>>>>>>>>>>> INITIALIZARE: port=" + portSettings.getName() + " speed=" + portSettings.getSpeed() + " <<<<<<<<<<<<<<<<<<");
        SerialPortRxtxImpl serialPortWrapper = null;
        try {
            String portName = portSettings.getName();
            if (portName == null) {
                Logger.logWarning(Utils.getClassName(), ">>>>> nume port = null");
                throw new NullPointerException();
            }
            Enumeration portList = gnu.io.CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                gnu.io.CommPortIdentifier portId = (gnu.io.CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != portSettings.getPortType() || !portId.getName().equals(portName)) continue;
                Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
                SerialPort serialPortReal = (SerialPort)portId.open("datecs2ndGenRxtx", 2000);
                serialPortWrapper = new SerialPortRxtxImpl();
                serialPortWrapper.setRealSerialPort(serialPortReal);
                serialPortWrapper.setRTS(portSettings.isRTS());
                serialPortWrapper.setSerialPortParams(portSettings.getSpeed(), portSettings.getDataBits(), portSettings.getStopBits(), portSettings.getPariry());
                InputStream input = serialPortWrapper.getInputStream();
                OutputStream output = serialPortWrapper.getOutputStream();
                Logger.logInfo(Utils.class.getName(), ">>>>> Initializare port corecta");
                return new EcrPortInstanse(input, output, serialPortWrapper, portSettings);
            }
            Logger.logWarning(Utils.class.getName(), "port indisponibil");
            throw new NoSuchPortException();
        }
        catch (Exception e) {
            Utils.closeAll(null, null, serialPortWrapper);
            Logger.logWarning(Utils.class.getName(), ">>>>> Eroare de initializare port, portul se va inchide");
            Logger.logWarning(Utils.class.getName(), e.toString());
            return null;
        }
    }

    private static boolean detect(Writer writer, Reader reader) {
        try {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < 2000L) {
                writer.writetoport(Constants.TAKE_MESSAGE);
                ArrivedMessage message = reader.read(100);
                if (!message.isValid()) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.logWarning(Utils.getClassName(), e.toString());
        }
        return false;
    }

    public static void closeAll(InputStream input, OutputStream output, SerialPortWrapper serialPort) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Throwable e) {
            Logger.logWarning(Utils.getClassName(), e.toString());
        }
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (Throwable e) {
            Logger.logWarning(Utils.getClassName(), e.toString());
        }
        try {
            if (serialPort != null) {
                serialPort.close();
            }
        }
        catch (Throwable e) {
            Logger.logWarning(Utils.getClassName(), e.toString());
        }
    }

    public static String load(String key, String filename) {
        String result = "";
        try {
            Properties conf = Utils.loadConfiguration(filename);
            result = conf.getProperty(key, "");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String load(String key) {
        return Utils.load(key, CONFIG_FILE);
    }

    public static int loadAsInt(String key) {
        int result = 0;
        String value = Utils.load(key);
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static void save(String key, String value, String filename) {
        try {
            Properties conf = Utils.loadConfiguration(filename);
            if (key != null && value != null) {
                conf.setProperty(key, value);
                Utils.saveConfiguration(filename, conf);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void save(String key, String value) {
        Utils.save(key, value, CONFIG_FILE);
    }

    public static Properties loadConfiguration(String configFileName) {
        Properties conf = new Properties();
        try {
            conf.load(new FileInputStream(configFileName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return conf;
    }

    private static void saveConfiguration(String configFileName, Properties property) {
        try {
            property.store(new FileOutputStream(configFileName), "ECR ONLINE PROPERTIES");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized List getProductsFor(String file) {
        Vector result = new Vector();
        Object list = Utils.readObjectFrom(file);
        if (list instanceof Vector) {
            result = (Vector)list;
        }
        return result;
    }

    public static synchronized void setProductsFor(Collection products, String file) {
        if (products == null) {
            products = new Vector();
        }
        Utils.writeObjectTo(products, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFrom(String file) {
        Object result = null;
        ObjectInput input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(file));
            result = input.readObject();
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectTo(Object o, String file) {
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            output.writeObject(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getClassName() {
        return Utils.class.getName();
    }

    public static Vector<String> getLines(String s) {
        Vector<String> result = new Vector<String>();
        if (s != null) {
            s = s.replace('\r', '\n');
            String[] lst = s.split("\n");
            for (int i = 0; i < lst.length; ++i) {
                String source = lst[i].trim();
                if (source == null || source.length() <= 0) continue;
                result.add(source);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLog(String log, int nrZ, int nrBon, Date date, int id) {
        String name = Formatters.currentDateAndTimeForFileSystem.format(date) + "__" + nrZ + "_" + nrBon + ".log";
        try {
            String dir = "bonuri" + (id == 0 ? "" : Integer.valueOf(id)) + File.separator;
            new File(dir).mkdirs();
            Object object = lockArchivator;
            synchronized (object) {
                FileUtils.writeTextToFile(dir + name, log);
            }
        }
        catch (Exception e) {
            Logger.logWarning(Utils.getClassName(), e.toString());
        }
    }

    public static ArrayList<LogFile> getCurrentLogsFiles(int id) {
        ArrayList<LogFile> result = new ArrayList<LogFile>();
        File dir = new File("bonuri" + (id == 0 ? "" : Integer.valueOf(id)));
        if (dir.exists() && dir.isDirectory()) {
            Object[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return Utils.isValidLogFile(pathname);
                }
            });
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                Object f = files[i];
                LogFile logFile = Utils.getLogFileForFile((File)f);
                result.add(logFile);
            }
        }
        return result;
    }

    private static LogFile getLogFileForFile(File file) {
        LogFile result = new LogFile();
        String name = file.getName();
        result.setSource(file);
        result.setDataAll(Utils.getDataAllFromFileName(name));
        result.setNrZ(Utils.getNrZfromFileName(name));
        result.setNrBon(Utils.getNrBonFromFileName(name));
        result.setData(Utils.getDataFromFile(name));
        return result;
    }

    private static String getDataAllFromFileName(String filename) {
        return filename.substring(0, filename.indexOf("__"));
    }

    private static String getDataFromFile(String filename) {
        return filename.substring(0, filename.indexOf("_"));
    }

    private static String getNrZfromFileName(String filename) {
        String result = null;
        int indexOfStart = filename.indexOf("__") + 2;
        int indexOfEnd = filename.indexOf("_", indexOfStart);
        if (indexOfStart != -1) {
            result = filename.substring(indexOfStart, indexOfEnd);
        }
        return result;
    }

    private static String getNrBonFromFileName(String filename) {
        String result = null;
        int indexOfStart = filename.indexOf("_", filename.indexOf("__") + 2) + 1;
        int indexOfEnd = filename.indexOf(".", indexOfStart);
        if (indexOfStart != -1) {
            result = filename.substring(indexOfStart, indexOfEnd);
        }
        return result;
    }

    private static boolean isValidLogFile(File file) {
        Matcher matcher;
        return file != null && file.exists() && file.isFile() && (matcher = PATTERN_IS_LOGFILE.matcher(file.getName())).matches();
    }

    public static synchronized void startEcrLoggsArchivatorThread(final int id) {
        if (logArchivatorThread != null) {
            return;
        }
        logArchivatorThread = new Thread(){

            @Override
            public void run() {
                Utils.sleep(300000);
                ArrayList<LogFile> tmp = new ArrayList<LogFile>();
                while (true) {
                    ArrayList<LogFile> files;
                    if ((files = Utils.getCurrentLogsFiles(id)).size() > 0) {
                        tmp.clear();
                        tmp.add(files.get(0));
                        for (int i = 1; i < files.size(); ++i) {
                            LogFile lg = files.get(i);
                            String date = lg.getData();
                            if (date.equals(((LogFile)tmp.get(0)).getData())) {
                                tmp.add(lg);
                                continue;
                            }
                            Utils.archiveLogFiles(tmp, id);
                            tmp.clear();
                            tmp.add(lg);
                        }
                    }
                    Utils.sleep(0x6DDD00);
                }
            }
        };
        logArchivatorThread.start();
    }

    private static void archiveLogFiles(ArrayList files, int id) {
        if (files.size() > 0) {
            String start = ((LogFile)files.get(0)).getNrZ();
            String stop = ((LogFile)files.get(files.size() - 1)).getNrZ();
            if (start.equals("-1")) {
                start = "0";
            }
            if (stop.equals("-1")) {
                stop = "0";
            }
            String Zinterval = start.equals(stop) ? start : start + "-" + stop;
            File[] tt = new File[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                File file;
                LogFile lg = (LogFile)files.get(i);
                tt[i] = file = lg.getSource();
            }
            String zipDir = "bonuri" + (id == 0 ? "" : Integer.valueOf(id)) + File.separator + ((LogFile)files.get(0)).getData() + "__" + Zinterval;
            FileUtils.moveFilesToDir(tt, new File(zipDir), true);
            tt = null;
            String zipFilename = zipDir + ".zip";
            try {
                ZipUtils.zipCreateRecursive(zipDir, zipFilename);
            }
            catch (Exception e) {
                Logger.logException(Utils.getClassName(), e);
                FileUtils.removeFileRecurse(new File(zipFilename));
            }
            FileUtils.removeFileRecurse(new File(zipDir));
        }
    }

    public static final void main(String[] args) {
        try {
            File file = new File("_ecr_persistent_products_list_");
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            Object obj = in.readObject();
            in.close();
        }
        catch (IOException e) {
            Logger.logException("Main", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            Logger.logException("Main", (Exception)e);
        }
    }

    private static class LogFile {
        private File source;
        private String dataAll;
        private String nrBon;
        private String nrZ;
        private String data;

        private LogFile() {
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getDataAll() {
            return this.dataAll;
        }

        public void setDataAll(String dataAll) {
            this.dataAll = dataAll;
        }

        public String getNrBon() {
            return this.nrBon;
        }

        public void setNrBon(String nrBon) {
            this.nrBon = nrBon;
        }

        public String getNrZ() {
            return this.nrZ;
        }

        public void setNrZ(String nrZ) {
            this.nrZ = nrZ;
        }

        public File getSource() {
            return this.source;
        }

        public void setSource(File source) {
            this.source = source;
        }

        public String toString() {
            return "LogFile{source='" + this.source + '\'' + ", dataAll='" + this.dataAll + '\'' + ", data='" + this.data + '\'' + ", nrZ='" + this.nrZ + '\'' + ", nrBon='" + this.nrBon + '\'' + '}';
        }
    }
}

