/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecsgen3;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.PersistentList;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.drivers.datecs.gen3.noarch.LogerInterface;
import ro.deversoft.drivers.datecs.gen3.noarch.ProtocolThread;
import ro.deversoft.drivers.datecs.gen3.noarch.QueBoonAbstract;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.dailyClosure.Raport;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.DiagnosticResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.InfoCurentReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.LastDocumentPrinted;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.ReadingDateResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.TaxRegistrationNumber;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.CloseNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.DebetingCrediting;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.OpenNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.ItemReportResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.TaxRatesDruingPeriodResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.ClosingFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.OpeningFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.SubtotalResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.TotalResponse;

public class Dp25SerialImpl
extends ProtocolThread {
    private SerialPort serialPort;
    protected String portName;
    protected static String driverName = "Dp25SerialImpl";
    protected PersistentList feedbackList;
    protected int speed = 38400;
    protected UserNotifiyInterface userNotifiyInterface;
    protected EcrSerialNumberReadInterface serialNumberInterface;

    public void setUserNotifiyInterface(UserNotifiyInterface userNotifiyInterface) {
        this.userNotifiyInterface = userNotifiyInterface;
    }

    private void addFeedback(String orderKey, int nrBon, boolean lastBon) {
        System.out.println("primit " + nrBon + " for orderkey : " + orderKey);
        Bon bon = new Bon(orderKey, nrBon + "");
        this.feedbackList.addBon(bon);
        this.userNotifiyInterface.bonFinished(nrBon, -1, -1, orderKey, 1, lastBon);
    }

    public Dp25SerialImpl(String portName, Integer speed, UserNotifiyInterface userNotifiyInterface1) {
        this.userNotifiyInterface = userNotifiyInterface1;
        this.portName = portName;
        if (speed != null) {
            this.speed = speed;
        }
        this.bonsQueue = new QueBoonAbstract("_datecs_gen3_persistent_product_list");
        this.feedbackList = new PersistentList("_datecs_gen3_persistent_feedback_list");
        this.logerInterface = new LogerInterface(){

            @Override
            public void translateGetDateRaspuns(ReadingDateResponse dateResponse) {
                try {
                    Date d = ProtocolThread.ecrDateFormat.parse(dateResponse.getDate() + " " + dateResponse.getHour());
                    EcrLogic.getInstance().setDate(d);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void addLog(String data) {
                Logger.logDebug(this, data);
            }

            @Override
            public String getInitialLogPath() {
                return null;
            }

            @Override
            public void addLogAndNotifyUser(String string) {
                Logger.logDebug(this, string);
                Dp25SerialImpl.this.userNotifiyInterface.showTextToUserAndWait(string);
            }

            @Override
            public boolean addLogAndASKUser(String string) {
                Logger.logDebug(this, string);
                return Dp25SerialImpl.this.userNotifiyInterface.askTextToUserAndWait(string);
            }

            @Override
            public void translateRaportRaspuns(Raport raport) {
            }

            @Override
            public void translateInfoCurentReceipt(InfoCurentReceipt infoCurentReceipt) {
            }

            @Override
            public void translateLastDocumentPrint(LastDocumentPrinted lastDocumentPrinted, String orderKey, boolean lastBon) {
                Dp25SerialImpl.this.addFeedback(orderKey, lastDocumentPrinted.getLastDocNumber(), lastBon);
            }

            @Override
            public void translateTaxRegistrationNumber(TaxRegistrationNumber taxRegistrationNumber) {
            }

            @Override
            public void translateDiagnostic(DiagnosticResponse diagnosticResponse) {
            }

            @Override
            public void translateCloseNonFiscalReceipt(CloseNonFiscalReceiptResponse closeNonFiscalReceiptResponse) {
            }

            @Override
            public void translateDebitingCrediting(DebetingCrediting debetingCrediting) {
            }

            @Override
            public void translateOpenNonFiscalReceipt(OpenNonFiscalReceiptResponse openNonFiscalReceiptResponse) {
            }

            @Override
            public void translateItemReport(ItemReportResponse itemReportResponse) {
            }

            @Override
            public void translateTaxRateDruingPeriod(TaxRatesDruingPeriodResponse taxRatesDruingPeriodResponse) {
            }

            @Override
            public void translateClosingFiscalReceipt(ClosingFiscalReceiptResponse closingFiscalReceiptResponse) {
            }

            @Override
            public void translateOpeningFiscalReceipt(OpeningFiscalReceiptResponse openingFiscalReceiptResponse) {
            }

            @Override
            public void translateSubtotal(SubtotalResponse subtotalResponse) {
            }

            @Override
            public void translateTotal(TotalResponse totalResponse) {
            }

            @Override
            public void connected(boolean status) {
                EcrLogic instance = EcrLogic.getInstance();
                if (instance != null) {
                    instance.ecrConnected(status);
                }
            }
        };
        this.start();
    }

    public void setSerialNumberInterface(EcrSerialNumberReadInterface serialNumberInterface) {
        this.serialNumberInterface = serialNumberInterface;
    }

    @Override
    public boolean restartSocket() {
        block13: {
            try {
                if (this.serialPort != null) {
                    this.serialPort.close();
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                int dataBits = 8;
                int stopBits = 1;
                int parity = 0;
                this.serialPort = null;
                boolean portFound = false;
                CommPortIdentifier portId = null;
                Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    portId = (CommPortIdentifier)portList.nextElement();
                    System.out.println("port : name " + portId.getName() + " owner " + portId.getCurrentOwner() + " portType " + portId.getPortType() + " owned " + portId.isCurrentlyOwned());
                    String shortPortName = this.portName.replace("/dev/", "");
                    String curentElementPortName = portId.getName();
                    if (!curentElementPortName.equalsIgnoreCase(this.portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                    Logger.logDebug(this, "Found port: " + this.portName);
                    portFound = true;
                    break;
                }
                if (!portFound) {
                    try {
                        portId = CommPortIdentifier.getPortIdentifier((String)this.portName);
                    }
                    catch (NoSuchPortException e) {
                        Logger.logException(this, (Exception)((Object)e));
                        DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port incorect : \"" + this.portName + "\"." + " Corectati si reporniti !!", LangRoAll.nuPotContinua);
                        this.mustRun = false;
                        return false;
                    }
                }
                PortSettingsPureJava settings = new PortSettingsPureJava();
                settings.setName(this.portName);
                settings.setSpeed(this.speed);
                settings.setDataBits(dataBits);
                settings.setStopBits(stopBits);
                settings.setPariry(parity);
                this.serialPort = (SerialPort)portId.open(driverName, 2000);
                this.serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
                this.inputStream = this.serialPort.getInputStream();
                this.outputStream = this.serialPort.getOutputStream();
                return true;
            }
            catch (PortInUseException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port ocupat : \"" + this.portName + "\" ." + "<br> Verificati ce aplicatii folosesc portul, SAU incercati mai tarziu, SAU restart", LangRoAll.nuPotContinua);
                if (this.serialPort != null) {
                    this.serialPort.close();
                }
            }
            catch (UnsupportedCommOperationException e) {
                Logger.logException(this, (Exception)((Object)e));
                if (this.serialPort != null) {
                    this.serialPort.close();
                }
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                if (this.serialPort == null) break block13;
                this.serialPort.close();
            }
        }
        return false;
    }

    public String getFeedback(String identifier) {
        Bon b = this.feedbackList.getByIdentifier(identifier);
        if (b != null) {
            return identifier + "|" + b.getCasaZ() + "|" + b.getCasaBon() + "|" + b.getCasaExplain().toString();
        }
        return identifier + "|" + "NOT_FOUND";
    }

    public void clearFeedbackFile() {
        this.feedbackList.clear();
    }

    @Override
    public void licenceDriver(String serialCode) {
        this.serialNumberInterface.licenseBySerieFiscala(serialCode);
    }
}

