/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecsgen3;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLicenseVerifier;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecsgen3.Dp25SerialImpl;
import ro.atreides.ecr.datecsgen3.Dp25TcpImpl;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.deversoft.drivers.datecs.gen3.noarch.Bon;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingDate;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.SeparatorLine;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.ClosingFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.OpenFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.PrintFreeFiscalText;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Sale;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Subtotal;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Total;

public class Generic
extends AbstractCashRegister {
    private Dp25SerialImpl casa;
    protected boolean discountGlobal;
    protected boolean errorNotifications;
    protected boolean discountLaProdus;
    private Vector<String> ecrLicenseCode = new Vector();
    private int ecrId = 0;
    private Vector<String> portFilters = new Vector();
    private String ecrPort = "";
    private int speed = 38400;
    private UserNotifiyInterface userNotifiyInterface;
    protected Vector<EcrFeedbackInterface> feedbackListeners = new Vector();

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.ecrPort = conf.getProperty("ecrPort");
        Enumeration<?> enu = conf.propertyNames();
        while (enu.hasMoreElements()) {
            String nume = (String)enu.nextElement();
            if (!nume.startsWith("datecs.ecr.code.")) continue;
            String value = conf.getProperty(nume);
            this.ecrLicenseCode.add(value);
        }
        String s2 = conf.getProperty("ecrLicenceCode");
        if (Validators.correctString(s2)) {
            this.ecrLicenseCode.add(s2);
        }
        this.ecrLicenseCode.add("917b203efec1c523103f234b21b83e53bc3bed1");
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(conf.getProperty("discountLaProdus", "false"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.ecrId = Integer.parseInt(conf.getProperty("ecrId", "0"));
        this.speed = Integer.parseInt(conf.getProperty("ecrSpeed", "38400"));
        String prop = conf.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        prop = prop.replace("/dev/", "");
        this.portFilters = Utils.splitString(prop, ',');
        if (this.discountLaProdus) {
            this.discountGlobal = false;
        }
        System.out.println("Filters: " + this.portFilters + " ecrId : " + this.ecrId);
        this.setUserNotifiyInterface(new UserNotifiyInterface(){

            @Override
            public void showTextToUserAndWait(String text) {
                if (Generic.this.errorNotifications) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, text, LangRoAll.atentie);
                }
            }

            @Override
            public boolean askTextToUserAndWait(String text) {
                if (Generic.this.errorNotifications) {
                    return DialogUtils.confirmDialog(GuiUtils.currentFrame, text, LangRoAll.confirmare);
                }
                return true;
            }

            @Override
            public void bonFinished(int nrBon, int nrZ, int idOrder, String orderIdentifier, int idCasa, boolean lastBon) {
                for (EcrFeedbackInterface feedbackListener : Generic.this.feedbackListeners) {
                    feedbackListener.bonFinished(idOrder, nrBon, nrZ, idCasa, MP55Impl.CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY, orderIdentifier, lastBon);
                }
            }
        });
    }

    public void setUserNotifiyInterface(UserNotifiyInterface userNotifiyInterface) {
        this.userNotifiyInterface = userNotifiyInterface;
        if (this.casa != null) {
            this.casa.setUserNotifiyInterface(userNotifiyInterface);
        }
    }

    @Override
    public void setEcrSerialNumberReadInterface(EcrSerialNumberReadInterface ecrSerialNumberInterface) {
        this.casa.setSerialNumberInterface(ecrSerialNumberInterface);
    }

    @Override
    public boolean ecrConnectedAtStartup() {
        return false;
    }

    @Override
    public synchronized void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER");
        this.casa.stopRunning();
    }

    @Deprecated
    private Bon createBon(Vector saleVector, Vector paymentVector, Vector textVector, int userCode, Command subtotal, String key) {
        Bon bon = new Bon(key, "Comanda");
        OpenFiscalReceipt openfiscal = new OpenFiscalReceipt(userCode, String.valueOf(userCode), 1, false);
        ReadingDate getDate = new ReadingDate();
        SeparatorLine separatorLine = new SeparatorLine('1');
        ClosingFiscalReceipt closeFiscal = new ClosingFiscalReceipt();
        bon.addCommand(openfiscal);
        bon.addCommand(getDate);
        bon.addCommandVector(saleVector);
        bon.addCommand(separatorLine);
        if (subtotal != null) {
            bon.addCommand(subtotal);
        }
        bon.addCommand(separatorLine);
        bon.addCommandVector(paymentVector);
        bon.addCommandVector(textVector);
        bon.addCommand(closeFiscal);
        return bon;
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER");
        if (this.casa != null) {
            this.casa.stopRunning();
        }
        this.casa = this.ecrPort.startsWith("tcp") ? new Dp25TcpImpl(this.ecrPort, this.userNotifiyInterface) : new Dp25SerialImpl(this.ecrPort, this.speed, this.userNotifiyInterface);
        this.casa.setSerialNumberInterface(new EcrSerialNumberReadInterface(){

            @Override
            public void licenseBySerieFiscala(String serieFiscala) {
                EcrLicenseVerifier.getInstance().setSerieFiscalaCasaAndLicenseOldSchool(serieFiscala, Generic.this.ecrLicenseCode);
            }
        });
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        boolean oprartorCode = true;
        String operatorPassword = "1";
        boolean nrPointOfSale = true;
        boolean printInvoice = false;
        Vector<Sale> saleVector = new Vector<Sale>();
        Vector<Total> paymentVector = new Vector<Total>();
        Vector<PrintFreeFiscalText> commentsVector = new Vector<PrintFreeFiscalText>();
        Iterator iter = sales.iterator();
        double totalFaraReducere = 0.0;
        double totalReducere = 0.0;
        double totalValoare = 0.0;
        while (iter.hasNext()) {
            EcrSale newsaleentry = (EcrSale)iter.next();
            String pNou = newsaleentry.getProduct().toUpperCase();
            String productLine1 = Utils.getStringMaxSize(30, pNou, null, false);
            double quantity = newsaleentry.getQuantity();
            double price = this.discountGlobal || this.discountLaProdus ? newsaleentry.getPpuOriginal() : newsaleentry.getPpuDupaDiscount();
            double discount = this.discountLaProdus ? newsaleentry.getDiscount() : 0.0;
            Character codTva = Character.valueOf(newsaleentry.getCodTva().toUpperCase().charAt(0));
            double discountLaProdus = FloatUtils.roundDoubleUp(-discount * quantity, 2);
            Sale saleLine = new Sale(productLine1, null, codTva.charValue(), price, quantity, discountLaProdus);
            saleVector.add(saleLine);
            double valoareCurentFaraReducere = newsaleentry.getPpuOriginal() * newsaleentry.getQuantity();
            double reducereCurenta = (newsaleentry.getPpuOriginal() - newsaleentry.getPpuDupaDiscount()) * newsaleentry.getQuantity();
            totalFaraReducere += valoareCurentFaraReducere;
            totalReducere += reducereCurenta;
            totalValoare += FloatUtils.roundDoubleUp(price * quantity, 2);
            totalValoare += discountLaProdus;
        }
        if (comments.size() > 0) {
            commentsVector.add(new PrintFreeFiscalText(" "));
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = (String)comments.elementAt(i);
            if (!Validators.correctString(o)) {
                o = " ";
            }
            o = o.toUpperCase();
            List<String> lines = Utils.splitEqually(o, 22);
            for (String line : lines) {
                commentsVector.add(new PrintFreeFiscalText(line));
            }
        }
        if (comments.size() > 0) {
            commentsVector.add(new PrintFreeFiscalText(" "));
        }
        double totalPlatit = 0.0;
        if (plati != null && plati.size() != 0) {
            for (EcrPlata plata : plati) {
                if (plata.isDefault()) continue;
                double platimAcum = plata.getSuma();
                paymentVector.add(new Total(plata.getTipPlata(), null, plata.getEcrMapping().toUpperCase().charAt(0), platimAcum));
                totalPlatit += platimAcum;
            }
        }
        Vector<Command> items = new Vector<Command>();
        items.addAll(saleVector);
        items.addAll(paymentVector);
        items.addAll(commentsVector);
        if (Utils.isValueGreaterThanZero(totalValoare - totalPlatit)) {
            Logger.logWarning(this, "FORCING TOTAL : TotalValoare = " + totalValoare + " totalPlatit = " + totalPlatit);
            Total totalCommand = new Total(null, null, 'P', null);
            items.add(totalCommand);
        }
        this.casa.addBon(items, orderIdentifier);
    }

    @Override
    public void printX() {
        this.casa.printAuxiliaryBon(this.casa.prepareRaportX());
    }

    @Override
    public void printZ() {
        this.casa.printAuxiliaryBon(this.casa.prepareRaportZ());
    }

    @Override
    public void introduNumerar(double suma) {
        this.casa.printAuxiliaryBon(this.casa.prepareDebitingCrediting(suma));
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public int getNoOfBonsToPrint() {
        return this.casa.getUnprintedBons();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.stopECR();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Logger.logException(this, (Exception)e);
            }
            this.startECR();
        }
    }

    @Override
    public void deleteBonByIdentifier(String identifier) {
    }

    @Override
    public void clearFeedbackFile() {
        this.casa.clearFeedbackFile();
    }

    @Override
    public String getFeedbackByIdentifier(String identifier) {
        return this.casa.getFeedback(identifier);
    }

    private void parseNativeFile(String fileContent, Vector<Command> items, Vector<Bon> auxiliaryBons) {
        String text1 = fileContent.replaceAll("\\r\\n|\\r|\\n", "&&&");
        text1 = fileContent.replaceAll("&&&", "\n");
        int startOfData = 16;
        Sale lastSale = null;
        boolean stl = false;
        boolean lastCommandIsSale = false;
        boolean totalStarted = false;
        Vector lines = Utils.splitString(text1, '\n');
        for (String line : lines) {
            Vector tokens;
            String payload;
            if (line.startsWith("P")) {
                payload = line.substring(startOfData);
                tokens = Utils.splitString(payload, ';');
                String text = (String)tokens.get(0);
                boolean acceptCommand = false;
                if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.printCodFiscalEnabled)) {
                    acceptCommand = true;
                } else if (lastCommandIsSale) {
                    Vector textTokens = Utils.splitString(text, ' ');
                    for (String textToken : textTokens) {
                        String numeric = textToken.replaceAll("[^\\d.]", "");
                        if (numeric.length() <= 5) continue;
                        acceptCommand = false;
                        break;
                    }
                } else {
                    acceptCommand = false;
                }
                if (acceptCommand) {
                    items.add(new PrintFreeFiscalText(text));
                }
                lastCommandIsSale = false;
                continue;
            }
            if (line.startsWith("S")) {
                lastCommandIsSale = true;
                payload = line.substring(startOfData);
                tokens = Utils.splitString(payload, ';');
                Double price = Utils.parseDouble((String)tokens.get(1));
                price = FloatUtils.roundDouble(price, 2);
                Double qty = Utils.parseDouble((String)tokens.get(2));
                qty = FloatUtils.roundDouble(qty, 2);
                Integer tva = Integer.parseInt((String)tokens.get(5));
                String product = (String)tokens.get(0);
                String line1 = null;
                String line2 = null;
                Vector productLines = Utils.splitString(product, '|');
                if (productLines.size() > 0) {
                    line1 = (String)productLines.get(0);
                    if (productLines.size() > 1) {
                        line2 = (String)productLines.get(1);
                    }
                }
                lastSale = new Sale(line1, line2, (char)(65 + tva - 1), price, qty, null, null);
                items.add(lastSale);
                continue;
            }
            if (line.startsWith("C")) {
                lastCommandIsSale = false;
                payload = line.substring(startOfData);
                tokens = Utils.splitString(payload, ';');
                Double value = FloatUtils.roundDouble(Utils.parseDouble((String)tokens.get(1)), 2);
                String type = (String)tokens.get(0);
                if (type.equals("1")) {
                    value = -value.doubleValue();
                }
                if (!stl) {
                    if (lastSale == null) continue;
                    lastSale.setReducerePercent(value);
                    continue;
                }
                Subtotal subtotal1 = new Subtotal(true, true, value, 0);
                items.add(subtotal1);
                continue;
            }
            if (line.startsWith("T")) {
                String sumaS;
                String nextBonCui;
                lastCommandIsSale = false;
                if (!totalStarted && Validators.correctString(nextBonCui = EcrLogic.getInstance().getNextBonCUI())) {
                    items.add(new PrintFreeFiscalText(nextBonCui));
                    EcrLogic.getInstance().setNextBonCUI(null);
                }
                totalStarted = true;
                payload = line.substring(startOfData);
                tokens = Utils.splitStringKeepStructure(payload, ';', '_');
                if (tokens.size() <= 0) continue;
                Integer type = Integer.parseInt((String)tokens.get(0));
                boolean subtotalNow = false;
                char c = 'P';
                switch (type) {
                    case 1: {
                        c = 'N';
                        break;
                    }
                    case 2: {
                        c = 'C';
                        break;
                    }
                    case 3: {
                        c = 'D';
                        break;
                    }
                    case 4: {
                        subtotalNow = true;
                        stl = true;
                        break;
                    }
                    case 5: {
                        c = 'I';
                        break;
                    }
                    case 6: {
                        c = 'J';
                        break;
                    }
                    case 8: {
                        Bon duplicat = this.casa.prepareDuplicat();
                        auxiliaryBons.add(duplicat);
                        return;
                    }
                }
                if (subtotalNow) continue;
                Double suma = null;
                if (tokens.size() > 1 && !(sumaS = (String)tokens.get(1)).contains("_") && Validators.correctDouble(sumaS)) {
                    double toRound = Utils.parseDouble(sumaS);
                    suma = FloatUtils.roundDoubleUp(toRound, 2);
                }
                Total t = new Total(null, null, c, suma);
                items.add(t);
                continue;
            }
            if (line.startsWith("I")) {
                lastCommandIsSale = false;
                payload = line.substring(startOfData);
                tokens = Utils.splitStringKeepStructure(payload, ';', '_');
                if (tokens.size() < 2) continue;
                String t1 = (String)tokens.get(0);
                String t2 = (String)tokens.get(1);
                if (!Validators.correctInteger(t1) || !Validators.correctDouble(t2)) continue;
                Double amount = Utils.parseDouble(t2);
                Integer type = Integer.parseInt(t1);
                if (type == 1) {
                    amount = -amount.doubleValue();
                }
                Bon creditDebit = this.casa.prepareDebitingCrediting(amount);
                auxiliaryBons.add(creditDebit);
                continue;
            }
            if (line.startsWith("X")) {
                lastCommandIsSale = false;
                Bon x = this.casa.prepareRaportX();
                auxiliaryBons.add(x);
                continue;
            }
            if (line.startsWith("Z")) {
                lastCommandIsSale = false;
                Bon z = this.casa.prepareRaportZ();
                auxiliaryBons.add(z);
                continue;
            }
            if (!line.startsWith("D")) continue;
            lastCommandIsSale = false;
            Bon duplicat = this.casa.prepareDuplicat();
            auxiliaryBons.add(duplicat);
        }
    }

    @Override
    public void processBonFiscal(String items, String bonId, int idOrder, EcrType ecrType, String serieFiscala, BonValidatorResponseInterface responseInterface) {
        if (!EcrLogic.getInstance().checkBonLimitForTodayAndIncreaseUsage()) {
            return;
        }
        System.out.println("Received bonId \"" + bonId + "\" items \"" + items + "\" ecrType : " + (Object)((Object)ecrType) + " serieFiscala : " + serieFiscala);
        boolean bonHasErrors = false;
        if (ecrType != null && serieFiscala != null && responseInterface != null) {
            BonValidator bv = new BonValidator();
            boolean canCorrect = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.correctBonEnabled);
            Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> generalErrors = new Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>();
            Map<Integer, Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>> errors = bv.checkForErrors(items, ecrType, null, canCorrect, 2, 3, generalErrors);
            System.out.println(errors);
            responseInterface.processErrors(errors, items, serieFiscala, bonId, generalErrors);
            for (Integer n : errors.keySet()) {
                if (bonHasErrors) break;
                Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> errorsForLine = errors.get(n);
                for (Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE> map : errorsForLine) {
                    for (BonValidator.ERROR_FUNCTION function : map.keySet()) {
                        switch (function) {
                            case ERROR: {
                                bonHasErrors = true;
                            }
                        }
                    }
                }
            }
            for (Map map : generalErrors) {
                for (BonValidator.ERROR_FUNCTION function : map.keySet()) {
                    switch (function) {
                        case ERROR: {
                            bonHasErrors = true;
                        }
                    }
                }
            }
        }
        if (bonHasErrors && this.isPrevalidareBonuriEnabled()) {
            return;
        }
        if (this.casa != null) {
            Vector<Command> commands = new Vector<Command>();
            Vector<Bon> auxiliarBons = new Vector<Bon>();
            this.parseNativeFile(items, commands, auxiliarBons);
            if (commands.size() > 0) {
                this.casa.addBon(commands, bonId);
            }
            for (Bon auxiliarBon : auxiliarBons) {
                this.casa.printAuxiliaryBon(auxiliarBon);
            }
        }
    }

    @Override
    public void addLicenseCode(String licenseCode) {
        this.ecrLicenseCode.add(licenseCode);
    }

    @Override
    public void addListener(EcrFeedbackInterface listener) {
        this.feedbackListeners.add(listener);
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void copieBon() {
        this.casa.printAuxiliaryBon(this.casa.prepareDuplicat());
    }
}

