/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.incotex;

import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.incotex.IncotexImpl;
import ro.atreides.ecr.incotex.noarch.Bon;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageAllVoid;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageCloseFiscalReceipt;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageComment;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageDrawerCashEntry;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageOpenFiscalReceipt;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessagePayment;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageSaleProduct;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageXReport;
import ro.atreides.ecr.incotex.noarch.messages.IncotexMessageZReport;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    IncotexImpl driver;
    private boolean discountGlobal;
    private boolean errorNotifications;
    private boolean discountLaProdus;
    private String port;

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(conf.getProperty("discountLaProdus", "false"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.port = conf.getProperty("ecrPort", "/dev/ttyS0");
        this.port = this.port.replace("/dev/", "");
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        Bon b = new Bon();
        b.addSale(new IncotexMessageAllVoid());
        IncotexMessageOpenFiscalReceipt openFiscalReceipt = new IncotexMessageOpenFiscalReceipt();
        b.addSale(openFiscalReceipt);
        double totalOriginal = 0.0;
        double totalDiscount = 0.0;
        for (Object o : sales) {
            EcrSale sale = (EcrSale)o;
            double price = sale.getPpuOriginal();
            double discount = (sale.getPpuDupaDiscount() - sale.getPpuOriginal()) * sale.getQuantity();
            IncotexMessageSaleProduct produs = new IncotexMessageSaleProduct(price, sale.getQuantity(), sale.getProduct(), sale.getCodTva().charAt(0), discount);
            b.addSale(produs);
            totalDiscount += sale.getDiscount() * sale.getQuantity();
            totalOriginal += sale.getPpuOriginal() * sale.getQuantity();
        }
        double totalPlatit = 0.0;
        for (Object o : plati) {
            EcrPlata plata = (EcrPlata)o;
            IncotexMessagePayment payment = new IncotexMessagePayment(plata.getEcrMapping(), plata.getSuma());
            b.addSale(payment);
            totalPlatit += plata.getSuma();
        }
        if (totalPlatit < total) {
            IncotexMessagePayment payment = new IncotexMessagePayment(cashDefault.getEcrMapping(), total - totalPlatit);
            b.addSale(payment);
        }
        for (Object comment : comments) {
            String s = (String)comment;
            b.addSale(new IncotexMessageComment(s));
        }
        IncotexMessageCloseFiscalReceipt closeFiscalReceipt = new IncotexMessageCloseFiscalReceipt();
        b.addSale(closeFiscalReceipt);
        this.driver.addBon(b);
    }

    @Override
    public void printX() {
        Bon b = new Bon();
        b.addSale(new IncotexMessageXReport());
        this.driver.addBon(b);
    }

    @Override
    public void printZ() {
        Bon b = new Bon();
        b.addSale(new IncotexMessageZReport());
        this.driver.addBon(b);
    }

    @Override
    public void introduNumerar(double suma) {
        Bon b = new Bon();
        if (suma == 0.0) {
            return;
        }
        b.addSale(new IncotexMessageDrawerCashEntry(suma));
        this.driver.addBon(b);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void startECR() {
        this.driver = new IncotexImpl(this.port);
        this.driver.setName("IncotexImpl");
        this.driver.start();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.driver.deleteNonPrintedBons(this.inter);
        }
    }

    @Override
    public int getNoOfBonsToPrint() {
        if (this.driver != null) {
            return this.driver.getNoOfBonsToPrint();
        }
        return 0;
    }

    @Override
    public void forceTotal() {
    }
}

