/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.incotex;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.incotex.noarch.IncotexNoarchImpl;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tricky.NonPrintedBonInterface;

public class IncotexImpl
extends IncotexNoarchImpl {
    private String portName;

    public IncotexImpl(String port) {
        this.portName = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            int speed = 9600;
            int dataBits = 8;
            int stopBits = 1;
            int parity = 0;
            String driverName = "incotex";
            SerialPort serialPort = null;
            if (Validators.correctString(this.portName)) {
                while (true) {
                    boolean portFound = false;
                    CommPortIdentifier portId = null;
                    String message = "initializing port: " + this.portName;
                    try {
                        if (this.portName.startsWith("tcp")) {
                            Vector items = Utils.splitString(this.portName, '=');
                            if (items.size() < 3 || !Validators.correctString((String)items.get(1)) || !Validators.correctInteger((String)items.get(2))) {
                                Logger.logError((Object)this, "Configurare incorecta . Eroare fatala!!");
                                Utils.systemExit();
                            }
                            String ip = (String)items.get(1);
                            int port = Integer.parseInt((String)items.get(2));
                            Socket s = new Socket();
                            InetSocketAddress sa = new InetSocketAddress(ip, port);
                            s.connect(sa);
                            this.inS = s.getInputStream();
                            this.outS = s.getOutputStream();
                        } else {
                            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
                            while (portList.hasMoreElements()) {
                                portId = (CommPortIdentifier)portList.nextElement();
                                String shortPortName = this.portName.replace("/dev/", "");
                                String curentElementPortName = portId.getName();
                                if (!curentElementPortName.equalsIgnoreCase(this.portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                                message = "Found port: " + this.portName;
                                portFound = true;
                                break;
                            }
                            if (!portFound) {
                                message = "Port incorect: " + this.portName;
                                DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port incorect : \"" + this.portName + "\"." + " Corectati si reporniti !!", LangRoAll.nuPotContinua);
                                break block20;
                            }
                            PortSettingsPureJava settings = new PortSettingsPureJava();
                            settings.setName(this.portName);
                            settings.setSpeed(speed);
                            settings.setDataBits(dataBits);
                            settings.setStopBits(stopBits);
                            settings.setPariry(parity);
                            message = ">>>>> Opening port: " + this.portName + "";
                            serialPort = (SerialPort)portId.open(driverName, 2000);
                            this.inS = serialPort.getInputStream();
                            this.outS = serialPort.getOutputStream();
                            serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
                            message = "Setari port serial DUPA setParams : baudRate=" + serialPort.getBaudRate() + " dataBits=" + serialPort.getDataBits() + " stopBits=" + serialPort.getStopBits() + " parity=" + serialPort.getParity();
                        }
                        this.startWork();
                    }
                    catch (PortInUseException e) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port ocupat : \"" + this.portName + "\"", LangRoAll.nuPotContinua);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (Throwable th) {
                    }
                    finally {
                        if (serialPort != null) {
                            serialPort.close();
                        }
                        message = "Am inchis portul: " + this.portName;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            DialogUtils.errorDialog(GuiUtils.currentFrame, driverName + ": port nedefinit. Corectati si reporniti !!", LangRoAll.nuPotContinua);
        }
    }

    public void deleteNonPrintedBons(NonPrintedBonInterface inter) {
        this.outQueue.clear();
    }
}

