/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.mercury.MercuryXmlHandler;
import ro.atreides.ecr.mercury.nativeImpl.Mercury130FImpl;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryFiscalReceiptImpl;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryReport;
import ro.atreides.ecr.mercury.nativeImpl.bons.ReportType;
import ro.atreides.ecr.mercury.nativeImpl.requests.FiscalSale;
import ro.atreides.ecr.mercury.nativeImpl.requests.Payment;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private boolean forceTotal;
    private boolean discountGlobal;
    private boolean forceTotalAt2Decimals;
    private boolean errorNotifications;
    private boolean verifyEachItem;
    private String ecrLicenseCode;
    private Mercury130FImpl driver;
    private Vector filters = new Vector();

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.forceTotal = Boolean.parseBoolean(conf.getProperty("forceTotal", "false"));
        this.forceTotalAt2Decimals = Boolean.parseBoolean(conf.getProperty("forceTotalAt2Decimals", "false"));
        this.ecrLicenseCode = conf.getProperty("ecrLicenceCode", "772274515e9e02e8f1aaf17f7b3aac5c56cd85");
        this.discountGlobal = Boolean.parseBoolean(conf.getProperty("discountGlobal", "false"));
        this.errorNotifications = Boolean.parseBoolean(conf.getProperty("errorNotifications", "true"));
        this.verifyEachItem = Boolean.parseBoolean(conf.getProperty("verifyEachItem", "true"));
        String prop = conf.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        prop = prop.replace("/dev/", "");
        this.filters = Utils.splitString(prop, ',');
    }

    @Override
    public synchronized void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER: " + this.driver);
        if (this.driver != null) {
            this.driver.stop();
        }
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER: " + this.driver);
        this.stopECR();
        this.driver = new Mercury130FImpl(this.filters);
        this.driver.setLicense(this.ecrLicenseCode);
        this.driver.setLicenseRequired(false);
        this.driver.setVerifyEachItem(this.verifyEachItem);
        this.driver.setNotifications(this.errorNotifications);
        this.driver.start();
    }

    @Override
    public void processXml(String fileName) {
        try {
            MercuryXmlHandler xmlHandler = new MercuryXmlHandler();
            Utils.importXml((DefaultHandler)xmlHandler, fileName);
            this.processBon(xmlHandler.getReceipt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void processBon(EcrReceipt bon) {
        if (this.driver != null) {
            this.driver.addEcrReceipt(bon);
        }
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        MercuryFiscalReceiptImpl receipt = new MercuryFiscalReceiptImpl(idOrder);
        Iterator iter = sales.iterator();
        boolean aDouaZecimala = false;
        double totalFaraReducere = 0.0;
        double totalReducere = 0.0;
        while (iter.hasNext()) {
            EcrSale newsaleentry = (EcrSale)iter.next();
            String nume = newsaleentry.getProduct();
            double quantity = newsaleentry.getQuantity();
            double price = this.discountGlobal ? newsaleentry.getPpuOriginal() : newsaleentry.getPpuDupaDiscount();
            String codTva = newsaleentry.getCodTva();
            FiscalSale.TaxGroup tvaGroup = null;
            for (FiscalSale.TaxGroup tg : FiscalSale.TaxGroup.values()) {
                String s1 = (char)tg.getId() + "";
                if (!s1.equals(codTva)) continue;
                tvaGroup = tg;
                break;
            }
            if (tvaGroup == null) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "GRUPA TVA DEFINITA INCORECT.", "Bon ignorat");
                return;
            }
            totalFaraReducere += newsaleentry.getPpuOriginal() * newsaleentry.getQuantity();
            totalReducere += (newsaleentry.getPpuOriginal() - newsaleentry.getPpuDupaDiscount()) * newsaleentry.getQuantity();
            receipt.addSale(new FiscalSale(nume, price, quantity, tvaGroup));
        }
        for (int i = 0; i < comments.size(); ++i) {
            String comment = (String)comments.elementAt(i);
            receipt.addComment(comment);
        }
        if (this.discountGlobal && totalReducere != 0.0) {
            double procent = totalReducere * 100.0 / totalFaraReducere;
            System.out.println("subtotal procent = " + procent);
            receipt.addSubtotal(procent);
        }
        for (EcrPlata plata : plati) {
            double suma = plata.getSuma();
            String tip = plata.getEcrMapping();
            Payment.PAYMENT_TYPE type = Payment.PAYMENT_TYPE.valueOf(tip);
            receipt.addPayment(new Payment(suma, type));
        }
        this.processBon(receipt);
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
        this.processBon(new MercuryReport(ReportType.DAILY_Z));
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.driver.deleteNonPrintedBons(this.inter);
            Utils.systemExit();
        }
    }
}

