/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury;

import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryFiscalReceiptImpl;
import ro.atreides.ecr.mercury.nativeImpl.requests.FiscalSale;
import ro.atreides.ecr.mercury.nativeImpl.requests.Payment;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class MercuryXmlHandler
extends DefaultHandler {
    private MercuryFiscalReceiptImpl receipt = new MercuryFiscalReceiptImpl(-1);
    private Vector items = new Vector();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("product")) {
            String name = attributes.getValue("label");
            double price = Utils.parseDouble(attributes.getValue("price"));
            double quantity = Utils.parseDouble(attributes.getValue("quantity"));
            String tva = attributes.getValue("vat");
            FiscalSale.TaxGroup tvaGroup = FiscalSale.TaxGroup.A;
            if (tva.equalsIgnoreCase("1")) {
                tvaGroup = FiscalSale.TaxGroup.A;
            } else if (tva.equalsIgnoreCase("2")) {
                tvaGroup = FiscalSale.TaxGroup.B;
            } else if (tva.equalsIgnoreCase("3")) {
                tvaGroup = FiscalSale.TaxGroup.C;
            } else if (tva.equalsIgnoreCase("4")) {
                tvaGroup = FiscalSale.TaxGroup.D;
            } else if (tva.equalsIgnoreCase("5")) {
                tvaGroup = FiscalSale.TaxGroup.E;
            } else if (tva.equalsIgnoreCase("5")) {
                tvaGroup = FiscalSale.TaxGroup.G;
            } else if (tva.equalsIgnoreCase("5")) {
                tvaGroup = FiscalSale.TaxGroup.NON_TAXABLE;
            }
            FiscalSale sale = new FiscalSale(name, price, quantity, tvaGroup);
            this.receipt.addSale(sale);
            this.items.add(sale);
        } else if (qName.equalsIgnoreCase("payment")) {
            double amount = Utils.parseDouble(attributes.getValue("amount"));
            String type = attributes.getValue("type");
            Payment.PAYMENT_TYPE payment_type = null;
            if (type.equalsIgnoreCase("card")) {
                payment_type = Payment.PAYMENT_TYPE.CC;
            }
            if (type.equalsIgnoreCase("ticket")) {
                payment_type = Payment.PAYMENT_TYPE.COUPON;
            }
            if (type.equalsIgnoreCase("cash")) {
                payment_type = Payment.PAYMENT_TYPE.CASH;
            }
            Payment payment = new Payment(amount, payment_type);
            this.receipt.addPayment(payment);
        } else if (qName.equalsIgnoreCase("ad")) {
            String text = attributes.getValue("text");
            if (!Validators.correctString(text)) {
                text = " ";
            }
            this.receipt.addComment(text);
        } else if (qName.equalsIgnoreCase("discount")) {
            double percent = Utils.parseDouble(attributes.getValue("percent"));
            this.items.add(-percent);
        } else if (qName.equalsIgnoreCase("adaos")) {
            double percent = Utils.parseDouble(attributes.getValue("percent"));
            this.items.add(percent);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("receipt")) {
            for (int i = 0; i < this.items.size(); ++i) {
                Object o = this.items.get(i);
                if (!(o instanceof Double)) continue;
                Object precedent = this.items.get(i - 1);
                if (i + 1 >= this.items.size()) {
                    this.receipt.addSubtotal((Double)o);
                    continue;
                }
                if (!(precedent instanceof FiscalSale)) continue;
                FiscalSale sale = (FiscalSale)precedent;
                sale.setPercent((Double)o);
            }
        }
    }

    public MercuryFiscalReceiptImpl getReceipt() {
        return this.receipt;
    }
}

