/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import ro.atreides.ecr.EcrLogger;
import ro.atreides.ecr.mercury.nativeImpl.MercuryUtils;

public class MercuryLogger
extends EcrLogger {
    private StringBuilder buffer = new StringBuilder();
    private String idReceipt = "0";
    private String id;
    private boolean logVerbose = false;
    private SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSSS");

    public MercuryLogger(String id) {
        this.id = id;
    }

    @Override
    public void log(String s) {
        String log = "\r\n" + s + "\t\t" + this.formatter.format(new Date());
        this.buffer.append(log);
        if (this.logVerbose) {
            System.out.print(log);
        }
    }

    @Override
    public void clearLogs() {
        this.buffer.delete(0, this.buffer.length());
    }

    public void setIdReceipt(String id) {
        if (id != null) {
            this.idReceipt = id;
        }
    }

    public void saveLogs(Date date) {
        String log = this.buffer.toString();
        this.clearLogs();
        MercuryUtils.saveLog(this.id + File.separator + "logs", this.idReceipt + "", date, log);
    }
}

