/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.util.EnumSet;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.MercuryUtils;
import ro.atreides.ecr.mercury.nativeImpl.Message;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.ecr.mercury.nativeImpl.Status;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseCloseFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseDateAndTimeOfTheEcr;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseFiscalReceiptStatus;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseOpenFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseOpenNonFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponsePayment;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseSaleRegistration;

public class Response
extends Message {
    private static final Response SYN_MESSAGE = new Response(CMD_ENUM.NOT_USED, TYPE.SYN, null){

        @Override
        public String toString() {
            return "SYN";
        }
    };
    private static final Response NAK_MESSAGE = new Response(CMD_ENUM.NOT_USED, TYPE.NAK, null){

        @Override
        public String toString() {
            return "NAK";
        }
    };
    private TYPE type;
    private EnumSet<Status> status;
    private byte[] messageData;

    public Response(CMD_ENUM cmd, TYPE type, byte[] messageData) {
        super(cmd);
        this.messageData = messageData;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
        this.status = MercuryUtils.parseStatus(messageData);
        if (type == TYPE.PACKED) {
            this.setSeq(messageData[0]);
        }
    }

    public Response(CMD_ENUM cmd, byte[] messageData) {
        this(cmd, TYPE.PACKED, messageData);
    }

    public byte[] getDataBlock() {
        int startIndex = 2;
        int endIndex = this.messageData.length - 7;
        byte[] data = new byte[endIndex - startIndex];
        System.arraycopy(this.messageData, startIndex, data, 0, data.length);
        return data;
    }

    @Override
    protected final byte[] buildDataBytes() {
        return null;
    }

    @Override
    public final byte[] buildRawMessage() {
        return null;
    }

    public TYPE getType() {
        return this.type;
    }

    public static Response buildSyn() {
        return SYN_MESSAGE;
    }

    public static Response buildNak() {
        return NAK_MESSAGE;
    }

    public static Response buildPacked(byte[] data) {
        if (data == null) {
            return new Response(CMD_ENUM.NOT_USED, TYPE.PACKED, data);
        }
        byte cmdId = data[1];
        switch (cmdId) {
            case 76: {
                return new ResponseFiscalReceiptStatus(data);
            }
            case 48: {
                return new ResponseOpenFiscalReceipt(data);
            }
            case 38: {
                return new ResponseOpenNonFiscalReceipt(data);
            }
            case 62: {
                return new ResponseDateAndTimeOfTheEcr(data);
            }
            case 56: {
                return new ResponseCloseFiscalReceipt(data);
            }
            case 53: {
                return new ResponsePayment(data);
            }
            case 49: {
                return new ResponseSaleRegistration(data);
            }
        }
        return new Response(CMD_ENUM.cmdForId(cmdId), TYPE.PACKED, data);
    }

    public boolean isSyn() {
        return this.type == TYPE.SYN;
    }

    public boolean isNak() {
        return this.type == TYPE.NAK;
    }

    public boolean isPacked() {
        return this.type == TYPE.PACKED;
    }

    public boolean isResponseToRequest(Request request) {
        boolean result = false;
        if (request != null && this.isPacked()) {
            result = request.getCMD() == this.getCMD() && request.getSEQ() == request.getSEQ();
        }
        return result;
    }

    public EnumSet<Status> getStatus() {
        return this.status;
    }

    public String toString() {
        return "\n\tResponse {\n\t\ttype=" + (Object)((Object)this.type) + "\n\t\tstatus=" + this.status + "\n\t}";
    }

    public static enum TYPE {
        NAK,
        SYN,
        PACKED;

    }
}

