/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.requests;

import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Request;

public final class OpenFiscalReceipt
extends Request {
    public static final int DEFAULT_OPERATOR = 1;
    public static final int DEFAULT_PASSWORD = 0;
    private int opNumber;
    private int password;
    private final int tillNumber = 1;

    public OpenFiscalReceipt(int opNumber, int password) {
        super(CMD_ENUM.OPENING_A_FISCAL_RECEIPT);
        this.opNumber = opNumber < 1 || opNumber > 8 ? 1 : opNumber;
        this.password = password < 0 || password > 999999 ? 0 : password;
    }

    public OpenFiscalReceipt(int opNumber) {
        this(opNumber, 0);
    }

    public OpenFiscalReceipt() {
        this(1, 0);
    }

    @Override
    protected byte[] buildDataBytes() {
        String opNumber = Integer.toString(this.opNumber);
        String password = Integer.toString(this.password);
        String tillNumber = Integer.toString(this.tillNumber);
        int length = opNumber.length() + 1 + password.length() + 1 + 1;
        byte[] result = new byte[length];
        int i = -1;
        BinaryUtils.copyAsciiBytes(opNumber, 0, result, ++i, opNumber.length());
        result[++i] = 44;
        BinaryUtils.copyAsciiBytes(password, 0, result, ++i, password.length());
        result[++i] = 44;
        BinaryUtils.copyAsciiBytes(tillNumber, 0, result, ++i, tillNumber.length());
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

