/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.requests;

import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.utils.Utils;

public final class Payment
extends Request {
    private String comment;
    private PAYMENT_TYPE paymentType;
    private String amount;
    private double amountFloat;

    public Payment() {
        this(Double.MAX_VALUE);
    }

    public Payment(double amount) {
        this(amount, null);
    }

    public Payment(double amount, PAYMENT_TYPE paymentType) {
        this(amount, paymentType, null);
    }

    public Payment(double amount, PAYMENT_TYPE paymentType, String comment) {
        super(CMD_ENUM.PAYMENT);
        this.comment = comment == null ? "" : (comment.length() > 28 ? comment.substring(0, comment.length()) : comment);
        this.paymentType = paymentType == null ? PAYMENT_TYPE.CASH : paymentType;
        this.setAmount(amount);
    }

    public void setAmount(double amount) {
        this.amountFloat = amount = amount < 0.0 ? 0.0 : amount;
        this.amount = Utils.getString2DecimalsNoTrunc(amount);
    }

    @Override
    protected byte[] buildDataBytes() {
        int length = (this.comment.length() == 0 ? 0 : this.comment.length() + 1) + 1 + (this.amountFloat == Double.MAX_VALUE ? 0 : 1 + this.amount.length());
        byte[] result = new byte[length];
        int i = -1;
        if (this.comment.length() > 0) {
            result[++i] = 10;
            BinaryUtils.copyAsciiBytes(this.comment, 0, result, ++i, this.comment.length());
            i += this.comment.length() - 1;
        }
        result[++i] = 9;
        if (this.amountFloat != Double.MAX_VALUE) {
            result[++i] = this.paymentType.getId();
            BinaryUtils.copyAsciiBytes(this.amount, 0, result, ++i, this.amount.length());
        }
        return result;
    }

    public double getAmount() {
        return this.amountFloat;
    }

    public String toString() {
        return "\n\t\tPayment { paymentType=" + (Object)((Object)this.paymentType) + ", amount='" + (this.amountFloat == Double.MAX_VALUE ? "ALL" : this.amount) + '\'' + ", comment='" + this.comment + '\'' + " }";
    }

    public static enum PAYMENT_TYPE {
        CASH('P'),
        CC('N'),
        CHECK('C'),
        CARD('D'),
        COUPON('B');

        private byte id;

        private PAYMENT_TYPE(char id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }
    }
}

