/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.requests;

import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.utils.Utils;

public final class Subtotal
extends Request {
    private double percent = 0.0;

    public Subtotal(double percent) {
        super(CMD_ENUM.SUBTOTAL);
        this.percent = percent == 0.0 ? 0.0 : (percent > 0.0 ? Math.min(percent, (double)99.99f) : Math.max(percent, (double)-99.99f));
    }

    @Override
    protected byte[] buildDataBytes() {
        String percent = Utils.getString2DecimalsNoTrunc(this.percent);
        int length = 3 + percent.length();
        byte[] result = new byte[length];
        int i = -1;
        result[++i] = 48;
        result[++i] = 48;
        result[++i] = 44;
        BinaryUtils.copyAsciiBytes(percent, 0, result, ++i, percent.length());
        return result;
    }
}

