/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.responses;

import java.util.StringTokenizer;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Response;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public final class ResponseFiscalReceiptStatus
extends Response {
    private boolean isReceiptOpened;
    private int numberOfItems;
    private double total;
    private double paid;

    public ResponseFiscalReceiptStatus(byte[] data) {
        super(CMD_ENUM.FISCAL_RECEIPT_STATUS, Response.TYPE.PACKED, data);
        String paid;
        String total;
        StringTokenizer tokenizer = new StringTokenizer(new String(this.getDataBlock()), ",");
        if (tokenizer.hasMoreTokens()) {
            String open = tokenizer.nextToken();
            boolean bl = this.isReceiptOpened = !open.equals("0");
        }
        if (tokenizer.hasMoreTokens()) {
            String items = tokenizer.nextToken();
            this.numberOfItems = Integer.parseInt(items);
        }
        if (tokenizer.hasMoreTokens() && Validators.correctDouble(total = tokenizer.nextToken())) {
            this.total = Utils.parseDouble(total);
        }
        if (tokenizer.hasMoreTokens() && Validators.correctDouble(paid = tokenizer.nextToken())) {
            this.paid = Utils.parseDouble(paid);
        }
    }

    public boolean isReceiptOpened() {
        return this.isReceiptOpened;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    public double getTotal() {
        return this.total;
    }

    public double getPaid() {
        return this.paid;
    }

    @Override
    public String toString() {
        return "\n\tResponseFiscalReceiptStatus {\n\t\tisReceiptOpened=" + this.isReceiptOpened + "\n\t\tnumberOfItems=" + this.numberOfItems + "\n\t\ttotal=" + this.total + "\n\t\tpaid=" + this.paid + "\n\t\tstatus = " + this.getStatus() + "\n\t}";
    }
}

