/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optima;

import java.io.File;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Generic
extends AbstractCashRegister {
    private String tvaDefault = "1";
    private int nonFiscalIndex = 1;
    private String onlineNfDestinationMask;

    @Override
    public void printZ() {
        String items = "15";
        this.pt.addToQueue(items);
    }

    @Override
    public void printX() {
    }

    @Override
    public void introduNumerar(double suma) {
    }

    @Override
    public boolean numerarInputReady() {
        return false;
    }

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.onlineNfDestinationMask = conf.getProperty("nonfiscalReceiptDestinationMask", this.onlineDirectory + File.separator + "Online_nf_%%nrbon%%.txt");
    }

    @Override
    public void printBonFiscal(Vector<EcrSale> sales, double total, Vector<EcrPlata> plati, TipPlata cashDefault, Vector<String> comments, String orderIdentifier, int idOrder) {
        String items = "";
        long priceZeros = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            priceZeros *= 10L;
        }
        Vector<EcrSale> realSales = new Vector<EcrSale>();
        Vector<EcrSale> returSales = new Vector<EcrSale>();
        boolean bonCuRetur = false;
        for (EcrSale sale : sales) {
            if (sale.getQuantity() < 0.0) {
                returSales.add(sale);
                bonCuRetur = true;
                continue;
            }
            realSales.add(sale);
        }
        for (EcrSale newsaleentry : realSales) {
            String product = newsaleentry.getProduct();
            double nrPortii = newsaleentry.getQuantity();
            double orig = newsaleentry.getPpuOriginal();
            double cuReducere = newsaleentry.getPpuDupaDiscount();
            if (bonCuRetur) {
                orig = cuReducere;
            }
            long p = (long)((double)priceZeros * orig);
            long q = (long)(100000.0 * nrPortii);
            String codTva = "" + this.tvaDefault;
            if (Validators.correctString(newsaleentry.getCodTva())) {
                codTva = newsaleentry.getCodTva();
            }
            String prodLabel = Utils.getStringMaxSize(18, product, Character.valueOf(' '), false);
            String commandText = "1;" + prodLabel + ";1;" + codTva + ";" + p + ";" + q;
            items = items + commandText;
            items = items + "\n";
            if (orig != cuReducere) {
                String tip = "";
                long origL = (long)((double)priceZeros * orig);
                long cuReducereL = (long)((double)priceZeros * cuReducere);
                long val = 0L;
                if (orig > cuReducere) {
                    tip = "1";
                    val = origL - cuReducereL;
                } else {
                    tip = "0";
                    val = cuReducereL - origL;
                }
                String line = "7;" + tip + ";0;1;0;" + val + ";1";
                items = items + line + "\n";
            }
            double totalReturAcum = 0.0;
            for (EcrSale returSale : returSales) {
                double diff;
                double returCurent;
                if (returSale.getReturPending() <= 0.0) continue;
                double valoareProdus = newsaleentry.getReturPending();
                if (valoareProdus == (returCurent = returSale.getReturPending())) {
                    returSale.setReturPending(0.0);
                    totalReturAcum = returCurent;
                    break;
                }
                if (valoareProdus > returCurent) {
                    diff = valoareProdus - returCurent;
                    newsaleentry.setReturPending(diff);
                    returSale.setReturPending(0.0);
                    totalReturAcum += returCurent;
                    continue;
                }
                if (!(valoareProdus < returCurent)) continue;
                diff = returCurent - valoareProdus;
                returSale.setReturPending(diff);
                totalReturAcum = valoareProdus;
                break;
            }
            if (!(totalReturAcum > 0.0)) continue;
            String tip = "";
            tip = "1";
            long val = (long)(totalReturAcum * (double)priceZeros);
            String line = "7;" + tip + ";0;1;0;" + val + ";1";
            items = items + line + "\n";
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = comments.elementAt(i);
            if (!Validators.correctString(o = o.toUpperCase())) {
                o = "*";
            }
            int chunck = 20;
            int index = 0;
            while (index < o.length()) {
                int end = index;
                end = index + chunck > o.length() ? o.length() : index + chunck;
                String s = o.substring(index, end);
                s = Utils.getStringMaxSize(32, s, Character.valueOf(' '), false);
                String line = "2;" + s;
                items = items + line + "\n";
                index = end;
            }
        }
        if (plati == null || plati.size() == 0) {
            long totalL = (long)(total * (double)priceZeros);
            items = items + "5;" + totalL + ";1;1;0\n";
        } else {
            double totalPlatit = 0.0;
            for (EcrPlata plata : plati) {
                double p = plata.getSuma();
                String s = "";
                long l = (long)(p * (double)priceZeros);
                s = l + "";
                items = items + "5;" + s + ";" + plata.getEcrMapping() + ";1;0;\n";
                totalPlatit += plata.getSuma();
            }
            if (totalPlatit < total) {
                double p = total - totalPlatit;
                String s = "";
                long l = (long)(p * (double)priceZeros);
                s = l + "";
                items = items + "5;" + s + ";" + cashDefault.getEcrMapping() + ";1;0;\n";
            }
        }
        this.pt.addToQueue(items);
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void printNonFiscalBon(String inputFile) {
        File f = new File(inputFile);
        String outputFile = this.onlineNfDestinationMask.replaceAll("%%nrbon", "" + this.nonFiscalIndex);
        File outF = new File(outputFile);
        int tries = 10;
        boolean done = false;
        while (!done && tries > 0) {
            done = f.renameTo(outF);
            --tries;
            if (done) continue;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {}
        }
        if (!done) {
            Logger.logError((Object)this, "EROARE LA MUTARE FISIER !");
        }
    }
}

