/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optima;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;

public class Optikey
extends AbstractCashRegister {
    private int denumireCharLength = 12;
    private String departamentComentarii = "3";

    @Override
    public void introduNumerar(double suma) {
    }

    private String getQtyString(double value) {
        DecimalFormat df = new DecimalFormat("###0.###");
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols(Locale.getDefault());
        unusualSymbols.setDecimalSeparator(',');
        String output = df.format(value);
        return output;
    }

    @Override
    public boolean numerarInputReady() {
        return false;
    }

    @Override
    public void buildConfiguration(Properties conf) {
        super.buildConfiguration(conf);
        this.denumireCharLength = Integer.parseInt(conf.getProperty("denumireCharLength", "12"));
        this.onlineDecimalPlaces = 2;
        this.departamentComentarii = conf.getProperty("departamentComentarii", "3");
    }

    public void printBonFiscal(Vector sales, double total, Vector plati, TipPlata cashDefault, Vector comments, String orderIdentifier, int idOrder) {
        String lineEnd = "\r\n";
        String items = "1;" + lineEnd;
        long printPrice = 1L;
        for (int i = 0; i < this.onlineDecimalPlaces; ++i) {
            printPrice *= 10L;
        }
        for (EcrSale newsaleentry : sales) {
            double procent;
            String product = newsaleentry.getProduct();
            product = product.replace(';', '_');
            String prodLabel = Utils.getStringMaxSize(this.denumireCharLength, product, null, false);
            String deptLabel = Utils.getStringMaxSize(2, newsaleentry.getDepartament(), null, false);
            double qty = FloatUtils.roundDoubleUp(newsaleentry.getQuantity(), 2);
            double pretNou = FloatUtils.roundDoubleUp(newsaleentry.getPpuDupaDiscount(), 2);
            double orig = FloatUtils.roundDoubleUp(newsaleentry.getPpuOriginal(), 2);
            double newPrice = FloatUtils.roundDouble(orig * (double)printPrice, 2);
            long origLong = (long)newPrice;
            String currentLine = "S;" + prodLabel + ";" + origLong + ";" + this.getQtyString(qty) + ";" + deptLabel + ";" + lineEnd;
            items = items + currentLine;
            if (!Utils.isValueGreaterThanZero(Math.abs(orig - pretNou))) continue;
            String line = "K;";
            String tip = "";
            if (orig > pretNou) {
                tip = "-%";
                procent = (orig - pretNou) * 100.0 / orig;
                if ((procent = FloatUtils.roundDoubleUp(procent, 2)) == 100.0) {
                    procent = 99.99;
                }
                line = line + Utils.getString2DecimalsNoTrunc(procent) + ";" + tip + ";;;;;;;" + lineEnd;
            } else {
                tip = "+%";
                procent = 100.0 * pretNou / orig - 100.0;
                if ((procent = FloatUtils.roundDoubleUp(procent, 2)) == 100.0) {
                    procent = 99.99;
                }
                line = line + Utils.getString2DecimalsNoTrunc(procent) + ";" + tip + ";;;;;;;" + lineEnd;
            }
            items = items + line;
        }
        for (int i = 0; i < comments.size(); ++i) {
            String o = (String)comments.elementAt(i);
            if (!Validators.correctString(o = o.toUpperCase())) {
                o = "*";
            }
            o = o.replace(';', '_');
            int chunck = this.denumireCharLength;
            int index = 0;
            while (index < o.length()) {
                int end = index;
                end = index + chunck > o.length() ? o.length() : index + chunck;
                String s = o.substring(index, end);
                s = Utils.getStringMaxSize(this.denumireCharLength, s, Character.valueOf(' '), false);
                String line = "D;" + s + ";100;1,00;" + this.departamentComentarii + ";" + lineEnd;
                items = items + line;
                index = end;
            }
        }
        if (plati == null || plati.size() == 0) {
            items = items + "T;;;;;;;;;;;;;" + lineEnd;
        } else {
            double newPrice;
            double totalPlatit = 0.0;
            int pairs = 0;
            String line = "T";
            for (EcrPlata plata : plati) {
                double p = FloatUtils.roundDoubleUp(plata.getSuma(), 2);
                newPrice = FloatUtils.roundDouble(p * (double)printPrice, 2);
                long origLong = (long)newPrice;
                line = line + ";" + origLong + ";" + plata.getEcrMapping();
                totalPlatit += p;
                ++pairs;
            }
            double diff = total - totalPlatit;
            if (Utils.isValueGreaterThanZero(diff)) {
                double v = FloatUtils.roundDoubleUp(diff, 2);
                newPrice = FloatUtils.roundDouble(v * (double)printPrice, 2);
                long origLong = (long)newPrice;
                line = line + ";" + origLong + ";" + cashDefault.getEcrMapping();
                ++pairs;
            }
            int requiredPairs = 6;
            for (int i = pairs; i <= requiredPairs; ++i) {
                line = line + ";;";
            }
            line = line + ";";
            items = items + line + lineEnd;
        }
        this.pt.addToQueue(items);
    }

    @Override
    public void forceTotal() {
    }
}

